/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.lightoverlay;

import at.feldim2425.moreoverlays.config.Config;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;

public class LightOverlayRenderer {
    private static final ResourceLocation BLANK_TEX = new ResourceLocation("moreoverlays", "textures/blank.png");
    private static final AxisAlignedBB TEST_BB = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 1.0, 0.7);
    private static Map.Entry<BlockPos, Byte>[] overlayCache;
    private static RenderManager render;

    public static void renderOverlays() {
        if (overlayCache == null) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(BLANK_TEX);
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GL11.glLineWidth((float)Config.render_spawnLineWidth);
        GlStateManager.func_179137_b((double)(-LightOverlayRenderer.render.field_78730_l), (double)(-LightOverlayRenderer.render.field_78731_m), (double)(-LightOverlayRenderer.render.field_78728_n));
        float ar = (float)(Config.render_spawnAColor >> 16 & 0xFF) / 255.0f;
        float ag = (float)(Config.render_spawnAColor >> 8 & 0xFF) / 255.0f;
        float ab = (float)(Config.render_spawnAColor & 0xFF) / 255.0f;
        float nr = (float)(Config.render_spawnNColor >> 16 & 0xFF) / 255.0f;
        float ng = (float)(Config.render_spawnNColor >> 8 & 0xFF) / 255.0f;
        float nb = (float)(Config.render_spawnNColor & 0xFF) / 255.0f;
        for (int i = 0; i < overlayCache.length; ++i) {
            Map.Entry<BlockPos, Byte> entry = overlayCache[i];
            Byte mode = entry.getValue();
            if (mode == null || mode == 0) continue;
            if (mode == 1) {
                LightOverlayRenderer.renderCross(entry.getKey(), nr, ng, nb);
                continue;
            }
            if (mode != 2) continue;
            LightOverlayRenderer.renderCross(entry.getKey(), ar, ag, ab);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public static synchronized void refreshCache() {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        int px = (int)Math.floor(player.field_70165_t);
        int py = Math.min(Math.max((int)player.field_70163_u, 0), player.field_70170_p.func_72800_K() - 1);
        int pz = (int)Math.floor(player.field_70161_v);
        int y1 = py - Config.light_DownRange < 0 ? 0 : py - Config.light_DownRange;
        int y2 = py + Config.light_UpRange > player.field_70170_p.func_72800_K() - 1 ? player.field_70170_p.func_72800_K() - 1 : py + Config.light_UpRange;
        HashMap<BlockPos, Byte> newCache = new HashMap<BlockPos, Byte>();
        for (int xo = -Config.light_HRange; xo <= Config.light_HRange; ++xo) {
            for (int zo = -Config.light_HRange; zo <= Config.light_HRange; ++zo) {
                BlockPos pos1 = new BlockPos(px + xo, py, pz + zo);
                Biome biome = player.field_70170_p.func_180494_b(pos1);
                if (biome.func_76741_f() <= 0.0f || biome.func_76747_a(EnumCreatureType.MONSTER).isEmpty()) continue;
                Chunk chunk = player.field_70170_p.func_175726_f(pos1);
                for (int y = y1; y <= y2; ++y) {
                    BlockPos pos = new BlockPos(px + xo, y, pz + zo);
                    byte mode = LightOverlayRenderer.getSpawnModeAt(pos, chunk, player.field_70170_p);
                    if (mode == 0) continue;
                    newCache.put(pos, mode);
                }
            }
        }
        overlayCache = newCache.entrySet().toArray(new Map.Entry[newCache.size()]);
    }

    private static byte getSpawnModeAt(BlockPos pos, Chunk chunk, World world) {
        if (chunk.func_177413_a(EnumSkyBlock.BLOCK, pos) >= Config.light_SaveLevel) {
            return 0;
        }
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        if (!state.func_177230_c().canCreatureSpawn(state, (IBlockAccess)world, pos.func_177977_b(), EntityLiving.SpawnPlacementType.ON_GROUND)) {
            return 0;
        }
        if (!LightOverlayRenderer.checkCollision(pos, world)) {
            return 0;
        }
        if (chunk.func_177413_a(EnumSkyBlock.SKY, pos) >= Config.light_SaveLevel) {
            return 1;
        }
        return 2;
    }

    private static boolean checkCollision(BlockPos pos, World world) {
        IBlockState block1 = world.func_180495_p(pos);
        if (block1.func_185915_l() || !Config.light_IgnoreLayer && world.func_180495_p(pos.func_177984_a()).func_185915_l()) {
            return false;
        }
        if (world.func_175623_d(pos) && (Config.light_IgnoreLayer || world.func_175623_d(pos.func_177984_a()))) {
            return true;
        }
        AxisAlignedBB bb = TEST_BB.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        if (world.func_147461_a(bb).isEmpty() && !world.func_72953_d(bb)) {
            if (Config.light_IgnoreLayer) {
                return true;
            }
            AxisAlignedBB bb2 = bb.func_72317_d(0.0, 1.0, 0.0);
            return world.func_147461_a(bb2).isEmpty() && !world.func_72953_d(bb2);
        }
        return false;
    }

    private static void renderCross(BlockPos pos, float r, float g, float b) {
        double y = (double)pos.func_177956_o() + 0.005;
        double x0 = pos.func_177958_n();
        double x1 = x0 + 1.0;
        double z0 = pos.func_177952_p();
        double z1 = z0 + 1.0;
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer renderer = tess.func_178180_c();
        renderer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b(x0, y, z0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x1, y, z1).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x1, y, z0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x0, y, z1).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tess.func_78381_a();
    }

    public static void clearCache() {
        overlayCache = null;
    }

    static {
        render = Minecraft.func_71410_x().func_175598_ae();
    }
}

