/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.itemsearch;

import at.feldim2425.moreoverlays.MoreOverlays;
import at.feldim2425.moreoverlays.api.itemsearch.IViewSlot;
import at.feldim2425.moreoverlays.api.itemsearch.SlotHandler;
import at.feldim2425.moreoverlays.itemsearch.JeiModule;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class GuiRenderer {
    public static final GuiRenderer INSTANCE = new GuiRenderer();
    private static final float OVERLAY_ZLEVEL = 299.0f;
    private static final int TEXT_FADEOUT = 20;
    private static final int FRAME_RADIUS = 1;
    private static boolean enabled = false;
    private static String lastFilterText = "";
    private static boolean emptyFilter = true;
    private static BiMap<Integer, IViewSlot> views = HashBiMap.create();
    private static int highlightTicks = 0;
    private boolean isCreative = false;
    private boolean allowRender = false;
    private int guiOffsetX = 0;
    private int guiOffsetY = 0;

    public void guiInit(GuiScreen gui) {
        if (!this.canShowIn(gui)) {
            return;
        }
        highlightTicks = 0;
        try {
            Field left = ReflectionHelper.findField(GuiContainer.class, (String[])new String[]{"field_147003_i", "guiLeft"});
            left.setAccessible(true);
            this.guiOffsetX = left.getInt(gui);
            Field top = ReflectionHelper.findField(GuiContainer.class, (String[])new String[]{"field_147009_r", "guiTop"});
            top.setAccessible(true);
            this.guiOffsetY = top.getInt(gui);
        }
        catch (Exception e) {
            MoreOverlays.logger.error("Something went wrong. Tried to load gui coords with java reflection. Gui class: " + gui.getClass().getName());
            e.printStackTrace();
        }
    }

    public void guiOpen(GuiScreen gui) {
        this.isCreative = gui instanceof GuiContainerCreative;
    }

    public void preDraw() {
        GuiScreen guiscr = Minecraft.func_71410_x().field_71462_r;
        GuiTextField textField = JeiModule.getJEITextField();
        if (this.canShowIn(guiscr)) {
            this.allowRender = true;
            if (textField != null && enabled) {
                this.drawSearchFrame(textField);
            }
        }
    }

    public void postDraw() {
        GuiScreen guiscr = Minecraft.func_71410_x().field_71462_r;
        if (this.allowRender && this.canShowIn(guiscr)) {
            this.allowRender = false;
            this.drawSlotOverlay((GuiContainer)guiscr);
        }
    }

    private void drawSearchFrame(GuiTextField textField) {
        RenderHelper.func_74518_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179126_j();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer buffer = tess.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b((double)(textField.field_146209_f + textField.field_146218_h + 1), (double)(textField.field_146210_g - 1), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(textField.field_146209_f - 1), (double)(textField.field_146210_g - 1), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(textField.field_146209_f - 1), (double)textField.field_146210_g, 1000.0).func_181675_d();
        buffer.func_181662_b((double)(textField.field_146209_f + textField.field_146218_h + 1), (double)textField.field_146210_g, 1000.0).func_181675_d();
        buffer.func_181662_b((double)textField.field_146209_f, (double)textField.field_146210_g, 1000.0).func_181675_d();
        buffer.func_181662_b((double)(textField.field_146209_f - 1), (double)textField.field_146210_g, 1000.0).func_181675_d();
        buffer.func_181662_b((double)(textField.field_146209_f - 1), (double)(textField.field_146210_g + textField.field_146219_i), 1000.0).func_181675_d();
        buffer.func_181662_b((double)textField.field_146209_f, (double)(textField.field_146210_g + textField.field_146219_i), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(textField.field_146209_f + textField.field_146218_h + 1), (double)(textField.field_146210_g + textField.field_146219_i), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(textField.field_146209_f - 1), (double)(textField.field_146210_g + textField.field_146219_i), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(textField.field_146209_f - 1), (double)(textField.field_146210_g + textField.field_146219_i + 1), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(textField.field_146209_f + textField.field_146218_h + 1), (double)(textField.field_146210_g + textField.field_146219_i + 1), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(textField.field_146209_f + textField.field_146218_h + 1), (double)textField.field_146210_g, 1000.0).func_181675_d();
        buffer.func_181662_b((double)(textField.field_146209_f + textField.field_146218_h), (double)textField.field_146210_g, 1000.0).func_181675_d();
        buffer.func_181662_b((double)(textField.field_146209_f + textField.field_146218_h), (double)(textField.field_146210_g + textField.field_146219_i), 1000.0).func_181675_d();
        buffer.func_181662_b((double)(textField.field_146209_f + textField.field_146218_h + 1), (double)(textField.field_146210_g + textField.field_146219_i), 1000.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
    }

    public void renderTooltip(ItemStack stack) {
        GuiContainer gui;
        GuiScreen guiscr = Minecraft.func_71410_x().field_71462_r;
        if (this.allowRender && this.canShowIn(guiscr) && (gui = (GuiContainer)guiscr).getSlotUnderMouse() != null && gui.getSlotUnderMouse().func_75216_d() && gui.getSlotUnderMouse().func_75211_c().equals(stack)) {
            this.allowRender = false;
            this.drawSlotOverlay((GuiContainer)guiscr);
        }
    }

    private void drawSlotOverlay(GuiContainer gui) {
        RenderHelper.func_74518_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!enabled || this.isCreative || views == null || views.isEmpty()) {
            return;
        }
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer renderer = tess.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (Map.Entry slot : views.entrySet()) {
            int px = ((IViewSlot)slot.getValue()).getRenderPosX(this.guiOffsetX, this.guiOffsetY);
            int py = ((IViewSlot)slot.getValue()).getRenderPosY(this.guiOffsetX, this.guiOffsetY);
            renderer.func_181662_b((double)(px + 16 + this.guiOffsetX), (double)(py + this.guiOffsetY), 299.0).func_181675_d();
            renderer.func_181662_b((double)(px + this.guiOffsetX), (double)(py + this.guiOffsetY), 299.0).func_181675_d();
            renderer.func_181662_b((double)(px + this.guiOffsetX), (double)(py + 16 + this.guiOffsetY), 299.0).func_181675_d();
            renderer.func_181662_b((double)(px + 16 + this.guiOffsetX), (double)(py + 16 + this.guiOffsetY), 299.0).func_181675_d();
        }
        tess.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }

    public boolean canShowIn(GuiScreen gui) {
        return gui instanceof GuiContainer && !this.isCreative && ((GuiContainer)gui).field_147002_h != null && !((GuiContainer)gui).field_147002_h.field_75151_b.isEmpty();
    }

    private void checkSlots(GuiContainer container) {
        if (views == null) {
            views = HashBiMap.create();
        } else {
            views.clear();
        }
        for (Slot slot : container.field_147002_h.field_75151_b) {
            IViewSlot slotv = SlotHandler.INSTANCE.getViewSlot(container, slot);
            if (!slotv.canSearch() || this.isSearchedItem(slot.func_75211_c())) continue;
            views.forcePut((Object)slot.field_75222_d, (Object)slotv);
        }
    }

    private boolean isSearchedItem(ItemStack stack) {
        if (emptyFilter) {
            return true;
        }
        if (stack == null) {
            return false;
        }
        for (ItemStack stack1 : JeiModule.overlay.getFilteredStacks()) {
            if (!stack1.func_77969_a(stack) && (stack1.func_77973_b() != stack.func_77973_b() || !stack1.func_77973_b().func_77645_m())) continue;
            return true;
        }
        return false;
    }

    public void tick() {
        if (!this.canShowIn(Minecraft.func_71410_x().field_71462_r)) {
            return;
        }
        if (enabled && !JeiModule.overlay.getFilterText().equals(lastFilterText)) {
            lastFilterText = JeiModule.overlay.getFilterText();
            emptyFilter = lastFilterText.replace(" ", "").isEmpty();
        }
        if (enabled && Minecraft.func_71410_x().field_71462_r instanceof GuiContainer) {
            this.checkSlots((GuiContainer)Minecraft.func_71410_x().field_71462_r);
        } else if (views != null) {
            views.clear();
        }
        if (highlightTicks > 0) {
            --highlightTicks;
        }
    }

    public void toggleMode() {
        boolean bl = enabled = !enabled;
        if (enabled) {
            lastFilterText = JeiModule.overlay.getFilterText();
            emptyFilter = lastFilterText.replace(" ", "").isEmpty();
        } else {
            lastFilterText = "";
        }
        highlightTicks = 20;
    }

    public boolean isEnabled() {
        return enabled;
    }
}

