/*
 * Decompiled with CFR 0.152.
 */
package mods.belgabor.bitdrawers.core;

import java.util.HashMap;
import java.util.Map;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IBitVisitor;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.helpers.ModUtil;
import mods.belgabor.bitdrawers.BitDrawers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class BitHelper {
    public static boolean areItemsEqual(ItemStack a, ItemStack b) {
        return ItemStack.func_179545_c((ItemStack)a, (ItemStack)b) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public static ItemStack getBit(ItemStack stack) {
        IBlockState blockState;
        Block block;
        if (stack.func_77973_b() instanceof ItemBlock && (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) != null && (blockState = block.func_176203_a(stack.func_77952_i())) != null) {
            try {
                ItemStack bitStack = BitDrawers.cnb_api.getBitItem(blockState);
                if (bitStack.func_77973_b() != null) {
                    return bitStack;
                }
            }
            catch (APIExceptions.InvalidBitItem invalidBitItem) {
                // empty catch block
            }
        }
        return null;
    }

    public static ItemStack getBlock(ItemStack stack) {
        if (BitDrawers.cnb_api.getItemType(stack) == ItemType.CHISLED_BIT) {
            Block block;
            ItemStack newStack;
            IBlockState blockState;
            IBitBrush bitBrush = null;
            try {
                bitBrush = BitDrawers.cnb_api.createBrush(stack);
            }
            catch (APIExceptions.InvalidBitItem invalidBitItem) {
                // empty catch block
            }
            if (bitBrush != null && (blockState = bitBrush.getState()) != null && (newStack = new ItemStack(block = blockState.func_177230_c(), 1, block.func_180651_a(blockState))).func_77973_b() != null) {
                return newStack;
            }
        }
        return null;
    }

    public static ItemStack getMonochrome(ItemStack source, IBitBrush brush) {
        BitCopy visitor;
        boolean set = BitDrawers.cnb_api.getItemType(source) == ItemType.NEGATIVE_DESIGN;
        try {
            visitor = new BitCopy(BitDrawers.cnb_api.createBitItem(source), brush, set);
        }
        catch (APIExceptions.InvalidBitItem e) {
            return null;
        }
        IBitAccess resultAccessor = BitDrawers.cnb_api.createBitItem(null);
        resultAccessor.visitBits((IBitVisitor)visitor);
        if (visitor.count == 0) {
            return null;
        }
        ItemStack item = resultAccessor.getBitsAsItem(ModUtil.getSide((ItemStack)source), ItemType.CHISLED_BLOCK, false);
        item.field_77994_a = visitor.count;
        return item;
    }

    public static class BitCounter
    implements IBitVisitor {
        public Map<Integer, Integer> counts = new HashMap<Integer, Integer>();

        public IBitBrush visitBit(int x, int y, int z, IBitBrush brush) {
            if (!brush.isAir()) {
                if (!this.counts.containsKey(brush.getStateID())) {
                    this.counts.put(brush.getStateID(), 0);
                }
                this.counts.put(brush.getStateID(), this.counts.get(brush.getStateID()) + 1);
            }
            return brush;
        }
    }

    public static class BitCopy
    implements IBitVisitor {
        private final IBitAccess source;
        private final IBitBrush bit;
        private final IBitBrush air;
        private final boolean negative;
        public int count = 0;

        public BitCopy(IBitAccess source, IBitBrush bit, boolean negative) throws APIExceptions.InvalidBitItem {
            if (source == null) {
                throw new APIExceptions.InvalidBitItem();
            }
            this.source = source;
            this.bit = bit;
            this.air = BitDrawers.cnb_api.createBrush(null);
            this.negative = negative;
        }

        public IBitBrush visitBit(int x, int y, int z, IBitBrush dummy) {
            IBitBrush sourceBit = this.source.getBitAt(x, y, z);
            if (sourceBit.isAir() == this.negative) {
                ++this.count;
                return this.bit;
            }
            return this.air;
        }
    }
}

