/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.tileentity.chunkloaders;

import com.mojang.authlib.GameProfile;
import com.valkyrieofnight.environmentaltech.tileentity.chunkloaders.PlayerLoaderManager;
import com.valkyrieofnight.valkyrielib.tileentity.VLTileEntity;
import com.valkyrieofnight.valkyrielib.util.helpers.PlayerUtil;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;

public class TileChunkLoaderBasic
extends VLTileEntity
implements ITickable {
    private ForgeChunkManager.Ticket ticket;
    private GameProfile owner;
    private ChunkPos loaded;
    private static final int cost = 40;
    private boolean isLoaded = false;
    private int tick = 0;
    private boolean dirty = true;

    public TileChunkLoaderBasic() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.getLoading()) {
            this.setLoading(true);
        }
    }

    public void setLoading(boolean opt) {
        if (opt) {
            ForgeChunkManager.Ticket test = PlayerLoaderManager.getInstance().getPlayerTicket(this.owner, this.field_145850_b);
            if (test != null) {
                this.ticket = test;
                PlayerLoaderManager.getInstance().addToTicket(this.ticket, this.loaded);
                this.isLoaded = true;
            }
        } else if (this.ticket != null) {
            PlayerLoaderManager.getInstance().removeFromTicket(this.ticket, this.loaded);
            this.isLoaded = false;
        }
    }

    public void debug() {
        if (!this.field_145850_b.field_72995_K) {
            this.setLoading(true);
        }
    }

    public boolean getLoading() {
        return PlayerLoaderManager.getInstance().isLoading(this.ticket, this.loaded);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public void onLoad() {
        super.onLoad();
    }

    public void blockPlaced() {
        this.loaded = PlayerLoaderManager.getChunkPos(this.field_174879_c);
    }

    public void blockBreak() {
        if (this.ticket != null) {
            PlayerLoaderManager.getInstance().removeFromTicket(this.ticket, this.loaded);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("loaded")) {
            long l = nbt.func_74763_f("loaded");
            this.loaded = PlayerLoaderManager.deserializeChunkPos(l);
        }
        this.owner = PlayerUtil.profileFromNBT((NBTTagCompound)nbt.func_74775_l("profile"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74772_a("loaded", PlayerLoaderManager.serializeChunkPos(this.loaded));
        if (this.owner != null) {
            nbt.func_74782_a("profile", (NBTBase)PlayerUtil.proifleToNBT((GameProfile)this.owner));
        }
        return nbt;
    }

    public void setPlayer(EntityPlayer plr) {
        if (plr != null) {
            this.owner = plr.func_146103_bH();
        }
    }

    public void setPlayer(UUID plr) {
        EntityPlayer pl = PlayerUtil.getPlayerFromWorld((World)this.field_145850_b, (UUID)plr);
        if (pl != null) {
            this.owner = pl.func_146103_bH();
        }
    }

    public UUID getPlayerID() {
        return this.owner.getId();
    }

    public GameProfile getPlayerProfile() {
        return this.owner;
    }
}

