/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.lwjgl.input.Keyboard;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModItems;
import xreliquary.items.ItemToggleable;
import xreliquary.items.util.FilteredItemStackHandler;
import xreliquary.items.util.VoidTearItemStackHandler;
import xreliquary.network.PacketContainerItemHandlerSync;
import xreliquary.network.PacketHandler;
import xreliquary.network.PacketItemHandlerSync;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.StackHelper;

public class ItemVoidTear
extends ItemToggleable {
    private static Map<UUID, VoidTearListener> openListeners = new HashMap<UUID, VoidTearListener>();
    private static final Field LISTENERS = ReflectionHelper.findField(Container.class, (String[])new String[]{"field_75149_d", "listeners"});

    public ItemVoidTear() {
        super("void_tear");
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77637_a(null);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ICapabilitySerializable<NBTTagCompound>(){
            VoidTearItemStackHandler itemHandler = new VoidTearItemStackHandler();

            public NBTTagCompound serializeNBT() {
                return this.itemHandler.serializeNBT();
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                this.itemHandler.deserializeNBT(nbt);
            }

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return (T)this.itemHandler;
                }
                return null;
            }
        };
    }

    @Override
    public boolean func_77636_d(ItemStack stack) {
        return !Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54) && super.func_77636_d(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean par4) {
        this.formatTooltip(null, stack, list);
        ItemStack contents = this.getContainerItem(stack);
        if (contents == null) {
            return;
        }
        if (this.isEnabled(stack)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.YELLOW + contents.func_82833_r())), list);
            list.add(LanguageHelper.getLocalization("tooltip.absorb_tear"));
        }
        LanguageHelper.formatTooltip("tooltip.tear_quantity", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)contents.func_82833_r(), (Object)"amount", (Object)Integer.toString(this.getItemQuantity(stack))), list);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack voidTear, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            if (this.getItemQuantity(voidTear) == 0) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)ModItems.emptyVoidTear, 1, 0));
            }
            RayTraceResult rayTraceResult = this.func_77621_a(world, player, false);
            if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && (world.func_175625_s(rayTraceResult.func_178782_a()) instanceof IInventory && player.func_70093_af() || this.getContainerItem(voidTear).func_77973_b() instanceof ItemBlock)) {
                return new ActionResult(EnumActionResult.PASS, (Object)voidTear);
            }
            if (player.func_70093_af()) {
                return super.func_77659_a(voidTear, world, player, hand);
            }
            if (this.attemptToEmptyIntoInventory(voidTear, player, (IInventory)player.field_71071_by)) {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187607_bg, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
                NBTHelper.resetTag(voidTear);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)ModItems.emptyVoidTear, 1, 0));
            }
        }
        player.field_71069_bz.func_75142_b();
        return new ActionResult(EnumActionResult.PASS, (Object)voidTear);
    }

    private boolean canPlaceBlockOnSide(World worldIn, Block blockToPlace, BlockPos pos, EnumFacing side, ItemStack stack) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150431_aC && block.func_176200_f((IBlockAccess)worldIn, pos)) {
            side = EnumFacing.UP;
        } else if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(side);
        }
        return worldIn.func_175716_a(blockToPlace, pos, false, side, null, stack);
    }

    public void func_77663_a(ItemStack voidTear, World world, Entity entity, int slotNumber, boolean isSelected) {
        if (voidTear.func_77978_p() != null && voidTear.func_77978_p().func_74764_b("item")) {
            this.setItemStack(voidTear, ItemStack.func_77949_a((NBTTagCompound)NBTHelper.getTagCompound("item", voidTear)));
            this.setItemQuantity(voidTear, NBTHelper.getInteger("itemQuantity", voidTear));
            voidTear.func_77978_p().func_82580_o("item");
            voidTear.func_77978_p().func_82580_o("itemQuantity");
        }
        if (!world.field_72995_K) {
            ItemStack contents;
            if (!(entity instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entity;
            boolean quantityUpdated = false;
            if (this.isEnabled(voidTear) && (contents = this.getContainerItem(voidTear)) != null) {
                int itemQuantity = InventoryHelper.getItemQuantity(contents, (IInventory)player.field_71071_by);
                if (this.getItemQuantity(voidTear) <= Settings.VoidTear.itemLimit && itemQuantity > this.getKeepQuantity(voidTear) && InventoryHelper.consumeItem(contents, player, this.getKeepQuantity(voidTear), itemQuantity - this.getKeepQuantity(voidTear)) && !player.field_71075_bZ.field_75098_d) {
                    this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) + itemQuantity - this.getKeepQuantity(voidTear));
                    quantityUpdated = true;
                }
                if (this.getMode(voidTear) != Mode.NO_REFILL && this.attemptToReplenish(player, voidTear)) {
                    quantityUpdated = true;
                }
            }
            if (player.field_71071_by.func_70301_a(slotNumber) != null && player.field_71071_by.func_70301_a(slotNumber).func_77973_b() == ModItems.filledVoidTear && (isSelected || quantityUpdated)) {
                PacketHandler.networkWrapper.sendTo((IMessage)new PacketItemHandlerSync(slotNumber, this.getItemHandlerNBT(voidTear)), (EntityPlayerMP)player);
            } else if (player.field_71071_by.field_184439_c[0] != null && player.field_71071_by.field_184439_c[0].func_77973_b() == ModItems.filledVoidTear) {
                PacketHandler.networkWrapper.sendTo((IMessage)new PacketItemHandlerSync(EnumHand.OFF_HAND, this.getItemHandlerNBT(voidTear)), (EntityPlayerMP)player);
            }
        }
    }

    private NBTTagCompound getItemHandlerNBT(ItemStack ist) {
        IItemHandler itemHandler = (IItemHandler)ist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return null;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        return filteredHandler.serializeNBT();
    }

    private boolean attemptToReplenish(EntityPlayer player, ItemStack voidTear) {
        int quantityToDecrease;
        int slot;
        InventoryPlayer inventory = player.field_71071_by;
        for (slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stackFound = inventory.func_70301_a(slot);
            if (stackFound == null || !StackHelper.isItemAndNbtEqual(stackFound, this.getContainerItem(voidTear))) continue;
            quantityToDecrease = Math.min(stackFound.func_77976_d() - stackFound.field_77994_a, this.getItemQuantity(voidTear) - 1);
            stackFound.field_77994_a += quantityToDecrease;
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - quantityToDecrease);
            if (this.getMode(voidTear) == Mode.FULL_INVENTORY) continue;
            return true;
        }
        while (this.getItemQuantity(voidTear) > 1 && (slot = player.field_71071_by.func_70447_i()) != -1) {
            ItemStack newStack = this.getContainerItem(voidTear).func_77946_l();
            newStack.field_77994_a = quantityToDecrease = Math.min(newStack.func_77976_d(), this.getItemQuantity(voidTear) - 1);
            player.field_71071_by.func_70299_a(slot, newStack);
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - quantityToDecrease);
            if (this.getMode(voidTear) == Mode.FULL_INVENTORY) continue;
            return true;
        }
        return false;
    }

    public EnumActionResult onItemUseFirst(ItemStack voidTear, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack containerItem;
        ItemBlock itemBlock;
        Block block;
        if (world.func_180495_p(pos).func_177230_c() == ModBlocks.pedestal) {
            return EnumActionResult.PASS;
        }
        if (world.func_175625_s(pos) instanceof IInventory) {
            if (!world.field_72995_K) {
                IInventory inventory = (IInventory)world.func_175625_s(pos);
                if (inventory instanceof TileEntityChest && world.func_180495_p(pos).func_177230_c() instanceof BlockChest) {
                    inventory = ((BlockChest)world.func_180495_p(pos).func_177230_c()).func_180676_d(world, pos);
                }
                if (this.isEnabled(voidTear)) {
                    this.drainInventory(voidTear, player, inventory);
                } else {
                    this.attemptToEmptyIntoInventory(voidTear, player, inventory);
                    if (!player.func_70093_af() && this.getItemQuantity(voidTear) <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack((Item)ModItems.emptyVoidTear, 1, 0));
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        } else if (this.getContainerItem(voidTear) != null && this.getContainerItem(voidTear).func_77973_b() instanceof ItemBlock && this.canPlaceBlockOnSide(world, block = (itemBlock = (ItemBlock)(containerItem = this.getContainerItem(voidTear)).func_77973_b()).func_179223_d(), pos, side, containerItem)) {
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - 1);
            itemBlock.func_180614_a(containerItem, player, world, pos, hand, side, hitX, hitY, hitZ);
        }
        return EnumActionResult.PASS;
    }

    private boolean attemptToEmptyIntoInventory(ItemStack ist, EntityPlayer player, IInventory inventory) {
        ItemStack contents = this.getContainerItem(ist);
        contents.field_77994_a = 1;
        int quantity = this.getItemQuantity(ist);
        int maxNumberToEmpty = player.func_70093_af() ? quantity : Math.min(contents.func_77976_d(), quantity);
        this.setItemQuantity(ist, quantity -= InventoryHelper.tryToAddToInventory(contents, inventory, maxNumberToEmpty));
        if (quantity == 0) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187607_bg, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.8f));
            return true;
        }
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187607_bg, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
        return false;
    }

    private void drainInventory(ItemStack ist, EntityPlayer player, IInventory inventory) {
        int quantity;
        ItemStack contents = this.getContainerItem(ist);
        int quantityDrained = InventoryHelper.tryToRemoveFromInventory(contents, inventory, Settings.VoidTear.itemLimit - (quantity = this.getItemQuantity(ist)));
        if (quantityDrained <= 0) {
            return;
        }
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187607_bg, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
        this.setItemQuantity(ist, quantity + quantityDrained);
    }

    public ItemStack getContainerItem(ItemStack voidTear) {
        IItemHandler itemHandler = (IItemHandler)voidTear.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return null;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        ItemStack stackToReturn = null;
        if (filteredHandler.getStackInParentSlot(0) != null) {
            stackToReturn = filteredHandler.getStackInParentSlot(0).func_77946_l();
            stackToReturn.field_77994_a = filteredHandler.getTotalAmount(0);
        }
        return stackToReturn;
    }

    void setItemStack(ItemStack voidTear, ItemStack stack) {
        IItemHandler itemHandler = (IItemHandler)voidTear.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        filteredHandler.setParentSlotStack(0, stack);
    }

    void setItemQuantity(ItemStack voidTear, int quantity) {
        IItemHandler itemHandler = (IItemHandler)voidTear.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        filteredHandler.setTotalAmount(0, quantity);
    }

    private int getItemQuantity(ItemStack voidTear) {
        IItemHandler itemHandler = (IItemHandler)voidTear.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return 0;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        return filteredHandler.getTotalAmount(0);
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack voidTear) {
        if (entityLiving.field_70170_p.field_72995_K || !(entityLiving instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (player.func_70093_af()) {
            this.cycleMode(voidTear);
            return true;
        }
        return false;
    }

    public Mode getMode(ItemStack voidTear) {
        if (NBTHelper.getString("mode", voidTear).isEmpty()) {
            this.setMode(voidTear, Mode.ONE_STACK);
        }
        return Mode.valueOf(NBTHelper.getString("mode", voidTear));
    }

    private void setMode(ItemStack voidTear, Mode mode) {
        NBTHelper.setString("mode", voidTear, mode.toString());
    }

    private void cycleMode(ItemStack voidTear) {
        Mode mode = this.getMode(voidTear);
        switch (mode) {
            case ONE_STACK: {
                this.setMode(voidTear, Mode.FULL_INVENTORY);
                break;
            }
            case FULL_INVENTORY: {
                this.setMode(voidTear, Mode.NO_REFILL);
                break;
            }
            case NO_REFILL: {
                this.setMode(voidTear, Mode.ONE_STACK);
            }
        }
    }

    private int getKeepQuantity(ItemStack voidTear) {
        Mode mode = this.getMode(voidTear);
        if (mode == Mode.NO_REFILL) {
            return 0;
        }
        if (mode == Mode.ONE_STACK) {
            return this.getContainerItem(voidTear).func_77976_d();
        }
        return Integer.MAX_VALUE;
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        ItemStack pickedUpStack = event.getItem().func_92059_d();
        EntityPlayer player = event.getEntityPlayer();
        EntityItem itemEntity = event.getItem();
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            int playerItemQuantity;
            ItemStack tearStack = player.field_71071_by.func_70301_a(slot);
            if (tearStack == null || tearStack.func_77973_b() != this || !this.isEnabled(tearStack)) continue;
            int tearItemQuantity = this.getItemQuantity(tearStack);
            if (!this.canAbsorbStack(pickedUpStack, tearStack) || (playerItemQuantity = InventoryHelper.getItemQuantity(pickedUpStack, (IInventory)player.field_71071_by)) + pickedUpStack.field_77994_a < this.getKeepQuantity(tearStack) && player.field_71071_by.func_70447_i() != -1) continue;
            this.setItemQuantity(tearStack, tearItemQuantity + pickedUpStack.field_77994_a);
            if (!itemEntity.func_174814_R()) {
                Random rand = new Random();
                itemEntity.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((rand.nextFloat() - rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            itemEntity.func_70106_y();
            event.setCanceled(true);
            break;
        }
    }

    boolean canAbsorbStack(ItemStack pickedUpStack, ItemStack tearStack) {
        return StackHelper.isItemAndNbtEqual(this.getContainerItem(tearStack), pickedUpStack) && this.getItemQuantity(tearStack) + pickedUpStack.field_77994_a <= Settings.VoidTear.itemLimit;
    }

    @SubscribeEvent
    public void onContainerOpen(PlayerContainerEvent.Open event) {
        EntityPlayer player = event.getEntityPlayer();
        if (event.getContainer() != player.field_71069_bz) {
            VoidTearListener listener = new VoidTearListener((EntityPlayerMP)player);
            event.getContainer().func_75132_a((IContainerListener)listener);
            openListeners.put(player.func_146103_bH().getId(), listener);
            listener.updateFullInventory(event.getContainer());
        }
    }

    private static List<IContainerListener> getListeners(Container container) {
        try {
            return (List)LISTENERS.get(container);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public void onContainerClose(PlayerContainerEvent.Close event) {
        EntityPlayer player = event.getEntityPlayer();
        if (event.getContainer() != player.field_71069_bz) {
            UUID playerId = player.func_146103_bH().getId();
            if (openListeners.keySet().contains(playerId)) {
                ItemVoidTear.getListeners(event.getContainer()).remove(openListeners.get(playerId));
                openListeners.remove(playerId);
            }
        }
    }

    public class VoidTearListener
    implements IContainerListener {
        private EntityPlayerMP player;

        public VoidTearListener(EntityPlayerMP player) {
            this.player = player;
        }

        public void func_71110_a(Container containerToSend, List<ItemStack> itemsList) {
        }

        public void func_71111_a(Container container, int slot, ItemStack stack) {
            if (stack != null && stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                this.updateFullInventory(container);
            }
        }

        private void updateVoidTear(Container container, int slot, ItemStack stack) {
            if (stack == null || stack.func_77973_b() != ModItems.filledVoidTear) {
                return;
            }
            PacketHandler.networkWrapper.sendTo((IMessage)new PacketContainerItemHandlerSync(slot, ItemVoidTear.this.getItemHandlerNBT(stack), container.field_75152_c), this.player);
        }

        public void updateFullInventory(Container container) {
            for (int slot = 0; slot < container.field_75151_b.size(); ++slot) {
                this.updateVoidTear(container, slot, container.func_75139_a(slot).func_75211_c());
            }
        }

        public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
        }

        public void func_175173_a(Container containerIn, IInventory inventory) {
        }
    }

    public static enum Mode {
        ONE_STACK,
        FULL_INVENTORY,
        NO_REFILL;

    }
}

