/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.init.ModItems;

public class EntityXRTippedArrow
extends EntityArrow {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityTippedArrow.class, (DataSerializer)DataSerializers.field_187192_b);
    private final Set<PotionEffect> customPotionEffects = Sets.newHashSet();

    public EntityXRTippedArrow(World worldIn) {
        super(worldIn);
    }

    public EntityXRTippedArrow(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityXRTippedArrow(World worldIn, EntityLivingBase shooter) {
        super(worldIn, shooter);
    }

    public void setPotionEffect(ItemStack stack) {
        List collection = PotionUtils.func_185190_b((ItemStack)stack);
        for (PotionEffect potioneffect : collection) {
            this.customPotionEffects.add(new PotionEffect(potioneffect));
        }
        this.field_70180_af.func_187227_b(COLOR, (Object)PotionUtils.func_185181_a((Collection)collection));
    }

    private void addEffect(PotionEffect effect) {
        this.customPotionEffects.add(effect);
        this.func_184212_Q().func_187227_b(COLOR, (Object)PotionUtils.func_185181_a(this.customPotionEffects));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70254_i) {
                if (this.field_184552_b % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.field_70254_i && this.field_184552_b != 0 && !this.customPotionEffects.isEmpty() && this.field_184552_b >= 600) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)0);
            this.customPotionEffects.clear();
            this.field_70180_af.func_187227_b(COLOR, (Object)0);
        }
    }

    private void spawnPotionParticles(int particleCount) {
        int i = this.getColor();
        if (i != 0 && particleCount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i & 0xFF) / 255.0;
            for (int j = 0; j < particleCount; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (!this.customPotionEffects.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (PotionEffect potioneffect : this.customPotionEffects) {
                nbttaglist.func_74742_a((NBTBase)potioneffect.func_82719_a(new NBTTagCompound()));
            }
            compound.func_74782_a("CustomPotionEffects", (NBTBase)nbttaglist);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        for (PotionEffect potioneffect : PotionUtils.func_185192_b((NBTTagCompound)compound)) {
            this.addEffect(potioneffect);
        }
        if (!this.customPotionEffects.isEmpty()) {
            this.field_70180_af.func_187227_b(COLOR, (Object)PotionUtils.func_185181_a(this.customPotionEffects));
        }
    }

    protected void func_184548_a(EntityLivingBase living) {
        super.func_184548_a(living);
        if (!this.customPotionEffects.isEmpty()) {
            for (PotionEffect potioneffect1 : this.customPotionEffects) {
                living.func_70690_d(potioneffect1);
            }
        }
    }

    protected ItemStack func_184550_j() {
        if (this.customPotionEffects.isEmpty()) {
            return new ItemStack(Items.field_151032_g);
        }
        ItemStack itemstack = new ItemStack((Item)ModItems.tippedArrow);
        PotionUtils.func_185184_a((ItemStack)itemstack, this.customPotionEffects);
        return itemstack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i > 0) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }
}

