/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.energyextractor;

import cofh.api.energy.IEnergyConnection;
import mcjty.lib.entity.GenericEnergyProviderTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolsdim.config.MachineConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionStorage;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class EnergyExtractorTileEntity
extends GenericEnergyProviderTileEntity
implements ITickable {
    public EnergyExtractorTileEntity() {
        super(MachineConfiguration.EXTRACTOR_MAXENERGY, MachineConfiguration.EXTRACTOR_SENDPERTICK);
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        int energyStored = this.getEnergyStored(EnumFacing.DOWN);
        if (energyStored < MachineConfiguration.EXTRACTOR_MAXENERGY) {
            int needed = MachineConfiguration.EXTRACTOR_MAXENERGY - energyStored;
            DimensionStorage storage = DimensionStorage.getDimensionStorage(this.func_145831_w());
            int dimensionEnergy = storage.getEnergyLevel(this.func_145831_w().field_73011_w.getDimension());
            if (needed > dimensionEnergy) {
                needed = dimensionEnergy;
            }
            if (needed > 0) {
                energyStored += needed;
                this.modifyEnergyStored(needed);
                storage.setEnergyLevel(this.func_145831_w().field_73011_w.getDimension(), dimensionEnergy -= needed);
                storage.save(this.func_145831_w());
            }
        }
        if (energyStored <= 0) {
            return;
        }
        int rf = MachineConfiguration.EXTRACTOR_SENDPERTICK;
        for (EnumFacing facing : EnumFacing.values()) {
            IEnergyConnection connection;
            int rfToGive;
            BlockPos pos = this.func_174877_v().func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(pos);
            if (!EnergyTools.isEnergyTE((TileEntity)te)) continue;
            EnumFacing opposite = facing.func_176734_d();
            int n = rfToGive = rf <= energyStored ? rf : energyStored;
            int received = te instanceof IEnergyConnection ? ((connection = (IEnergyConnection)te).canConnectEnergy(opposite) ? EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (int)rfToGive) : 0) : EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (int)rfToGive);
            if ((energyStored -= this.storage.extractEnergy(received, false)) <= 0) break;
        }
    }
}

