/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.tconstruct.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker.mods.tconstruct.TConstructHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeWrapper;
import slimeknights.tconstruct.plugin.jei.SmeltingRecipeWrapper;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.tconstruct.Smeltery")
public class Smeltery {
    public static final String nameFuel = "TConstruct Smeltery - Fuel";
    public static final String nameMelting = "TConstruct Smeltery - Melting";
    public static final String nameAlloy = "TConstruct Smeltery - Alloy";

    @ZenMethod
    public static void addAlloy(ILiquidStack output, ILiquidStack[] input) {
        if (input == null || output == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", nameAlloy));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new AddAlloy(new AlloyRecipe(InputHelper.toFluid((ILiquidStack)output), InputHelper.toFluids((ILiquidStack[])input))));
    }

    @ZenMethod
    public static void removeAlloy(IIngredient output) {
        LinkedList<AlloyRecipe> recipes = new LinkedList<AlloyRecipe>();
        for (AlloyRecipe r : TConstructHelper.alloys) {
            if (r == null || !StackHelper.matches((IIngredient)output, (ILiquidStack)InputHelper.toILiquidStack((FluidStack)r.getResult()))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveAlloy(recipes));
        } else {
            LogHelper.logError((String)String.format("No %s recipes found for %s. Command ignored!", nameAlloy, output.toString()));
        }
    }

    @ZenMethod
    public static void addMelting(ILiquidStack output, IIngredient input, int temp, @Optional IItemStack block) {
        if (input == null || output == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", nameMelting));
            return;
        }
        LinkedList<MeltingRecipe> recipes = new LinkedList<MeltingRecipe>();
        for (IItemStack in : input.getItems()) {
            if (block == null && !InputHelper.isABlock((ItemStack)InputHelper.toStack((IItemStack)in))) {
                LogHelper.logWarning((String)String.format("Item %s is not a block and no block renderer is provided for %s recipe. Input ignored!", in.toString(), nameMelting));
                continue;
            }
            recipes.add(new MeltingRecipe(InputHelper.toStack((IItemStack)in), InputHelper.toFluid((ILiquidStack)output)));
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new AddMelting(recipes));
        } else {
            LogHelper.logError((String)String.format("No %s recipes could be added for input %s.", nameMelting, input.toString()));
        }
    }

    @ZenMethod
    public static void removeMelting(IItemStack input) {
        LinkedList<slimeknights.tconstruct.library.smeltery.MeltingRecipe> recipes = new LinkedList<slimeknights.tconstruct.library.smeltery.MeltingRecipe>();
        for (slimeknights.tconstruct.library.smeltery.MeltingRecipe meta : TConstructHelper.smeltingList) {
            if (meta.input.matches(InputHelper.toStacks((IItemStack[])input.getItems().toArray(new IItemStack[0]))) == null) continue;
            recipes.add(meta);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveMelting(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", nameMelting, input.toString()));
        }
    }

    @ZenMethod
    public static void addFuel(ILiquidStack liquid) {
        if (liquid == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", nameFuel));
            return;
        }
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
        stacks.add(InputHelper.toFluid((ILiquidStack)liquid));
        MineTweakerAPI.apply((IUndoableAction)new AddFuel(stacks));
    }

    @ZenMethod
    public static void removeFuel(IIngredient input) {
        ArrayList<FluidStack> recipes = new ArrayList<FluidStack>();
        for (FluidStack fuel : TConstructHelper.fuelList) {
            if (fuel == null || !StackHelper.matches((IIngredient)input, (ILiquidStack)InputHelper.toILiquidStack((FluidStack)fuel))) continue;
            recipes.add(fuel);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFuel(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe for %s found. Command ignored!", nameFuel, input.toString()));
        }
    }

    public static class RemoveFuel
    extends BaseListRemoval<FluidStack> {
        public RemoveFuel(List<FluidStack> recipes) {
            super(Smeltery.nameFuel, TConstructHelper.fuelList, recipes);
        }

        protected String getRecipeInfo(FluidStack recipe) {
            return LogHelper.getStackDescription((FluidStack)recipe);
        }
    }

    public static class AddFuel
    extends BaseListAddition<FluidStack> {
        public AddFuel(List<FluidStack> recipes) {
            super(Smeltery.nameFuel, TConstructHelper.fuelList, recipes);
        }

        public String getRecipeInfo(FluidStack recipe) {
            return LogHelper.getStackDescription((FluidStack)recipe);
        }
    }

    protected static class MeltingRecipe {
        public final ItemStack input;
        public final FluidStack fluid;

        protected MeltingRecipe(ItemStack input, FluidStack fluid) {
            this.input = input;
            this.fluid = fluid;
        }
    }

    private static class RemoveMelting
    extends BaseListRemoval<slimeknights.tconstruct.library.smeltery.MeltingRecipe> {
        public RemoveMelting(List<slimeknights.tconstruct.library.smeltery.MeltingRecipe> recipes) {
            super(Smeltery.nameMelting, TConstructHelper.smeltingList, recipes);
        }

        public void apply() {
            for (slimeknights.tconstruct.library.smeltery.MeltingRecipe recipe : this.recipes) {
                TConstructHelper.smeltingList.remove(recipe);
                this.successful.add(recipe);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new SmeltingRecipeWrapper(recipe));
            }
        }

        public void undo() {
            for (slimeknights.tconstruct.library.smeltery.MeltingRecipe recipe : this.successful) {
                TinkerRegistry.registerMelting((slimeknights.tconstruct.library.smeltery.MeltingRecipe)recipe);
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new SmeltingRecipeWrapper(recipe));
            }
        }

        public String getRecipeInfo(slimeknights.tconstruct.library.smeltery.MeltingRecipe recipe) {
            return LogHelper.getStackDescription((FluidStack)recipe.getResult());
        }
    }

    private static class AddMelting
    extends BaseListAddition<MeltingRecipe> {
        public AddMelting(List<MeltingRecipe> recipes) {
            super(Smeltery.nameMelting, null, recipes);
        }

        public void apply() {
            for (MeltingRecipe recipe : this.recipes) {
                TinkerRegistry.registerMelting((ItemStack)recipe.input, (Fluid)recipe.fluid.getFluid(), (int)recipe.fluid.amount);
                this.successful.add(recipe);
                MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new SmeltingRecipeWrapper(new slimeknights.tconstruct.library.smeltery.MeltingRecipe(RecipeMatch.of((ItemStack)recipe.input), recipe.fluid)));
            }
        }

        public void undo() {
            for (MeltingRecipe recipe : this.successful) {
                TConstructHelper.smeltingList.remove(recipe.fluid);
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new SmeltingRecipeWrapper(new slimeknights.tconstruct.library.smeltery.MeltingRecipe(RecipeMatch.of((ItemStack)recipe.input), recipe.fluid)));
            }
        }

        public String getRecipeInfo(MeltingRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.input);
        }
    }

    private static class RemoveAlloy
    extends BaseListRemoval<AlloyRecipe> {
        public RemoveAlloy(List<AlloyRecipe> recipes) {
            super(Smeltery.nameAlloy, TConstructHelper.alloys, recipes);
        }

        public void apply() {
            if (this.recipes.isEmpty()) {
                return;
            }
            for (AlloyRecipe recipe : this.recipes) {
                if (recipe != null) {
                    if (this.list.remove(recipe)) {
                        this.successful.add(recipe);
                        MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new AlloyRecipeWrapper(recipe));
                        continue;
                    }
                    LogHelper.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                    continue;
                }
                LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
            }
        }

        public void undo() {
            if (this.successful.isEmpty()) {
                return;
            }
            for (AlloyRecipe recipe : this.successful) {
                if (recipe != null) {
                    if (!this.list.add(recipe)) {
                        LogHelper.logError((String)String.format("Error restoring %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                        continue;
                    }
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new AlloyRecipeWrapper(recipe));
                    continue;
                }
                LogHelper.logError((String)String.format("Error restoring %s Recipe: null object", this.name));
            }
        }

        protected String getRecipeInfo(AlloyRecipe recipe) {
            return LogHelper.getStackDescription((FluidStack)recipe.getResult());
        }
    }

    private static class AddAlloy
    extends BaseListAddition<AlloyRecipe> {
        public AddAlloy(AlloyRecipe recipe) {
            super(Smeltery.nameAlloy, TConstructHelper.alloys);
            this.recipes.add(recipe);
        }

        public void apply() {
            if (this.recipes.isEmpty()) {
                return;
            }
            for (AlloyRecipe recipe : this.recipes) {
                if (recipe != null) {
                    if (this.list.add(recipe)) {
                        this.successful.add(recipe);
                        MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new AlloyRecipeWrapper(recipe));
                        continue;
                    }
                    LogHelper.logError((String)String.format("Error adding %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                    continue;
                }
                LogHelper.logError((String)String.format("Error adding %s Recipe: null object", this.name));
            }
        }

        public void undo() {
            if (this.successful.isEmpty()) {
                return;
            }
            for (AlloyRecipe recipe : this.successful) {
                if (recipe != null) {
                    if (!this.list.remove(recipe)) {
                        LogHelper.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                        continue;
                    }
                    MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new AlloyRecipeWrapper(recipe));
                    continue;
                }
                LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
            }
        }

        protected String getRecipeInfo(AlloyRecipe recipe) {
            return LogHelper.getStackDescription((FluidStack)recipe.getResult());
        }
    }
}

