/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.embers.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import teamroots.embers.compat.jei.StampingRecipeWrapper;
import teamroots.embers.item.EnumStampType;
import teamroots.embers.recipe.ItemStampingOreRecipe;
import teamroots.embers.recipe.ItemStampingRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@ZenClass(value="mods.embers.Stamper")
public class Stamper {
    public static String name = "Embers Stamper";

    @ZenMethod
    public static void addRecipe(IItemStack itemInput, ILiquidStack fluidInput, String stampType, IItemStack result, boolean matchMeta, boolean matchNBT) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new ItemStampingRecipe(InputHelper.toStack((IItemStack)itemInput), InputHelper.toFluid((ILiquidStack)fluidInput), Stamper.getStampFromString(stampType), InputHelper.toStack((IItemStack)result), matchMeta, matchNBT)));
    }

    @ZenMethod
    public static void addRecipe(IOreDictEntry key, ILiquidStack fluidInput, String stampType, IItemStack result) {
        MineTweakerAPI.apply((IUndoableAction)new AddOre(new ItemStampingOreRecipe(key.getName(), InputHelper.toFluid((ILiquidStack)fluidInput), Stamper.getStampFromString(stampType), InputHelper.toStack((IItemStack)result), false, false)));
    }

    @ZenMethod
    public static void remove(IItemStack item) {
        int i;
        ArrayList<ItemStampingRecipe> recipes = new ArrayList<ItemStampingRecipe>();
        ArrayList<ItemStampingOreRecipe> oreRecipes = new ArrayList<ItemStampingOreRecipe>();
        if (item == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        for (i = 0; i < RecipeRegistry.stampingRecipes.size(); ++i) {
            if (!ItemStack.func_179545_c((ItemStack)((ItemStampingRecipe)RecipeRegistry.stampingRecipes.get((int)i)).result, (ItemStack)InputHelper.toStack((IItemStack)item))) continue;
            recipes.add((ItemStampingRecipe)RecipeRegistry.stampingRecipes.get(i));
        }
        for (i = 0; i < RecipeRegistry.stampingOreRecipes.size(); ++i) {
            if (!ItemStack.func_179545_c((ItemStack)((ItemStampingOreRecipe)RecipeRegistry.stampingOreRecipes.get((int)i)).result, (ItemStack)InputHelper.toStack((IItemStack)item))) continue;
            oreRecipes.add((ItemStampingOreRecipe)RecipeRegistry.stampingOreRecipes.get(i));
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else if (!oreRecipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveOre(oreRecipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for output %s. Command ignored!", name, item.toString()));
        }
    }

    public static EnumStampType getStampFromString(String string) {
        switch (string) {
            default: {
                return EnumStampType.TYPE_NULL;
            }
            case "flat": {
                return EnumStampType.TYPE_FLAT;
            }
            case "bar": {
                return EnumStampType.TYPE_BAR;
            }
            case "plate": {
                return EnumStampType.TYPE_PLATE;
            }
            case "null": 
        }
        return EnumStampType.TYPE_NULL;
    }

    private static class RemoveOre
    extends BaseListRemoval<ItemStampingOreRecipe> {
        public RemoveOre(List<ItemStampingOreRecipe> recipes) {
            super(name, (List)RecipeRegistry.stampingOreRecipes, recipes);
        }

        public void apply() {
            super.apply();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new StampingRecipeWrapper(rec)));
        }

        public void undo() {
            super.undo();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new StampingRecipeWrapper(rec)));
        }

        protected String getRecipeInfo(ItemStampingOreRecipe arg0) {
            return arg0.getOre();
        }
    }

    private static class Remove
    extends BaseListRemoval<ItemStampingRecipe> {
        public Remove(List<ItemStampingRecipe> recipes) {
            super(name, (List)RecipeRegistry.stampingRecipes, recipes);
        }

        public void apply() {
            super.apply();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new StampingRecipeWrapper(rec)));
        }

        public void undo() {
            super.undo();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new StampingRecipeWrapper(rec)));
        }

        protected String getRecipeInfo(ItemStampingRecipe arg0) {
            return LogHelper.getStackDescription((Object)arg0.getStack());
        }
    }

    private static class Add
    extends BaseListAddition<ItemStampingRecipe> {
        public Add(ItemStampingRecipe recipe) {
            super(name, (List)RecipeRegistry.stampingRecipes);
            this.recipes.add(recipe);
        }

        public void apply() {
            super.apply();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new StampingRecipeWrapper(rec)));
        }

        public void undo() {
            super.undo();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new StampingRecipeWrapper(rec)));
        }

        protected String getRecipeInfo(ItemStampingRecipe arg0) {
            return LogHelper.getStackDescription((Object)arg0.getStack());
        }
    }

    private static class AddOre
    extends BaseListAddition<ItemStampingOreRecipe> {
        public AddOre(ItemStampingOreRecipe recipe) {
            super(name, (List)RecipeRegistry.stampingOreRecipes);
            this.recipes.add(recipe);
        }

        public void apply() {
            super.apply();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new StampingRecipeWrapper(rec)));
        }

        public void undo() {
            super.undo();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new StampingRecipeWrapper(rec)));
        }

        protected String getRecipeInfo(ItemStampingOreRecipe arg0) {
            return arg0.getOre();
        }
    }
}

