/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.chisel;

import com.blamejared.mtlib.helpers.InputHelper;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import minetweaker.api.item.IItemStack;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingVariation;

public class ChiselHelper {
    public static ICarvingGroup getGroup(String name) {
        return CarvingUtils.getChiselRegistry().getGroup(name);
    }

    public static ICarvingGroup getGroup(IItemStack stack) {
        return CarvingUtils.getChiselRegistry().getGroup(InputHelper.toStack((IItemStack)stack));
    }

    public static ICarvingVariation getVariation(IItemStack stack) {
        ICarvingGroup g = ChiselHelper.getGroup(stack);
        if (g != null) {
            for (ICarvingVariation v : g.getVariations()) {
                if (!v.getStack().func_77969_a(InputHelper.toStack((IItemStack)stack))) continue;
                return v;
            }
        }
        return null;
    }

    public static ICarvingVariation makeVariation(IItemStack stack) {
        Block block = Block.func_149634_a((Item)InputHelper.toStack((IItemStack)stack).func_77973_b());
        IBlockState state = block.func_176203_a(InputHelper.toStack((IItemStack)stack).func_77952_i());
        return CarvingUtils.getDefaultVariationFor((IBlockState)state, (int)0);
    }

    public static ICarvingGroup makeGroup(String name) {
        return new CarvingGroup(name);
    }

    public static boolean groupContainsVariation(ICarvingGroup group, ICarvingVariation variation) {
        Iterator iterator = group.getVariations().iterator();
        if (iterator.hasNext()) {
            ICarvingVariation otherVariation = (ICarvingVariation)iterator.next();
            return otherVariation.getStack().func_77969_a(variation.getStack());
        }
        return false;
    }

    static class CarvingGroup
    implements ICarvingGroup {
        private String name;
        private String sound;
        private String oreName;
        private List<ICarvingVariation> variations = Lists.newArrayList();

        public CarvingGroup(String name) {
            this.name = name;
        }

        public List<ICarvingVariation> getVariations() {
            return Lists.newArrayList(this.variations);
        }

        public void addVariation(ICarvingVariation variation) {
            this.variations.add(variation);
            Collections.sort(this.variations, new Comparator<ICarvingVariation>(){

                @Override
                public int compare(ICarvingVariation o1, ICarvingVariation o2) {
                    return CarvingUtils.compare((ICarvingVariation)o1, (ICarvingVariation)o2);
                }
            });
        }

        public boolean removeVariation(ICarvingVariation variation) {
            ICarvingVariation toRemove = null;
            for (ICarvingVariation v : this.variations) {
                if (!v.getStack().func_77969_a(variation.getStack())) continue;
                toRemove = v;
            }
            return toRemove == null ? false : this.variations.remove(toRemove);
        }

        public String getName() {
            return this.name;
        }

        public String getSound() {
            return this.sound;
        }

        public void setSound(String sound) {
            this.sound = sound;
        }

        public String getOreName() {
            return this.oreName;
        }

        public void setOreName(String oreName) {
            this.oreName = oreName;
        }
    }

    public static class CarvingVariation
    implements ICarvingVariation {
        Block block;

        public CarvingVariation(Block block) {
            this.block = block;
        }

        public Block getBlock() {
            return this.block;
        }

        public IBlockState getBlockState() {
            return this.block.func_176223_P();
        }

        @Nonnull
        public ItemStack getStack() {
            return new ItemStack(this.block);
        }

        public int getOrder() {
            return 99;
        }
    }
}

