/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.botania.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import java.util.ArrayList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.recipes.ShapedRecipe;
import minetweaker.mc1102.recipes.RecipeConverter;
import modtweaker.mods.botania.BotaniaHelper;
import modtweaker.mods.botania.lexicon.AddCategory;
import modtweaker.mods.botania.lexicon.AddEntry;
import modtweaker.mods.botania.lexicon.AddPage;
import modtweaker.mods.botania.lexicon.AddRecipeMapping;
import modtweaker.mods.botania.lexicon.RemoveCategory;
import modtweaker.mods.botania.lexicon.RemoveEntry;
import modtweaker.mods.botania.lexicon.RemovePage;
import modtweaker.mods.botania.lexicon.RemoveRecipeMapping;
import modtweaker.mods.botania.lexicon.SetCategoryIcon;
import modtweaker.mods.botania.lexicon.SetCategoryPriority;
import modtweaker.mods.botania.lexicon.SetEntryKnowledgeType;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.KnowledgeType;
import vazkii.botania.api.lexicon.LexiconCategory;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.LexiconPage;
import vazkii.botania.api.lexicon.LexiconRecipeMappings;
import vazkii.botania.api.recipe.RecipeBrew;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.api.recipe.RecipeRuneAltar;
import vazkii.botania.common.lexicon.page.PageBrew;
import vazkii.botania.common.lexicon.page.PageCraftingRecipe;
import vazkii.botania.common.lexicon.page.PageElvenRecipe;
import vazkii.botania.common.lexicon.page.PageEntity;
import vazkii.botania.common.lexicon.page.PageImage;
import vazkii.botania.common.lexicon.page.PageLoreText;
import vazkii.botania.common.lexicon.page.PageManaInfusionRecipe;
import vazkii.botania.common.lexicon.page.PagePetalRecipe;
import vazkii.botania.common.lexicon.page.PageRuneRecipe;
import vazkii.botania.common.lexicon.page.PageText;

@ZenClass(value="mods.botania.Lexicon")
public class Lexicon {
    @ZenMethod
    public static void addBrewPage(String name, String entry, int page_number, String brew, IIngredient[] recipe, String bottomText) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(entry);
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + entry);
            return;
        }
        if (page_number > lexiconEntry.pages.size()) {
            MineTweakerAPI.getLogger().logError("Page Number " + page_number + " out of bounds for " + entry);
            return;
        }
        if (BotaniaAPI.getBrewFromKey((String)brew) == null) {
            MineTweakerAPI.getLogger().logError("Cannot find brew " + brew);
            return;
        }
        RecipeBrew page_recipe = new RecipeBrew(BotaniaAPI.getBrewFromKey((String)brew), InputHelper.toObjects((IIngredient[])recipe));
        PageBrew page = new PageBrew(page_recipe, name, bottomText);
        MineTweakerAPI.apply((IUndoableAction)new AddPage(name, lexiconEntry, (LexiconPage)page, page_number));
    }

    @ZenMethod
    public static void addCraftingPage(String name, String entry, int page_number, IItemStack[] outputs, IIngredient[][][] inputs) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(entry);
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + entry);
            return;
        }
        if (page_number > lexiconEntry.pages.size()) {
            MineTweakerAPI.getLogger().logError("Page Number " + page_number + " out of bounds for " + entry);
            return;
        }
        if (outputs.length != inputs.length) {
            MineTweakerAPI.getLogger().logError("Length of input and output must match");
            return;
        }
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        for (int i = 0; i < outputs.length; ++i) {
            recipes.add(RecipeConverter.convert((ShapedRecipe)new ShapedRecipe(outputs[i], inputs[i], null, null, false)));
        }
        PageCraftingRecipe page = new PageCraftingRecipe(name, recipes);
        MineTweakerAPI.apply((IUndoableAction)new AddPage(name, lexiconEntry, (LexiconPage)page, page_number));
    }

    @ZenMethod
    public static void addElvenPage(String name, String entry, int page_number, IItemStack[] outputs, IIngredient[][] inputs) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(entry);
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + entry);
            return;
        }
        if (page_number > lexiconEntry.pages.size()) {
            MineTweakerAPI.getLogger().logError("Page Number " + page_number + " out of bounds for " + entry);
            return;
        }
        if (outputs.length != inputs.length) {
            MineTweakerAPI.getLogger().logError("Length of input and output must match");
            return;
        }
        ArrayList<RecipeElvenTrade> recipes = new ArrayList<RecipeElvenTrade>();
        for (int i = 0; i < outputs.length; ++i) {
            recipes.add(new RecipeElvenTrade(InputHelper.toStacks((IItemStack[])outputs), InputHelper.toObjects((IIngredient[])inputs[i])));
        }
        PageElvenRecipe page = new PageElvenRecipe(name, recipes);
        MineTweakerAPI.apply((IUndoableAction)new AddPage(name, lexiconEntry, (LexiconPage)page, page_number));
    }

    @ZenMethod
    public static void addEntityPage(String name, String entry, int page_number, String entity, int size) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(entry);
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + entry);
            return;
        }
        if (page_number > lexiconEntry.pages.size()) {
            MineTweakerAPI.getLogger().logError("Page Number " + page_number + " out of bounds for " + entry);
            return;
        }
        if (!EntityList.func_180125_b((String)entity)) {
            MineTweakerAPI.getLogger().logError("No such entity " + entity);
            return;
        }
        PageEntity page = new PageEntity(entity, entity, size);
        MineTweakerAPI.apply((IUndoableAction)new AddPage(name, lexiconEntry, (LexiconPage)page, page_number));
    }

    @ZenMethod
    public static void addImagePage(String name, String entry, int page_number, String resource) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(entry);
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + entry);
            return;
        }
        if (page_number > lexiconEntry.pages.size()) {
            MineTweakerAPI.getLogger().logError("Page Number " + page_number + " out of bounds for " + entry);
            return;
        }
        PageImage page = new PageImage(name, resource);
        MineTweakerAPI.apply((IUndoableAction)new AddPage(name, lexiconEntry, (LexiconPage)page, page_number));
    }

    @ZenMethod
    public static void addLorePage(String name, String entry, int page_number) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(entry);
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + entry);
            return;
        }
        if (page_number > lexiconEntry.pages.size()) {
            MineTweakerAPI.getLogger().logError("Page Number " + page_number + " out of bounds for " + entry);
            return;
        }
        PageLoreText page = new PageLoreText(name);
        MineTweakerAPI.apply((IUndoableAction)new AddPage(name, lexiconEntry, (LexiconPage)page, page_number));
    }

    @ZenMethod
    public static void addInfusionPage(String name, String entry, int page_number, IItemStack[] outputs, IIngredient[] inputs, int[] mana) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(entry);
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + entry);
            return;
        }
        if (page_number > lexiconEntry.pages.size()) {
            MineTweakerAPI.getLogger().logError("Page Number " + page_number + " out of bounds for " + entry);
            return;
        }
        if (outputs.length != inputs.length || outputs.length != mana.length) {
            MineTweakerAPI.getLogger().logError("Length of input and output must match");
            return;
        }
        ArrayList<RecipeManaInfusion> recipes = new ArrayList<RecipeManaInfusion>();
        for (int i = 0; i < outputs.length; ++i) {
            recipes.add(new RecipeManaInfusion(InputHelper.toStack((IItemStack)outputs[i]), InputHelper.toObject((IIngredient)inputs[i]), mana[i]));
        }
        PageManaInfusionRecipe page = new PageManaInfusionRecipe(name, recipes);
        MineTweakerAPI.apply((IUndoableAction)new AddPage(name, lexiconEntry, (LexiconPage)page, page_number));
    }

    @ZenMethod
    public static void addAlchemyPage(String name, String entry, int page_number, IItemStack[] outputs, IIngredient[] inputs, int[] mana) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(entry);
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + entry);
            return;
        }
        if (page_number > lexiconEntry.pages.size()) {
            MineTweakerAPI.getLogger().logError("Page Number " + page_number + " out of bounds for " + entry);
            return;
        }
        if (outputs.length != inputs.length || outputs.length != mana.length) {
            MineTweakerAPI.getLogger().logError("Length of input and output must match");
            return;
        }
        ArrayList<RecipeManaInfusion> recipes = new ArrayList<RecipeManaInfusion>();
        for (int i = 0; i < outputs.length; ++i) {
            RecipeManaInfusion current_recipe = new RecipeManaInfusion(InputHelper.toStack((IItemStack)outputs[i]), InputHelper.toObject((IIngredient)inputs[i]), mana[i]);
            current_recipe.setAlchemy(true);
            recipes.add(current_recipe);
        }
        PageManaInfusionRecipe page = new PageManaInfusionRecipe(name, recipes);
        MineTweakerAPI.apply((IUndoableAction)new AddPage(name, lexiconEntry, (LexiconPage)page, page_number));
    }

    @ZenMethod
    public static void addConjurationPage(String name, String entry, int page_number, IItemStack[] outputs, IIngredient[] inputs, int[] mana) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(entry);
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + entry);
            return;
        }
        if (page_number > lexiconEntry.pages.size()) {
            MineTweakerAPI.getLogger().logError("Page Number " + page_number + " out of bounds for " + entry);
            return;
        }
        if (outputs.length != inputs.length || outputs.length != mana.length) {
            MineTweakerAPI.getLogger().logError("Length of input and output must match");
            return;
        }
        ArrayList<RecipeManaInfusion> recipes = new ArrayList<RecipeManaInfusion>();
        for (int i = 0; i < outputs.length; ++i) {
            RecipeManaInfusion current_recipe = new RecipeManaInfusion(InputHelper.toStack((IItemStack)outputs[i]), InputHelper.toObject((IIngredient)inputs[i]), mana[i]);
            current_recipe.setConjuration(true);
            recipes.add(current_recipe);
        }
        PageManaInfusionRecipe page = new PageManaInfusionRecipe(name, recipes);
        MineTweakerAPI.apply((IUndoableAction)new AddPage(name, lexiconEntry, (LexiconPage)page, page_number));
    }

    @ZenMethod
    public static void addPetalPage(String name, String entry, int page_number, IItemStack[] outputs, IIngredient[][] inputs) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(entry);
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + entry);
            return;
        }
        if (page_number > lexiconEntry.pages.size()) {
            MineTweakerAPI.getLogger().logError("Page Number " + page_number + " out of bounds for " + entry);
            return;
        }
        if (outputs.length != inputs.length) {
            MineTweakerAPI.getLogger().logError("Length of input and output must match");
            return;
        }
        ArrayList<RecipePetals> recipes = new ArrayList<RecipePetals>();
        for (int i = 0; i < outputs.length; ++i) {
            recipes.add(new RecipePetals(InputHelper.toStack((IItemStack)outputs[i]), InputHelper.toObjects((IIngredient[])inputs[i])));
        }
        PagePetalRecipe page = new PagePetalRecipe(name, recipes);
        MineTweakerAPI.apply((IUndoableAction)new AddPage(name, lexiconEntry, (LexiconPage)page, page_number));
    }

    @ZenMethod
    public static void addRunePage(String name, String entry, int page_number, IItemStack[] outputs, IIngredient[][] inputs, int[] mana) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(entry);
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + entry);
            return;
        }
        if (page_number > lexiconEntry.pages.size()) {
            MineTweakerAPI.getLogger().logError("Page Number " + page_number + " out of bounds for " + entry);
            return;
        }
        if (outputs.length != inputs.length || outputs.length != mana.length) {
            MineTweakerAPI.getLogger().logError("Length of input and output must match");
            return;
        }
        ArrayList<RecipeRuneAltar> recipes = new ArrayList<RecipeRuneAltar>();
        for (int i = 0; i < outputs.length; ++i) {
            recipes.add(new RecipeRuneAltar(InputHelper.toStack((IItemStack)outputs[i]), mana[i], InputHelper.toObjects((IIngredient[])inputs[i])));
        }
        PageRuneRecipe page = new PageRuneRecipe(name, recipes);
        MineTweakerAPI.apply((IUndoableAction)new AddPage(name, lexiconEntry, (LexiconPage)page, page_number));
    }

    @ZenMethod
    public static void addTextPage(String name, String entry, int page_number) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(entry);
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + entry);
            return;
        }
        if (page_number > lexiconEntry.pages.size()) {
            MineTweakerAPI.getLogger().logError("Page Number " + page_number + " out of bounds for " + entry);
            return;
        }
        PageText page = new PageText(name);
        MineTweakerAPI.apply((IUndoableAction)new AddPage(name, lexiconEntry, (LexiconPage)page, page_number));
    }

    @ZenMethod
    public static void removePage(String entry, int page_number) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(entry);
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + entry);
            return;
        }
        if (page_number >= lexiconEntry.pages.size()) {
            MineTweakerAPI.getLogger().logError("Page Number " + page_number + " out of bounds for " + entry);
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RemovePage(lexiconEntry, page_number));
    }

    @ZenMethod
    public static void addEntry(String entry, String catagory, IItemStack stack) {
        LexiconCategory lexiconCategory = BotaniaHelper.findCatagory(catagory);
        if (lexiconCategory == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon category " + catagory);
            return;
        }
        LexiconEntry lexiconEntry = new LexiconEntry(entry, lexiconCategory);
        lexiconEntry.setIcon(InputHelper.toStack((IItemStack)stack));
        MineTweakerAPI.apply((IUndoableAction)new AddEntry(lexiconEntry));
    }

    @ZenMethod
    public static void removeEntry(String entry) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(entry);
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + entry);
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RemoveEntry(lexiconEntry));
    }

    @ZenMethod
    public static void setEntryKnowledgeType(String entry, String knowledgeType) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(entry);
        KnowledgeType type = BotaniaHelper.findKnowledgeType(knowledgeType);
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + entry);
            return;
        }
        if (type == null) {
            MineTweakerAPI.getLogger().logError("Cannot find knowledge type " + knowledgeType);
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new SetEntryKnowledgeType(lexiconEntry, type));
    }

    @ZenMethod
    public static void addCategory(String name) {
        LexiconCategory lexiconCategory = new LexiconCategory(name);
        MineTweakerAPI.apply((IUndoableAction)new AddCategory(lexiconCategory));
    }

    @ZenMethod
    public static void removeCategory(String name) {
        LexiconCategory lexiconCategory = BotaniaHelper.findCatagory(name);
        if (lexiconCategory == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon category " + name);
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RemoveCategory(lexiconCategory));
    }

    @ZenMethod
    public static void setCategoryPriority(String name, int priority) {
        LexiconCategory lexiconCategory = BotaniaHelper.findCatagory(name);
        if (lexiconCategory == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon category " + name);
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new SetCategoryPriority(lexiconCategory, priority));
    }

    @ZenMethod
    public static void setCategoryIcon(String name, String icon) {
        LexiconCategory lexiconCategory = BotaniaHelper.findCatagory(name);
        if (lexiconCategory == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon category " + name);
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new SetCategoryIcon(lexiconCategory, icon));
    }

    @ZenMethod
    public static void addRecipeMapping(IItemStack stack, String Entry2, int page) {
        LexiconEntry lexiconEntry = BotaniaHelper.findEntry(Entry2);
        if (LexiconRecipeMappings.getDataForStack((ItemStack)InputHelper.toStack((IItemStack)stack)) != null) {
            MineTweakerAPI.getLogger().logError("There is already a recipe mapping for " + stack);
            return;
        }
        if (lexiconEntry == null) {
            MineTweakerAPI.getLogger().logError("Cannot find lexicon entry " + Entry2);
            return;
        }
        if (lexiconEntry.pages.size() < page) {
            MineTweakerAPI.getLogger().logError("Not enough pages in " + Entry2);
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeMapping(InputHelper.toStack((IItemStack)stack), lexiconEntry, page));
    }

    @ZenMethod
    public static void removeRecipeMapping(IItemStack stack) {
        if (LexiconRecipeMappings.getDataForStack((ItemStack)InputHelper.toStack((IItemStack)stack)) == null) {
            MineTweakerAPI.getLogger().logError("There isn't a recipe mapping for " + stack);
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeMapping(InputHelper.toStack((IItemStack)stack)));
    }
}

