/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.bloodmagic.handlers;

import WayofTime.bloodmagic.api.recipe.TartaricForgeRecipe;
import WayofTime.bloodmagic.compat.jei.forge.TartaricForgeRecipeJEI;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker.mods.bloodmagic.BloodMagicHelper;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bloodmagic.SoulForge")
public class SoulForge {
    protected static final String name = "Blood Magic Soul Forge";

    @ZenMethod
    public static void addRecipe(IItemStack output, double minimumSouls, double drain, IIngredient[] input) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new TartaricForgeRecipe(InputHelper.toStack((IItemStack)output), minimumSouls, drain, InputHelper.toObjects((IIngredient[])input)), BloodMagicHelper.soulForgeList));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        SoulForge.remove(output, BloodMagicHelper.soulForgeList);
    }

    public static void remove(IIngredient output, List<TartaricForgeRecipe> list) {
        if (output == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        LinkedList<TartaricForgeRecipe> recipes = new LinkedList<TartaricForgeRecipe>();
        for (TartaricForgeRecipe recipe : list) {
            if (!StackHelper.matches((IIngredient)output, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.getRecipeOutput()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(list, recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for output %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<TartaricForgeRecipe> {
        public Remove(List<TartaricForgeRecipe> list, List<TartaricForgeRecipe> recipes) {
            super(SoulForge.name, list, recipes);
        }

        public void apply() {
            if (this.recipes.isEmpty()) {
                return;
            }
            for (TartaricForgeRecipe recipe : this.recipes) {
                if (recipe != null) {
                    if (this.list.remove(recipe)) {
                        this.successful.add(recipe);
                        MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new TartaricForgeRecipeJEI(recipe));
                        continue;
                    }
                    LogHelper.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                    continue;
                }
                LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
            }
        }

        public void undo() {
            if (this.successful.isEmpty()) {
                return;
            }
            for (TartaricForgeRecipe recipe : this.successful) {
                if (recipe != null) {
                    if (!this.list.add(recipe)) {
                        LogHelper.logError((String)String.format("Error restoring %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                        continue;
                    }
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new TartaricForgeRecipeJEI(recipe));
                    continue;
                }
                LogHelper.logError((String)String.format("Error restoring %s Recipe: null object", this.name));
            }
        }

        protected String getRecipeInfo(TartaricForgeRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getRecipeOutput());
        }
    }

    private static class Add
    extends BaseListAddition<TartaricForgeRecipe> {
        public Add(TartaricForgeRecipe recipe, List<TartaricForgeRecipe> list) {
            super(SoulForge.name, list);
            this.recipes.add(recipe);
        }

        public void apply() {
            if (this.recipes.isEmpty()) {
                return;
            }
            for (TartaricForgeRecipe recipe : this.recipes) {
                if (recipe != null) {
                    if (this.list.add(recipe)) {
                        this.successful.add(recipe);
                        MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new TartaricForgeRecipeJEI(recipe));
                        continue;
                    }
                    LogHelper.logError((String)String.format("Error adding %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                    continue;
                }
                LogHelper.logError((String)String.format("Error adding %s Recipe: null object", this.name));
            }
        }

        public void undo() {
            if (this.successful.isEmpty()) {
                return;
            }
            for (TartaricForgeRecipe recipe : this.successful) {
                if (recipe != null) {
                    if (!this.list.remove(recipe)) {
                        LogHelper.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                        continue;
                    }
                    MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new TartaricForgeRecipeJEI(recipe));
                    continue;
                }
                LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
            }
        }

        public String getRecipeInfo(TartaricForgeRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getRecipeOutput());
        }
    }
}

