/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.actuallyadditions.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.EmpowererRecipe;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.actuallyadditions.Empowerer")
public class Empowerer {
    protected static final String name = "Actually Additions Empowerer";

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, IItemStack modifier1, IItemStack modifier2, IItemStack modifier3, IItemStack modifier4, int energyPerStand, int time, @Optional float redValue, @Optional float greenValue, @Optional float blueValue) {
        float[] particleColor = new float[]{redValue, greenValue, blueValue};
        MineTweakerAPI.apply((IUndoableAction)new Add(new EmpowererRecipe(InputHelper.toStack((IItemStack)input), InputHelper.toStack((IItemStack)output), InputHelper.toStack((IItemStack)modifier1), InputHelper.toStack((IItemStack)modifier2), InputHelper.toStack((IItemStack)modifier3), InputHelper.toStack((IItemStack)modifier4), energyPerStand, time, particleColor)));
    }

    @ZenMethod
    public static void remove(IIngredient input, IIngredient output) {
        LinkedList<EmpowererRecipe> recipes = new LinkedList<EmpowererRecipe>();
        if (output == null || input == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        for (EmpowererRecipe recipe : ActuallyAdditionsAPI.EMPOWERER_RECIPES) {
            if (!StackHelper.matches((IIngredient)output, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.output)) || !StackHelper.matches((IIngredient)input, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.input))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for output %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<EmpowererRecipe> {
        public Remove(List<EmpowererRecipe> recipes) {
            super(Empowerer.name, ActuallyAdditionsAPI.EMPOWERER_RECIPES, recipes);
        }

        protected String getRecipeInfo(EmpowererRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.output);
        }
    }

    private static class Add
    extends BaseListAddition<EmpowererRecipe> {
        public Add(EmpowererRecipe recipe) {
            super(Empowerer.name, ActuallyAdditionsAPI.EMPOWERER_RECIPES);
            this.recipes.add(recipe);
        }

        public String getRecipeInfo(EmpowererRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.output);
        }
    }
}

