/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.fs;

import java.io.FileNotFoundException;
import li.cil.oc.api.fs.Mode;
import li.cil.oc.server.fs.Buffered;
import li.cil.oc.server.fs.FileSystem$;
import li.cil.oc.server.fs.InputStreamFileSystem;
import li.cil.oc.server.fs.VirtualFileSystem;
import net.minecraft.nbt.NBTTagCompound;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;

public abstract class VirtualFileSystem$class {
    public static boolean exists(VirtualFileSystem $this, String path) {
        return $this.root().get((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])$this.segments(path))).isDefined();
    }

    public static boolean isDirectory(VirtualFileSystem $this, String path) {
        boolean bl;
        Option<VirtualFileSystem.VirtualObject> option = $this.root().get((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])$this.segments(path)));
        if (option instanceof Some) {
            Some some = (Some)option;
            VirtualFileSystem.VirtualObject obj = (VirtualFileSystem.VirtualObject)some.x();
            bl = obj.isDirectory();
        } else {
            bl = false;
        }
        return bl;
    }

    public static long size(VirtualFileSystem $this, String path) {
        long l;
        Option<VirtualFileSystem.VirtualObject> option = $this.root().get((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])$this.segments(path)));
        if (option instanceof Some) {
            Some some = (Some)option;
            VirtualFileSystem.VirtualObject obj = (VirtualFileSystem.VirtualObject)some.x();
            l = obj.size();
        } else {
            l = 0L;
        }
        return l;
    }

    public static long lastModified(VirtualFileSystem $this, String path) {
        long l;
        Option<VirtualFileSystem.VirtualObject> option = $this.root().get((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])$this.segments(path)));
        if (option instanceof Some) {
            Some some = (Some)option;
            VirtualFileSystem.VirtualObject obj = (VirtualFileSystem.VirtualObject)some.x();
            l = obj.lastModified();
        } else {
            l = 0L;
        }
        return l;
    }

    public static String[] list(VirtualFileSystem $this, String path) {
        String[] stringArray;
        Some some;
        VirtualFileSystem.VirtualObject obj;
        Option<VirtualFileSystem.VirtualObject> option = $this.root().get((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])$this.segments(path)));
        if (option instanceof Some && (obj = (VirtualFileSystem.VirtualObject)(some = (Some)option).x()) instanceof VirtualFileSystem.VirtualDirectory) {
            VirtualFileSystem.VirtualDirectory virtualDirectory = (VirtualFileSystem.VirtualDirectory)obj;
            stringArray = virtualDirectory.list();
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public static boolean delete(VirtualFileSystem $this, String path) {
        boolean bl;
        String[] parts = $this.segments(path);
        if (Predef$.MODULE$.refArrayOps((Object[])parts).isEmpty()) {
            bl = true;
        } else {
            boolean bl2;
            Some some;
            VirtualFileSystem.VirtualObject parent;
            Option<VirtualFileSystem.VirtualObject> option = $this.root().get((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])parts).dropRight(1)));
            if (option instanceof Some && (parent = (VirtualFileSystem.VirtualObject)(some = (Some)option).x()) instanceof VirtualFileSystem.VirtualDirectory) {
                VirtualFileSystem.VirtualDirectory virtualDirectory = (VirtualFileSystem.VirtualDirectory)parent;
                bl2 = virtualDirectory.delete((String)Predef$.MODULE$.refArrayOps((Object[])parts).last());
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    public static boolean makeDirectory(VirtualFileSystem $this, String path) {
        boolean bl;
        String[] parts = $this.segments(path);
        if (Predef$.MODULE$.refArrayOps((Object[])parts).isEmpty()) {
            bl = false;
        } else {
            boolean bl2;
            Some some;
            VirtualFileSystem.VirtualObject parent;
            Option<VirtualFileSystem.VirtualObject> option = $this.root().get((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])parts).dropRight(1)));
            if (option instanceof Some && (parent = (VirtualFileSystem.VirtualObject)(some = (Some)option).x()) instanceof VirtualFileSystem.VirtualDirectory) {
                VirtualFileSystem.VirtualDirectory virtualDirectory = (VirtualFileSystem.VirtualDirectory)parent;
                bl2 = virtualDirectory.makeDirectory((String)Predef$.MODULE$.refArrayOps((Object[])parts).last());
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    public static boolean rename(VirtualFileSystem $this, String from, String to) {
        String string = from;
        String string2 = "";
        if ((string == null ? string2 != null : !string.equals(string2)) && $this.exists(from)) {
            boolean bl;
            if ($this.exists(to)) {
                bl = false;
            } else {
                boolean bl2;
                Some some;
                VirtualFileSystem.VirtualObject toParent;
                String[] segmentsTo = $this.segments(to);
                Option<VirtualFileSystem.VirtualObject> option = $this.root().get((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])segmentsTo).dropRight(1)));
                if (option instanceof Some && (toParent = (VirtualFileSystem.VirtualObject)(some = (Some)option).x()) instanceof VirtualFileSystem.VirtualDirectory) {
                    VirtualFileSystem.VirtualDirectory virtualDirectory = (VirtualFileSystem.VirtualDirectory)toParent;
                    String toName = (String)Predef$.MODULE$.refArrayOps((Object[])segmentsTo).last();
                    String[] segmentsFrom = $this.segments(from);
                    VirtualFileSystem.VirtualDirectory fromParent = (VirtualFileSystem.VirtualDirectory)$this.root().get((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])segmentsFrom).dropRight(1))).get();
                    String fromName = (String)Predef$.MODULE$.refArrayOps((Object[])segmentsFrom).last();
                    VirtualFileSystem.VirtualObject obj = (VirtualFileSystem.VirtualObject)fromParent.children().apply((Object)fromName);
                    fromParent.children().$minus$eq((Object)fromName);
                    fromParent.lastModified_$eq(System.currentTimeMillis());
                    virtualDirectory.children().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)toName), (Object)obj));
                    virtualDirectory.lastModified_$eq(System.currentTimeMillis());
                    obj.lastModified_$eq(System.currentTimeMillis());
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                bl = bl2;
            }
            return bl;
        }
        throw new FileNotFoundException(from);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean setLastModified(VirtualFileSystem $this, String path, long time) {
        Option<VirtualFileSystem.VirtualObject> option = $this.root().get((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])$this.segments(path)));
        if (!(option instanceof Some)) return false;
        Some some = (Some)option;
        VirtualFileSystem.VirtualObject obj = (VirtualFileSystem.VirtualObject)some.x();
        if (time < 0L) return false;
        obj.lastModified_$eq(time);
        return true;
    }

    public static Option openInputChannel(VirtualFileSystem $this, String path) {
        None$ none$;
        Some some;
        VirtualFileSystem.VirtualObject obj;
        Option<VirtualFileSystem.VirtualObject> option = $this.root().get((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])$this.segments(path)));
        if (option instanceof Some && (obj = (VirtualFileSystem.VirtualObject)(some = (Some)option).x()) instanceof VirtualFileSystem.VirtualFile) {
            VirtualFileSystem.VirtualFile virtualFile = (VirtualFileSystem.VirtualFile)obj;
            none$ = virtualFile.openInputStream().map((Function1)new Serializable($this){
                private final /* synthetic */ VirtualFileSystem $outer;

                public final InputStreamFileSystem.InputStreamChannel apply(VirtualFileSystem.VirtualFileInputStream x$1) {
                    return new InputStreamFileSystem.InputStreamChannel(this.$outer, x$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static Option openOutputHandle(VirtualFileSystem $this, int id, String path, Mode mode) {
        None$ none$;
        String[] parts = $this.segments(path);
        if (Predef$.MODULE$.refArrayOps((Object[])parts).isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            None$ none$2;
            Some some;
            VirtualFileSystem.VirtualObject directory;
            Option<VirtualFileSystem.VirtualObject> option = $this.root().get((Iterable<String>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])parts).dropRight(1)));
            if (option instanceof Some && (directory = (VirtualFileSystem.VirtualObject)(some = (Some)option).x()) instanceof VirtualFileSystem.VirtualDirectory) {
                Option<VirtualFileSystem.VirtualOutputHandle> option2;
                Some some2;
                VirtualFileSystem.VirtualFile file;
                VirtualFileSystem.VirtualDirectory virtualDirectory = (VirtualFileSystem.VirtualDirectory)directory;
                Option<VirtualFileSystem.VirtualFile> option3 = virtualDirectory.touch((String)Predef$.MODULE$.refArrayOps((Object[])parts).last());
                if (option3 instanceof Some && (file = (VirtualFileSystem.VirtualFile)(some2 = (Some)option3).x()) != null) {
                    VirtualFileSystem.VirtualFile virtualFile = file;
                    option2 = virtualFile.openOutputHandle($this, id, path, mode);
                } else {
                    option2 = None$.MODULE$;
                }
                none$2 = option2;
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        return none$;
    }

    public static void load(VirtualFileSystem $this, NBTTagCompound nbt) {
        if (!($this instanceof Buffered)) {
            $this.root().load(nbt);
        }
        $this.li$cil$oc$server$fs$VirtualFileSystem$$super$load(nbt);
    }

    public static void save(VirtualFileSystem $this, NBTTagCompound nbt) {
        $this.li$cil$oc$server$fs$VirtualFileSystem$$super$save(nbt);
        if (!($this instanceof Buffered)) {
            $this.root().save(nbt);
        }
    }

    public static String[] segments(VirtualFileSystem $this, String path) {
        return (String[])Predef$.MODULE$.refArrayOps((Object[])FileSystem$.MODULE$.validatePath(path).split("/")).filter((Function1)new Serializable($this){

            public final boolean apply(String x$2) {
                String string = x$2;
                String string2 = "";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        });
    }

    public static void $init$(VirtualFileSystem $this) {
        $this.li$cil$oc$server$fs$VirtualFileSystem$_setter_$root_$eq(new VirtualFileSystem.VirtualDirectory($this));
    }
}

