/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.world.gen;

import com.lothrazar.cyclicmagic.world.gen.GeneratePlant;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockCrops;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenPlantBiome
implements IWorldGenerator {
    private GeneratePlant gen;
    private BlockCrops blockPlant;
    private List<Biome> biomes;
    private int minHeight = 1;
    private int spawnTries;

    public WorldGenPlantBiome(BlockCrops plant, List<Biome> b, int chances) {
        this.blockPlant = plant;
        this.biomes = b;
        this.spawnTries = chances;
        this.gen = new GeneratePlant(this.blockPlant);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (0 == world.field_73011_w.getDimension()) {
            this.run(this.gen, world, random, chunkX * 16, chunkZ * 16, this.spawnTries, this.minHeight, 255);
        }
    }

    private void run(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int z;
            int y;
            int x = chunk_X + rand.nextInt(16);
            BlockPos pos = new BlockPos(x, y = minHeight + rand.nextInt(heightDiff), z = chunk_Z + rand.nextInt(16));
            Biome b = world.func_180494_b(pos);
            if (!this.biomes.contains(b)) continue;
            generator.func_180709_b(world, rand, pos);
        }
    }
}

