/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.world.gen;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenEmeraldHeight
implements IWorldGenerator {
    private WorldGenerator genEmerald = new WorldGenMinable(Blocks.field_150412_bA.func_176223_P(), 1, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int spawnTries = 70;
        if (0 == world.field_73011_w.getDimension()) {
            this.run(this.genEmerald, world, random, chunkX * 16, chunkZ * 16, spawnTries, 0, 255);
        }
    }

    private void run(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int z;
            int y;
            int x = chunk_X + rand.nextInt(16);
            BlockPos pos = new BlockPos(x, y = minHeight + rand.nextInt(heightDiff), z = chunk_Z + rand.nextInt(16));
            Biome biome = world.func_180494_b(pos);
            if (biome != Biomes.field_76770_e && biome != Biomes.field_76783_v && biome != Biomes.field_150580_W) continue;
            generator.func_180709_b(world, rand, pos);
        }
    }
}

