/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class UtilHarvestCrops {
    public static int harvestArea(World world, BlockPos pos, int hRadius, HarestCropsConfig conf) {
        int x = pos.func_177958_n();
        int eventy = pos.func_177956_o();
        int z = pos.func_177952_p();
        int xMin = x - hRadius;
        int xMax = x + hRadius;
        int zMin = z - hRadius;
        int zMax = z + hRadius;
        int countHarvested = 0;
        for (int xLoop = xMin; xLoop <= xMax; ++xLoop) {
            for (int zLoop = zMin; zLoop <= zMax; ++zLoop) {
                BlockPos posCurrent = new BlockPos(xLoop, eventy, zLoop);
                if (world.func_175623_d(posCurrent) || !UtilHarvestCrops.harvestSingle(world, posCurrent, conf)) continue;
                ++countHarvested;
            }
        }
        return countHarvested;
    }

    public static boolean harvestSingle(World world, BlockPos posCurrent, HarestCropsConfig conf) {
        IGrowable plant;
        int age;
        boolean doBreakAbove = false;
        boolean doBreakBelow = false;
        boolean doBreak = false;
        IBlockState stateReplant = null;
        IBlockState blockState = world.func_180495_p(posCurrent);
        if (blockState == null) {
            return false;
        }
        Block blockCheck = blockState.func_177230_c();
        if (blockCheck == null) {
            return false;
        }
        IBlockState bsAbove = world.func_180495_p(posCurrent.func_177984_a());
        IBlockState bsBelow = world.func_180495_p(posCurrent.func_177977_b());
        if (blockCheck instanceof BlockNetherWart && conf.doesCrops && (age = ((Integer)blockState.func_177229_b((IProperty)BlockNetherWart.field_176486_a)).intValue()) == 3) {
            doBreak = true;
            stateReplant = blockCheck.func_176223_P();
        }
        if (blockCheck instanceof BlockCocoa) {
            if (conf.doesCrops && (age = ((Integer)blockState.func_177229_b((IProperty)BlockCocoa.field_176501_a)).intValue()) == 2) {
                doBreak = true;
                stateReplant = blockCheck.func_176223_P().func_177226_a((IProperty)BlockCocoa.field_185512_D, blockState.func_177229_b((IProperty)BlockCocoa.field_185512_D));
            }
        } else if (blockCheck instanceof BlockStem) {
            if (conf.doesStem) {
                doBreak = true;
            }
        } else if (blockCheck instanceof BlockSapling) {
            if (conf.doesSapling) {
                doBreak = true;
            }
        } else if (blockCheck instanceof BlockTallGrass) {
            if (conf.doesTallgrass) {
                doBreak = true;
                if (blockCheck instanceof BlockTallGrass && bsAbove != null && bsAbove.func_177230_c() instanceof BlockTallGrass) {
                    doBreakAbove = true;
                }
                if (bsBelow instanceof BlockTallGrass && bsBelow != null && bsBelow.func_177230_c() instanceof BlockTallGrass) {
                    doBreakBelow = true;
                }
            }
        } else if (blockCheck instanceof BlockDoublePlant) {
            if (conf.doesTallgrass) {
                doBreak = true;
                if (blockCheck instanceof BlockDoublePlant && bsAbove != null && bsAbove.func_177230_c() instanceof BlockDoublePlant) {
                    doBreakAbove = true;
                }
                if (bsBelow instanceof BlockDoublePlant && bsBelow != null && bsBelow.func_177230_c() instanceof BlockDoublePlant) {
                    doBreakBelow = true;
                }
            }
        } else if (blockCheck instanceof BlockMushroom) {
            if (conf.doesMushroom) {
                doBreak = true;
            }
        } else if (blockCheck == Blocks.field_150423_aK) {
            if (conf.doesPumpkinBlocks) {
                doBreak = true;
            }
        } else if (blockCheck == Blocks.field_150440_ba) {
            if (conf.doesMelonBlocks) {
                doBreak = false;
                world.func_175655_b(posCurrent, false);
                UtilItemStack.dropItemStackInWorld(world, posCurrent, Blocks.field_150440_ba);
            }
        } else if (blockCheck == Blocks.field_150328_O || blockCheck == Blocks.field_150327_N) {
            if (conf.doesFlowers) {
                doBreak = true;
            }
        } else if (blockCheck instanceof BlockLeaves) {
            if (conf.doesLeaves) {
                doBreak = true;
            }
        } else if (blockCheck == Blocks.field_150434_aF && bsBelow != null && bsBelow.func_177230_c() == Blocks.field_150434_aF) {
            if (conf.doesCactus) {
                doBreak = true;
                if (bsAbove != null && bsAbove.func_177230_c() == Blocks.field_150434_aF) {
                    doBreakAbove = true;
                }
            }
        } else if (blockCheck == Blocks.field_150436_aH && bsBelow != null && bsBelow.func_177230_c() == Blocks.field_150436_aH) {
            if (conf.doesReeds) {
                doBreak = true;
                if (bsAbove != null && bsAbove.func_177230_c() == Blocks.field_150436_aH) {
                    doBreakAbove = true;
                }
            }
        } else if (blockCheck instanceof IGrowable && conf.doesCrops && !(plant = (IGrowable)blockCheck).func_176473_a(world, posCurrent, blockState, world.field_72995_K)) {
            doBreak = true;
            stateReplant = blockCheck.func_176223_P();
        }
        if (doBreak) {
            List drops = blockCheck.getDrops((IBlockAccess)world, posCurrent, blockState, 0);
            if (doBreakAbove) {
                world.func_175655_b(posCurrent.func_177984_a(), false);
            }
            if (doBreakBelow) {
                world.func_175655_b(posCurrent.func_177977_b(), false);
            }
            if (stateReplant != null) {
                world.func_175655_b(posCurrent, false);
                world.func_175656_a(posCurrent, stateReplant);
                Item seedItem = blockCheck.func_180660_a(blockCheck.func_176223_P(), world.field_73012_v, 0);
                if (drops.size() > 1 && seedItem != null) {
                    Iterator iterator = drops.iterator();
                    while (iterator.hasNext()) {
                        ItemStack drop = (ItemStack)iterator.next();
                        if (drop.func_77973_b() != seedItem) continue;
                        iterator.remove();
                        break;
                    }
                }
                for (ItemStack drop : drops) {
                    UtilItemStack.dropItemStackInWorld(world, posCurrent, drop);
                }
            } else {
                world.func_175655_b(posCurrent, true);
            }
            return true;
        }
        return false;
    }

    public static class HarestCropsConfig {
        public boolean doesStem = false;
        public boolean doesSapling = false;
        public boolean doesMushroom = false;
        public boolean doesPumpkinBlocks = false;
        public boolean doesMelonBlocks = false;
        public boolean doesFlowers = false;
        public boolean doesLeaves = false;
        public boolean doesCrops = false;
        public boolean doesTallgrass = false;
        public boolean doesCactus = false;
        public boolean doesReeds = false;
        public boolean dropInPlace = true;

        public String toString() {
            String s = "";
            s = s + "doesHarvestStem = " + this.doesStem + System.lineSeparator();
            s = s + "doesHarvestSapling = " + this.doesSapling + System.lineSeparator();
            s = s + "doesHarvestMushroom = " + this.doesMushroom + System.lineSeparator();
            s = s + "doesPumpkinBlocks = " + this.doesPumpkinBlocks + System.lineSeparator();
            s = s + "doesMelonBlocks = " + this.doesMelonBlocks + System.lineSeparator();
            s = s + "doesFlowers = " + this.doesFlowers + System.lineSeparator();
            s = s + "doesCrops = " + this.doesCrops + System.lineSeparator();
            s = s + "doesHarvestTallgrass = " + this.doesTallgrass + System.lineSeparator();
            return s;
        }
    }
}

