/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.net.PacketSyncPlayerData;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapabilityRegistry {
    public static void register() {
        CapabilityManager.INSTANCE.register(IPlayerExtendedProperties.class, (Capability.IStorage)new Storage(), InstancePlayerExtendedProperties.class);
    }

    public static IPlayerExtendedProperties getPlayerProperties(EntityPlayer player) {
        return (IPlayerExtendedProperties)player.getCapability(ModCyclic.CAPABILITYSTORAGE, null);
    }

    public static void syncServerDataToClient(EntityPlayerMP p) {
        if (p == null) {
            return;
        }
        IPlayerExtendedProperties props = CapabilityRegistry.getPlayerProperties((EntityPlayer)p);
        if (props != null) {
            ModCyclic.network.sendTo((IMessage)new PacketSyncPlayerData(props.getDataAsNBT()), p);
        }
    }

    public static class Storage
    implements Capability.IStorage<IPlayerExtendedProperties> {
        public NBTTagCompound writeNBT(Capability<IPlayerExtendedProperties> capability, IPlayerExtendedProperties instance, EnumFacing side) {
            return instance.getDataAsNBT();
        }

        public void readNBT(Capability<IPlayerExtendedProperties> capability, IPlayerExtendedProperties instance, EnumFacing side, NBTBase nbt) {
            try {
                instance.setDataFromNBT((NBTTagCompound)nbt);
            }
            catch (Exception e) {
                ModCyclic.logger.error("Invalid NBT compound: " + e.getMessage());
                ModCyclic.logger.error(e.getStackTrace().toString());
            }
        }
    }

    public static class InstancePlayerExtendedProperties
    implements IPlayerExtendedProperties {
        private static final String MHEALTH = "mhealth";
        private static final String NBT_TODO = "todo";
        private static final String HAS_INVENTORY_EXTENDED = "hasInventoryExtended";
        private static final String HAS_INVENTORY_CRAFTING = "hasInventoryCrafting";
        private static final String IS_SLEEPING = "isSleeping";
        private static final String KEY_BOOLEAN = "ghost_on";
        private static final String KEY_TIMER = "ghost_timer";
        private static final String KEY_EATLOC = "ghost_location";
        private static final String KEY_EATDIM = "ghost_dim";
        private boolean isSleeping = false;
        private boolean hasInventoryCrafting = false;
        private boolean hasInventoryExtended = false;
        private String todo = "";
        private int health = 20;
        private boolean isChorusSpectator = false;
        private BlockPos chorusStart = null;
        private int chorusDim = 0;
        private int chorusSeconds = 0;

        @Override
        public boolean isSleeping() {
            return this.isSleeping;
        }

        @Override
        public void setSleeping(boolean value) {
            this.isSleeping = value;
        }

        @Override
        public boolean hasInventoryCrafting() {
            return this.hasInventoryCrafting;
        }

        @Override
        public void setInventoryCrafting(boolean value) {
            this.hasInventoryCrafting = value;
        }

        @Override
        public boolean hasInventoryExtended() {
            return this.hasInventoryExtended;
        }

        @Override
        public void setInventoryExtended(boolean value) {
            this.hasInventoryExtended = value;
        }

        @Override
        public NBTTagCompound getDataAsNBT() {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74774_a(IS_SLEEPING, (byte)(this.isSleeping() ? 1 : 0));
            tags.func_74774_a(HAS_INVENTORY_CRAFTING, (byte)(this.hasInventoryCrafting() ? 1 : 0));
            tags.func_74774_a(HAS_INVENTORY_EXTENDED, (byte)(this.hasInventoryExtended() ? 1 : 0));
            tags.func_74778_a(NBT_TODO, this.getTODO());
            tags.func_74768_a(MHEALTH, this.getMaxHealth());
            tags.func_74757_a(KEY_BOOLEAN, this.isChorusSpectator);
            tags.func_74778_a(KEY_EATLOC, UtilNBT.posToStringCSV(this.chorusStart));
            tags.func_74768_a(KEY_EATDIM, this.chorusDim);
            tags.func_74768_a(KEY_TIMER, this.chorusSeconds);
            return tags;
        }

        @Override
        public void setDataFromNBT(NBTTagCompound nbt) {
            String[] p;
            NBTTagCompound tags = !(nbt instanceof NBTTagCompound) ? new NBTTagCompound() : nbt;
            this.setSleeping(tags.func_74771_c(IS_SLEEPING) == 1);
            this.setInventoryCrafting(tags.func_74771_c(HAS_INVENTORY_CRAFTING) == 1);
            this.setInventoryExtended(tags.func_74771_c(HAS_INVENTORY_EXTENDED) == 1);
            this.setTODO(tags.func_74779_i(NBT_TODO));
            this.setMaxHealth(tags.func_74762_e(MHEALTH));
            this.setChorusDim(tags.func_74762_e(KEY_EATDIM));
            this.setChorusTimer(tags.func_74762_e(KEY_TIMER));
            this.setChorusOn(tags.func_74767_n(KEY_BOOLEAN));
            String posCSV = tags.func_74779_i(KEY_EATLOC);
            if (posCSV != null && posCSV.length() > 0 && (p = posCSV.split(",")) != null && p.length == 3) {
                this.setChorusStart(new BlockPos(Double.parseDouble(p[0]), Double.parseDouble(p[1]), Double.parseDouble(p[2])));
            }
        }

        @Override
        public String getTODO() {
            return this.todo;
        }

        @Override
        public void setTODO(String value) {
            this.todo = value;
        }

        @Override
        public int getMaxHealth() {
            return this.health;
        }

        @Override
        public void setMaxHealth(int value) {
            this.health = value;
        }

        @Override
        public boolean getChorusOn() {
            return this.isChorusSpectator;
        }

        @Override
        public void setChorusOn(boolean f) {
            this.isChorusSpectator = f;
        }

        @Override
        public BlockPos getChorusStart() {
            return this.chorusStart;
        }

        @Override
        public void setChorusStart(BlockPos s) {
            this.chorusStart = s;
        }

        @Override
        public int getChorusDim() {
            return this.chorusDim;
        }

        @Override
        public void setChorusDim(int d) {
            this.chorusDim = d;
        }

        @Override
        public int getChorusTimer() {
            return this.chorusSeconds;
        }

        @Override
        public void setChorusTimer(int d) {
            this.chorusSeconds = d;
        }
    }

    public static interface IPlayerExtendedProperties {
        public boolean isSleeping();

        public void setSleeping(boolean var1);

        public boolean hasInventoryCrafting();

        public void setInventoryCrafting(boolean var1);

        public boolean hasInventoryExtended();

        public void setInventoryExtended(boolean var1);

        public int getMaxHealth();

        public void setMaxHealth(int var1);

        public NBTTagCompound getDataAsNBT();

        public void setDataFromNBT(NBTTagCompound var1);

        public String getTODO();

        public void setTODO(String var1);

        public boolean getChorusOn();

        public void setChorusOn(boolean var1);

        public BlockPos getChorusStart();

        public void setChorusStart(BlockPos var1);

        public int getChorusDim();

        public void setChorusDim(int var1);

        public int getChorusTimer();

        public void setChorusTimer(int var1);
    }
}

