/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.module;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.module.BaseModule;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class MobSpawnModule
extends BaseModule
implements IHasConfig {
    private static final int group = 3;
    private static final int min = 1;
    private static final int max = 4;
    private boolean blazeDesertHills;
    private boolean magmaDesert;
    private boolean caveSpiderMesaRoofed;
    private boolean ghastDeepOcean;
    private boolean guardianRiver;
    private boolean snowmanIcePlainsMount;
    private boolean horseIceExtrhillsOcean;
    private boolean ironGolemJungle;
    private boolean pigmenMesa;

    @Override
    public void onInit() {
        if (this.pigmenMesa) {
            EntityRegistry.addSpawn(EntityPigZombie.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_150589_Z, Biomes.field_150608_ab, Biomes.field_150607_aa});
        }
        if (this.blazeDesertHills) {
            EntityRegistry.addSpawn(EntityBlaze.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76786_s});
        }
        if (this.magmaDesert) {
            EntityRegistry.addSpawn(EntityMagmaCube.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76786_s, Biomes.field_76769_d});
        }
        if (this.caveSpiderMesaRoofed) {
            EntityRegistry.addSpawn(EntityCaveSpider.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_150589_Z, Biomes.field_150608_ab, Biomes.field_150607_aa, Biomes.field_150585_R, Biomes.field_185430_ab});
        }
        if (this.ghastDeepOcean) {
            EntityRegistry.addSpawn(EntityGhast.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_150575_M});
        }
        if (this.guardianRiver) {
            EntityRegistry.addSpawn(EntityGuardian.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (Biome[])new Biome[]{Biomes.field_76781_i});
        }
        if (this.snowmanIcePlainsMount) {
            EntityRegistry.addSpawn(EntitySnowman.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])new Biome[]{Biomes.field_76775_o, Biomes.field_76774_n});
        }
        if (this.horseIceExtrhillsOcean) {
            EntityRegistry.addSpawn(EntityHorse.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])new Biome[]{Biomes.field_76770_e, Biomes.field_76774_n});
        }
        if (this.ironGolemJungle) {
            EntityRegistry.addSpawn(EntityIronGolem.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])new Biome[]{Biomes.field_76792_x, Biomes.field_76782_w, Biomes.field_185446_X, Biomes.field_185447_Y});
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.Mob Spawns";
        config.addCustomCategoryComment(category, "Add mob spawns in more biomes");
        this.blazeDesertHills = config.getBoolean("Blaze DesertHills", category, true, "Adds random Blaze spawns into Desert Hills");
        this.magmaDesert = config.getBoolean("Magmacube Desert", category, true, "Adds random Magma Cube spawns into Desert");
        this.caveSpiderMesaRoofed = config.getBoolean("CaveSpider Mesa&Roofed", category, true, "Adds random Cave Spider spawns into Mesa and Roofed Forests");
        this.ghastDeepOcean = config.getBoolean("Ghast DeepOcean", category, true, "Adds random Ghast spawns into Deep Oceans");
        this.guardianRiver = config.getBoolean("Guardian River", category, true, "Adds random Guardian spawns into Rivers");
        this.snowmanIcePlainsMount = config.getBoolean("Snowman Ice", category, true, "Adds random Snowman spawns into Ice Plains and Ice Mountains");
        this.horseIceExtrhillsOcean = config.getBoolean("Horse IceHills", category, true, "Adds random Horse spawns into Extreme Hills and Ice Plains");
        this.ironGolemJungle = config.getBoolean("IronGolem Jungle", category, true, "Adds random IronGolem spawns into the Jungle");
        this.pigmenMesa = config.getBoolean("PigmenMesa", category, false, "Pigmen spawn naturally in mesa");
    }
}

