/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.projectile;

import com.lothrazar.cyclicmagic.entity.projectile.EntityDynamite;
import com.lothrazar.cyclicmagic.entity.projectile.EntityDynamiteBlockSafe;
import com.lothrazar.cyclicmagic.entity.projectile.EntityDynamiteMining;
import com.lothrazar.cyclicmagic.entity.projectile.EntityThrowableDispensable;
import com.lothrazar.cyclicmagic.item.projectile.BaseItemProjectile;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemProjectileTNT
extends BaseItemProjectile {
    private ExplosionType type;
    private int strength;

    public ItemProjectileTNT(int str, ExplosionType t) {
        this.strength = str;
        this.type = t;
    }

    @Override
    public EntityThrowableDispensable getThrownEntity(World world, double x, double y, double z) {
        System.out.println("getThrownEntity " + this.type.name());
        switch (this.type) {
            case NORMAL: {
                return new EntityDynamite(world, this.strength, x, y, z);
            }
            case MINING: {
                return new EntityDynamiteMining(world, this.strength, x, y, z);
            }
            case BLOCKSAFE: {
                return new EntityDynamiteBlockSafe(world, this.strength, x, y, z);
            }
        }
        return null;
    }

    @Override
    void onItemThrow(ItemStack held, World world, EntityPlayer player, EnumHand hand) {
        System.out.println("onItemThrow " + this.type.name());
        EntityThrowableDispensable d = null;
        switch (this.type) {
            case NORMAL: {
                d = new EntityDynamite(world, (EntityLivingBase)player, this.strength);
                break;
            }
            case MINING: {
                d = new EntityDynamiteMining(world, (EntityLivingBase)player, this.strength);
                break;
            }
            case BLOCKSAFE: {
                d = new EntityDynamiteBlockSafe(world, (EntityLivingBase)player, this.strength);
                break;
            }
        }
        this.doThrow(world, player, hand, d);
    }

    public static enum ExplosionType {
        NORMAL,
        BLOCKSAFE,
        MINING;

    }
}

