/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.item.BaseItem;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPasswordRemote
extends BaseItem
implements IHasRecipe {
    public ItemPasswordRemote() {
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        BlockPos pointer = UtilNBT.getItemStackBlockPos(stack);
        if (pointer != null) {
            tooltip.add(TextFormatting.RED + UtilChat.blockPosToString(pointer));
        }
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.func_180495_p(pos).func_177230_c() instanceof BlockLever) {
            UtilNBT.setItemStackBlockPos(stack, pos);
            if (worldIn.field_72995_K) {
                UtilChat.addChatMessage(playerIn, this.func_77658_a() + ".saved");
            }
            UtilSound.playSound(playerIn, SoundEvents.field_187750_dc);
            return EnumActionResult.SUCCESS;
        }
        boolean success = false;
        success = this.trigger(stack, worldIn, playerIn);
        if (success) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        boolean success = false;
        success = this.trigger(stack, worldIn, playerIn);
        if (success) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    private boolean trigger(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        BlockPos pointer = UtilNBT.getItemStackBlockPos(stack);
        if (pointer == null) {
            if (worldIn.field_72995_K) {
                UtilChat.addChatMessage(playerIn, this.func_77658_a() + ".invalid");
            }
            return false;
        }
        IBlockState blockState = worldIn.func_180495_p(pointer);
        if (blockState == null || blockState.func_177230_c() != Blocks.field_150442_at) {
            UtilChat.addChatMessage(playerIn, this.func_77658_a() + ".invalid");
            return false;
        }
        boolean hasPowerHere = (Boolean)blockState.func_177229_b((IProperty)BlockLever.field_176359_b);
        worldIn.func_175656_a(pointer, blockState.func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf(!hasPowerHere)));
        UtilSound.playSound(playerIn, SoundEvents.field_187750_dc);
        return true;
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{new ItemStack((Block)Blocks.field_150333_U, 1, BlockStoneSlab.EnumType.STONE.func_176624_a()), Blocks.field_150430_aB, Blocks.field_150442_at});
    }
}

