/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.lothrazar.cyclicmagic.ICanToggleOnOff;
import com.lothrazar.cyclicmagic.item.BaseItem;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles", striprefs=true)
public abstract class BaseCharm
extends BaseItem
implements IBauble,
ICanToggleOnOff {
    private static final String NBT_STATUS = "onoff";

    public BaseCharm(int durability) {
        this.func_77625_d(1);
        this.func_77656_e(durability);
    }

    @Override
    public void toggleOnOff(ItemStack held) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(held);
        int vnew = this.isOn(held) ? 0 : 1;
        tags.func_74768_a(NBT_STATUS, vnew);
    }

    @Override
    public boolean isOn(ItemStack held) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(held);
        if (!tags.func_74764_b(NBT_STATUS)) {
            return true;
        }
        return tags.func_74762_e(NBT_STATUS) == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.canTick(stack);
    }

    public boolean canTick(ItemStack stack) {
        return this.isOn(stack) && stack.func_77952_i() < stack.func_77958_k();
    }

    public void damageCharm(EntityPlayer living, ItemStack stack) {
        UtilItemStack.damageItem(living, stack);
    }

    public void addRecipeAndRepair(Item craftItem) {
        this.addRecipeAndRepair(new ItemStack(craftItem));
    }

    public void addRecipeAndRepair(ItemStack craftItem) {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"r x", "id ", "iir", Character.valueOf('x'), craftItem, Character.valueOf('d'), Items.field_151045_i, Character.valueOf('r'), Items.field_151075_bm, Character.valueOf('i'), Items.field_151042_j});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{new ItemStack((Item)this, 1, Short.MAX_VALUE), craftItem});
    }

    public abstract void onTick(ItemStack var1, EntityPlayer var2);

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack arg0) {
        try {
            if (BaubleType.values().length >= 4) {
                return BaubleType.TRINKET;
            }
            return BaubleType.RING;
        }
        catch (Exception e) {
            return BaubleType.RING;
        }
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase arg1) {
        if (!this.canTick(stack)) {
            return;
        }
        if (arg1 instanceof EntityPlayer && stack != null && stack.field_77994_a > 0) {
            this.onTick(stack, (EntityPlayer)arg1);
        }
    }

    @Override
    public void func_77624_a(ItemStack held, EntityPlayer player, List<String> list, boolean par4) {
        super.func_77624_a(held, player, list, par4);
        String onoff = this.isOn(held) ? "on" : "off";
        list.add(UtilChat.lang("item.cantoggle.tooltip.info") + UtilChat.lang("item.cantoggle.tooltip." + onoff));
    }
}

