/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.tileentity;

import com.lothrazar.cyclicmagic.block.tileentity.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.block.tileentity.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileMachinePlacer
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable {
    private int timer;
    private static final int buildSpeed = 1;
    private int needsRedstone = 1;
    private ItemStack[] inv = new ItemStack[9];
    public static final int TIMER_FULL = 75;
    private int[] hopperInput = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final String NBT_INV = "Inventory";
    private static final String NBT_SLOT = "Slot";
    private static final String NBT_TIMER = "Timer";
    private static final String NBT_REDST = "redstone";

    @Override
    public int func_70302_i_() {
        return this.inv.length;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        return this.inv[index];
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            if (stack.field_77994_a <= count) {
                this.func_70299_a(index, null);
            } else {
                stack = stack.func_77979_a(count);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(index, null);
                }
            }
        }
        return stack;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        this.inv[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) != null;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    return this.timer;
                }
                case REDSTONE: {
                    return this.needsRedstone;
                }
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    this.timer = value;
                    break;
                }
                case REDSTONE: {
                    this.needsRedstone = value;
                }
            }
        }
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    public int getTimer() {
        return this.func_174887_a_(Fields.TIMER.ordinal());
    }

    @Override
    public void func_174888_l() {
        for (int i = 0; i < this.inv.length; ++i) {
            this.inv[i] = null;
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e(NBT_REDST);
        this.timer = tagCompound.func_74762_e(NBT_TIMER);
        NBTTagList tagList = tagCompound.func_150295_c(NBT_INV, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c(NBT_SLOT);
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a(NBT_REDST, this.needsRedstone);
        tagCompound.func_74768_a(NBT_TIMER, this.timer);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a(NBT_SLOT, (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a(NBT_INV, (NBTBase)itemList);
        return super.func_189515_b(tagCompound);
    }

    public boolean isBurning() {
        return this.timer > 0 && this.timer < 75;
    }

    public void func_73660_a() {
        Block stuff;
        this.shiftAllUp();
        boolean trigger = false;
        if (!this.isRunning()) {
            this.func_70296_d();
            return;
        }
        this.spawnParticlesAbove();
        ItemStack stack = this.func_70301_a(0);
        if (stack == null) {
            this.timer = 75;
        } else {
            --this.timer;
            if (this.timer <= 0) {
                this.timer = 75;
                trigger = true;
            }
        }
        if (trigger && (stuff = Block.func_149634_a((Item)stack.func_77973_b())) != null && UtilPlaceBlocks.placeStateSafe(this.func_145831_w(), null, this.field_174879_c.func_177972_a(this.getCurrentFacing()), UtilItemStack.getStateFromMeta(stuff, stack.func_77960_j())) && !this.func_145831_w().field_72995_K) {
            this.func_70298_a(0, 1);
        }
        this.func_70296_d();
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return this.hopperInput;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            this.func_70299_a(index, null);
        }
        return stack;
    }

    public boolean func_145842_c(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            this.func_174885_b(id, value);
            return true;
        }
        return super.func_145842_c(id, value);
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum Fields {
        TIMER,
        REDSTONE;

    }
}

