/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.tileentity;

import com.lothrazar.cyclicmagic.block.tileentity.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.block.tileentity.ITileSizeToggle;
import com.lothrazar.cyclicmagic.block.tileentity.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.util.UtilHarvestCrops;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilShape;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class TileMachineHarvester
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITileSizeToggle,
ITickable {
    private int timer = TIMER_FULL;
    public static int TIMER_FULL = 80;
    private UtilHarvestCrops.HarestCropsConfig conf = new UtilHarvestCrops.HarestCropsConfig();
    private int needsRedstone = 1;
    private static final String NBT_TIMER = "Timer";
    private static final String NBT_REDST = "redstone";
    private static final int MAX_SIZE = 7;
    private int size = 7;

    public TileMachineHarvester() {
        this.conf.doesCrops = true;
        this.conf.doesMushroom = true;
        this.conf.doesPumpkinBlocks = true;
        this.conf.doesMelonBlocks = true;
    }

    public void setHarvestConf(UtilHarvestCrops.HarestCropsConfig c) {
        this.conf = c;
    }

    public UtilHarvestCrops.HarestCropsConfig getHarvestConf() {
        return this.conf;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.needsRedstone = tagCompound.func_74762_e(NBT_REDST);
        this.timer = tagCompound.func_74762_e(NBT_TIMER);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a(NBT_TIMER, this.timer);
        tagCompound.func_74768_a(NBT_REDST, this.needsRedstone);
        return super.func_189515_b(tagCompound);
    }

    public boolean isBurning() {
        return this.timer > 0 && this.timer < TIMER_FULL;
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            this.func_70296_d();
            return;
        }
        this.spawnParticlesAbove();
        boolean trigger = false;
        this.timer -= this.getSpeed();
        if (this.timer <= 0) {
            this.timer = TIMER_FULL;
            trigger = true;
        }
        if (trigger) {
            BlockPos harvest = this.getHarvestPos();
            if (UtilHarvestCrops.harvestSingle(this.func_145831_w(), harvest, this.conf)) {
                UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.DRAGON_BREATH, harvest);
                this.timer = TIMER_FULL;
            } else {
                this.timer = 1;
            }
        } else {
            this.spawnParticlesAbove();
        }
        this.func_70296_d();
    }

    public BlockPos getTargetCenter() {
        return this.func_174877_v().func_177967_a(this.getCurrentFacing(), this.size + 1);
    }

    private BlockPos getHarvestPos() {
        return UtilWorld.getRandomPos(this.func_145831_w().field_73012_v, this.getTargetCenter(), this.size);
    }

    @Override
    public void displayPreview() {
        List<BlockPos> allPos = UtilShape.squareHorizontalHollow(this.getTargetCenter(), this.size);
        for (BlockPos pos : allPos) {
            UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.DRAGON_BREATH, pos);
        }
    }

    private int getSpeed() {
        return 1;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    return this.timer;
                }
                case REDSTONE: {
                    return this.needsRedstone;
                }
                case SIZE: {
                    return this.size;
                }
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    this.timer = value;
                    break;
                }
                case REDSTONE: {
                    this.needsRedstone = value;
                    break;
                }
                case SIZE: {
                    this.size = value;
                    break;
                }
            }
        }
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public int func_70302_i_() {
        return 0;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        return null;
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        return null;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        return null;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public void toggleSizeShape() {
        ++this.size;
        if (this.size > 7) {
            this.size = 0;
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        if (val > 1) {
            val = 0;
        }
        this.func_174885_b(Fields.REDSTONE.ordinal(), val);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum Fields {
        TIMER,
        REDSTONE,
        SIZE;

    }
}

