/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.tileentity;

import com.lothrazar.cyclicmagic.block.tileentity.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.block.tileentity.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityXpPylon
extends TileEntityBaseMachineInvo
implements ITickable,
ITileRedstoneToggle {
    private static final int XP_PER_SPEWORB = 10;
    private static final int XP_PER_BOTTLE = 11;
    public static final int TIMER_FULL = 18;
    public static final int MAX_EXP_HELD = 1000;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    private static final String NBT_TIMER = "Timer";
    private static final String NBT_REDST = "redstone";
    private static final String NBT_EXP = "particles";
    private static final String NBT_MODE = "pushpull";
    private static final int RANGE = 2;
    private static final int[] SLOTS_EXTRACT = new int[]{1};
    private static final int[] SLOTS_INSERT = new int[]{0};
    private int timer = 0;
    private int needsRedstone = 1;
    private int mode = 0;
    private int currentExp = 0;
    private ItemStack[] inv = new ItemStack[2];

    public void func_73660_a() {
        if (this.mode == Mode.COLLECT.ordinal()) {
            this.updateCollection();
            this.updateBottle();
        } else if (this.mode == Mode.SPEW.ordinal()) {
            this.updateSpew();
        }
    }

    private void updateSpew() {
        --this.timer;
        if (this.timer <= 0) {
            this.timer = 18;
            int amtToSpew = Math.min(10, this.currentExp);
            if (amtToSpew > 0 && this.tryDecrExp(amtToSpew) && !this.func_145831_w().field_72995_K) {
                EntityXPOrb orb = new EntityXPOrb(this.func_145831_w());
                orb.func_70634_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                orb.field_70530_e = amtToSpew;
                this.func_145831_w().func_72838_d((Entity)orb);
                this.spewOrb(orb);
            }
        }
    }

    private void updateBottle() {
        --this.timer;
        if (this.timer <= 0) {
            this.timer = 18;
            if (this.outputSlotHasRoom() && this.inputSlotHasSome() && this.tryDecrExp(11)) {
                this.outputSlotIncrement();
                this.inputSlotDecrement();
            }
        }
    }

    private void updateCollection() {
        List orbs = this.func_145831_w().func_72872_a(EntityXPOrb.class, new AxisAlignedBB(this.func_174877_v().func_177984_a()).func_186662_g(2.0));
        if (orbs != null) {
            for (EntityXPOrb orb : orbs) {
                if (!orb.field_70128_L && this.tryIncrExp(orb.func_70526_d())) {
                    this.func_145831_w().func_72900_e((Entity)orb);
                    continue;
                }
                this.spewOrb(orb);
            }
        }
    }

    private void outputSlotIncrement() {
        ItemStack fullOnes = this.func_70301_a(1);
        if (UtilItemStack.isEmpty(fullOnes)) {
            fullOnes = new ItemStack(Items.field_151062_by);
        } else {
            ++fullOnes.field_77994_a;
        }
        this.func_70299_a(1, fullOnes);
    }

    private boolean outputSlotHasRoom() {
        ItemStack fullOnes = this.func_70301_a(1);
        return UtilItemStack.isEmpty(fullOnes) || fullOnes.field_77994_a < 64;
    }

    private boolean inputSlotHasSome() {
        ItemStack emptyOnes = this.func_70301_a(0);
        return !UtilItemStack.isEmpty(emptyOnes) && emptyOnes.field_77994_a > 0;
    }

    private void inputSlotDecrement() {
        ItemStack fullOnes = this.func_70301_a(0);
        --fullOnes.field_77994_a;
        if (fullOnes.field_77994_a == 0) {
            fullOnes = null;
        }
        this.func_70299_a(0, fullOnes);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return SLOTS_EXTRACT;
        }
        return SLOTS_INSERT;
    }

    private boolean tryDecrExp(int xpValue) {
        if (this.currentExp - xpValue < 0) {
            return false;
        }
        this.currentExp -= xpValue;
        return true;
    }

    private boolean tryIncrExp(int xpValue) {
        if (this.currentExp + xpValue > 1000) {
            return false;
        }
        this.currentExp += xpValue;
        return true;
    }

    private void spewOrb(EntityXPOrb orb) {
        orb.func_70024_g(Math.random() / 1000.0, 0.01, Math.random() / 1000.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74768_a(NBT_TIMER, this.timer);
        tags.func_74768_a(NBT_REDST, this.needsRedstone);
        tags.func_74768_a(NBT_EXP, this.currentExp);
        tags.func_74768_a(NBT_MODE, this.mode);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tags.func_74782_a("Inventory", (NBTBase)itemList);
        return super.func_189515_b(tags);
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.timer = tags.func_74762_e(NBT_TIMER);
        this.needsRedstone = tags.func_74762_e(NBT_REDST);
        this.currentExp = tags.func_74762_e(NBT_EXP);
        this.mode = tags.func_74762_e(NBT_MODE);
        NBTTagList tagList = tags.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val % 2);
    }

    private void setExp(int value) {
        this.currentExp = value;
    }

    private void setMode(int value) {
        if (value >= Mode.values().length) {
            value = 0;
        }
        this.mode = value;
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    return this.timer;
                }
                case REDSTONE: {
                    return this.needsRedstone;
                }
                case EXP: {
                    return this.currentExp;
                }
                case MODE: {
                    return this.mode;
                }
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    this.timer = value;
                    break;
                }
                case REDSTONE: {
                    this.needsRedstone = value;
                    break;
                }
                case EXP: {
                    this.setExp(value);
                    break;
                }
                case MODE: {
                    this.setMode(value);
                }
            }
        }
    }

    @Override
    public int func_70302_i_() {
        return this.inv.length;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        return this.inv[index];
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            if (stack.field_77994_a <= count) {
                this.func_70299_a(index, null);
            } else {
                stack = stack.func_77979_a(count);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(index, null);
                }
            }
        }
        return stack;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            this.func_70299_a(index, null);
        }
        return stack;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        this.inv[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public static enum Mode {
        COLLECT,
        SPEW;

    }

    public static enum Fields {
        TIMER,
        EXP,
        MODE,
        REDSTONE;

    }
}

