/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Logger;
import shetiphian.core.common.NBTFile;
import shetiphian.endertanks.Values;

public class TankHelper {
    public static final TankHelper INSTANCE = new TankHelper();
    private static final Table<String, String, EnderTank> DATABASE = HashBasedTable.create();
    private static final Table<String, String, EnderTank> CLIENTCACHE = HashBasedTable.create();
    private static boolean needsSaving = false;
    private static boolean isLoaded = false;

    private static Table<String, String, EnderTank> getDatabase(boolean isClient) {
        return isClient ? CLIENTCACHE : DATABASE;
    }

    public static FluidTank getTank(String owner, String code, boolean isClient) {
        EnderTank tank = (EnderTank)((Object)TankHelper.getDatabase(isClient).get((Object)owner.toLowerCase(), (Object)code.toUpperCase()));
        if (tank == null) {
            tank = new EnderTank(Values.tankSizeMin * 1000);
            TankHelper.getDatabase(isClient).put((Object)owner.toLowerCase(), (Object)code.toUpperCase(), (Object)tank);
        }
        return tank;
    }

    public static void updateTank(String owner, String code, FluidStack fluidStack, boolean isClient) {
        TankHelper.getTank(owner, code, isClient).setFluid(fluidStack);
    }

    public static short getCapacityInBuckets(FluidTank tank) {
        return (short)(tank.getCapacity() / 1000);
    }

    public static void setCapacityInBuckets(FluidTank tank, short capacity) {
        tank.setCapacity(capacity * 1000);
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        if (event.getWorld() == null || event.getWorld().field_72995_K || !needsSaving) {
            return;
        }
        if (!isLoaded) {
            Values.logEnderTanks.error("Attempted to save EnderTank Data when nothing is loaded");
            return;
        }
        this.saveTankData();
    }

    private void saveTankData() {
        Set networks = DATABASE.rowKeySet();
        for (String owner : networks) {
            Map networkMap = DATABASE.row((Object)owner);
            NBTTagCompound fileNBT = new NBTTagCompound();
            for (Map.Entry pocket : networkMap.entrySet()) {
                FluidTank tank = (FluidTank)pocket.getValue();
                if (tank.getFluidAmount() <= 0 && tank.getCapacity() <= Values.tankSizeMin) continue;
                NBTTagCompound nbtPocket = tank.writeToNBT(new NBTTagCompound());
                nbtPocket.func_74777_a("Capacity", (short)(tank.getCapacity() / 1000));
                fileNBT.func_74782_a((String)pocket.getKey(), (NBTBase)nbtPocket);
            }
            NBTFile.write((NBTTagCompound)fileNBT, (File)this.getSaveFile(owner), (Logger)Values.logEnderTanks);
        }
        needsSaving = false;
    }

    public void loadTankData() {
        Values.logEnderTanks.info("Loading EnderTank Data");
        List<File> fileList = this.getSaveFiles();
        for (File file : fileList) {
            String owner = this.getOwnerID(file.getName().replace(".dat", ""));
            NBTTagCompound fileNBT = NBTFile.read((File)file, (Logger)Values.logEnderTanks);
            for (String code : fileNBT.func_150296_c()) {
                NBTTagCompound nbtPocket = fileNBT.func_74775_l(code);
                int capacity = MathHelper.func_76125_a((int)nbtPocket.func_74765_d("Capacity"), (int)Values.tankSizeMin, (int)Values.tankSizeMax);
                EnderTank tank = new EnderTank(capacity * 1000);
                tank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtPocket));
                DATABASE.put((Object)owner.toLowerCase(), (Object)code.toUpperCase(), (Object)tank);
            }
        }
        isLoaded = true;
    }

    public void unloadTankData() {
        if (isLoaded) {
            Values.logEnderTanks.info("Saving EnderTank Data");
            this.saveTankData();
            Values.logEnderTanks.info("Unloading EnderTank Data");
        }
        CLIENTCACHE.clear();
        DATABASE.clear();
        isLoaded = false;
    }

    private List<File> getSaveFiles() {
        ArrayList<File> fileList = new ArrayList<File>();
        String saveDir = DimensionManager.getCurrentSaveRootDirectory() + File.separator + "endertanks";
        File[] listOfFiles = null;
        try {
            File saveFolder = new File(saveDir);
            listOfFiles = saveFolder.listFiles();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                if (!file.isFile() || !file.canRead() || !file.getName().endsWith(".dat")) continue;
                fileList.add(file);
            }
        }
        return fileList;
    }

    private File getSaveFile(String owner) {
        String saveDir = DimensionManager.getCurrentSaveRootDirectory() + File.separator + "endertanks";
        File file = new File(saveDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(saveDir, this.getSaveID(owner) + ".dat")).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception error) {
                Values.logEnderTanks.error("Could Not Read or Create File: " + file.toString(), (Throwable)error);
            }
        }
        return file;
    }

    private String getSaveID(String owner) {
        return owner.equalsIgnoreCase("all") ? "[-Public-]" : owner;
    }

    private String getOwnerID(String owner) {
        return owner.equalsIgnoreCase("[-Public-]") ? "all" : owner;
    }

    private static class EnderTank
    extends FluidTank {
        EnderTank(int capacity) {
            super(capacity);
        }

        boolean areFluidStacksEqual(FluidStack stackA, FluidStack stackB) {
            return stackA == null && stackB == null || stackA != null && stackB != null && stackA.isFluidEqual(stackB);
        }

        public void setFluid(@Nullable FluidStack fluid) {
            if (!this.areFluidStacksEqual(this.getFluid(), fluid)) {
                super.setFluid(fluid);
                needsSaving = true;
            }
        }

        public void setCapacity(int capacity) {
            if (this.getCapacity() != capacity) {
                super.setCapacity(capacity);
                needsSaving = true;
            }
        }

        protected void onContentsChanged() {
            needsSaving = true;
        }
    }
}

