/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad.gui;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.widget.GuiScrollableList;
import com.enderio.core.client.render.EnderWidget;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.telepad.TelepadTarget;
import crazypants.enderio.teleport.telepad.TileDialingDevice;
import crazypants.enderio.teleport.telepad.packet.PacketTargetList;
import java.awt.Rectangle;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTargetList
extends GuiScrollableList<TelepadTarget> {
    private final TileDialingDevice te;

    public GuiTargetList(int width, int height, int originX, int originY, TileDialingDevice te) {
        super(width, height, originX, originY, Minecraft.func_71410_x().field_71466_p.field_78288_b + 4);
        this.te = te;
    }

    public TelepadTarget getElementAt(int index) {
        ArrayList<TelepadTarget> targs = this.te.getTargets();
        if (index < 0 || index >= targs.size()) {
            return null;
        }
        return targs.get(index);
    }

    public int getNumElements() {
        return this.te.getTargets().size();
    }

    protected void drawElement(int elementIndex, int x, int y, int height, VertexBuffer renderer) {
        TelepadTarget targ = this.getElementAt(elementIndex);
        if (targ == null) {
            return;
        }
        String name = targ.getName();
        if (name == null || name.trim().length() == 0) {
            name = "Unnamed";
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        fr.func_175065_a(name, (float)(x + 4), (float)(y + 2), 0xFFFFFF, true);
        if (this.getSelectedElement() == targ) {
            Rectangle iconBounds = this.getIconBounds(y);
            EnderWidget icon = EnderWidget.X_BUT;
            if (iconBounds.contains(this.mouseX, this.mouseY)) {
                icon = EnderWidget.X_BUT_HOVER;
            }
            EnderWidget.map.render((IWidgetIcon)icon, (double)iconBounds.x, (double)iconBounds.y, (double)iconBounds.width, (double)iconBounds.height, 0.0, true);
        }
    }

    protected boolean elementClicked(int elementIndex, boolean doubleClick, int elX, int elY) {
        TelepadTarget target = (TelepadTarget)this.getSelectedElement();
        if (target == null) {
            return true;
        }
        Rectangle iconBounds = this.getIconBounds(0);
        if (iconBounds.contains(elX, elY)) {
            this.te.removeTarget(target);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTargetList(this.te, target, false));
        }
        return true;
    }

    public Rectangle getIconBounds(int minElY) {
        EnderWidget icon = EnderWidget.RETURN_BUT_HOVER;
        int xPos = this.minX + this.width - icon.width - 2;
        if (this.getContentOverhang() > 0) {
            xPos -= 6;
        }
        Rectangle iconBounds = new Rectangle(xPos, minElY + 1, icon.width, icon.height);
        return iconBounds;
    }
}

