/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.GuiScreenBase;
import com.enderio.core.client.gui.button.TooltipButton;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.telepad.TelepadTarget;
import crazypants.enderio.teleport.telepad.packet.PacketUpdateLocationPrintout;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiLocationPrintout
extends GuiScreenBase {
    private static final ResourceLocation GUI_BACKGROUND = EnderIO.proxy.getGuiTexture("locationPrintout");
    private final TextFieldEnder tf;
    private TooltipButton okB;
    private final ItemStack stack;
    private final TelepadTarget target;
    private final EntityEquipmentSlot slot;
    private boolean isCancelled = false;

    public GuiLocationPrintout(ItemStack stack) {
        this(stack, null);
    }

    public GuiLocationPrintout(EntityPlayer player, EntityEquipmentSlot slot) {
        this(player.func_184582_a(slot), slot);
    }

    public GuiLocationPrintout(ItemStack stack, EntityEquipmentSlot slot) {
        this.slot = slot;
        this.stack = stack;
        this.target = TelepadTarget.readFromNBT(stack);
        this.xSize = 176;
        this.ySize = 116;
        int tfWidth = 90;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        this.tf = new TextFieldEnder(fr, this.xSize / 2 - tfWidth / 2, 20, tfWidth, 16);
        this.tf.func_146203_f(32);
        this.okB = new TooltipButton((IGuiScreen)this, 0, this.xSize - 30, this.ySize - 30, 20, 20, "Ok");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tf.func_146195_b(true);
        String txt = this.target.getName();
        if (txt != null && txt.length() > 0) {
            this.tf.func_146180_a(txt);
        }
        this.tf.init((IGuiScreen)this);
        this.okB.onGuiInit();
    }

    public void func_73876_c() {
        this.tf.func_146178_a();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.field_146297_k.field_71439_g.func_71053_j();
    }

    protected void func_73869_a(char c, int key) throws IOException {
        if (key == 1 || key == 28) {
            this.isCancelled = key == 1;
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        this.tf.func_146201_a(c, key);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.tf.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void drawBackgroundLayer(float par3, int par1, int par2) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture((ResourceLocation)GUI_BACKGROUND);
        this.func_73729_b(this.getGuiLeft(), this.getGuiTop(), 0, 0, this.xSize, this.ySize);
        this.checkLabelForChange();
        this.tf.func_146194_f();
        FontRenderer fontRenderer = this.getFontRenderer();
        int col = ColorUtil.getRGB((Color)Color.white);
        int midX = this.getGuiLeft() + this.xSize / 2;
        int y = this.getGuiTop() + 48;
        BlockPos loc = this.target.getLocation();
        String txt = loc.func_177958_n() + " " + loc.func_177956_o() + " " + loc.func_177952_p();
        int x = midX - fontRenderer.func_78256_a(txt) / 2;
        fontRenderer.func_175063_a(txt, (float)x, (float)y, col);
        txt = TelepadTarget.getDimenionName(this.target.getDimension());
        x = midX - fontRenderer.func_78256_a(txt) / 2;
        fontRenderer.func_175063_a(txt, (float)x, (float)(y += fontRenderer.field_78288_b + 4), col);
    }

    private void checkLabelForChange() {
        String curText;
        String newTxt = this.tf.func_146179_b();
        if (newTxt != null && newTxt.length() == 0) {
            newTxt = null;
        }
        if ((curText = this.target.getName()) != null && curText.length() == 0) {
            curText = null;
        }
        boolean changed = false;
        if (newTxt == null) {
            changed = curText != null;
        } else {
            boolean bl = changed = !newTxt.equals(curText);
        }
        if (!changed) {
            return;
        }
        this.target.setName(newTxt);
        this.target.writeToNBT(this.stack);
        if (this.slot != null) {
            PacketUpdateLocationPrintout p = new PacketUpdateLocationPrintout(this.stack, this.slot);
            PacketHandler.INSTANCE.sendToServer((IMessage)p);
        }
    }

    public void func_146281_b() {
        if (this.slot == null && !this.isCancelled) {
            PacketUpdateLocationPrintout p = new PacketUpdateLocationPrintout(this.stack, this.slot);
            PacketHandler.INSTANCE.sendToServer((IMessage)p);
        }
    }

    public void clearToolTips() {
    }

    public boolean func_73868_f() {
        return false;
    }
}

