/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.api.common.util.ITankAccess;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.ITelePad;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.capacitor.CapacitorKeyType;
import crazypants.enderio.capacitor.DefaultCapacitorData;
import crazypants.enderio.capacitor.DefaultCapacitorKey;
import crazypants.enderio.capacitor.ICapacitorData;
import crazypants.enderio.capacitor.ICapacitorKey;
import crazypants.enderio.capacitor.Scaler;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.fluid.SmartTank;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.MachineSound;
import crazypants.enderio.machine.PacketPowerStorage;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.IInternalPowerReceiver;
import crazypants.enderio.teleport.TeleportUtil;
import crazypants.enderio.teleport.anchor.TileTravelAnchor;
import crazypants.enderio.teleport.telepad.TelepadTarget;
import crazypants.enderio.teleport.telepad.packet.PacketFluidLevel;
import crazypants.enderio.teleport.telepad.packet.PacketSetTarget;
import crazypants.enderio.teleport.telepad.packet.PacketTeleport;
import crazypants.enderio.teleport.telepad.render.BlockType;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nonnull;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileTelePad
extends TileTravelAnchor
implements IInternalPowerReceiver,
ITelePad,
IProgressTile,
IItemHandlerModifiable,
ITankAccess.IExtendedTankAccess {
    private ICapacitorData capacitorData = DefaultCapacitorData.BASIC_CAPACITOR;
    private final ICapacitorKey maxEnergyRecieved = new DefaultCapacitorKey(ModObject.blockTelePad, CapacitorKeyType.ENERGY_INTAKE, Scaler.Factory.POWER, Config.telepadEnergyUsePerTickRF);
    private final ICapacitorKey maxEnergyStored = new DefaultCapacitorKey(ModObject.blockTelePad, CapacitorKeyType.ENERGY_BUFFER, Scaler.Factory.POWER, Config.telepadEnergyBufferRF);
    private final ICapacitorKey maxEnergyUsed = new DefaultCapacitorKey(ModObject.blockTelePad, CapacitorKeyType.ENERGY_USE, Scaler.Factory.POWER, Config.telepadEnergyUsePerTickRF);
    @Store
    private int storedEnergyRF;
    private TileTelePad masterTile = null;
    private boolean coordsChanged = false;
    @Store
    private TelepadTarget target = new TelepadTarget(new BlockPos(0, 0, 0), Integer.MIN_VALUE);
    private int lastSyncPowerStored;
    private Queue<Entity> toTeleport = Queues.newArrayDeque();
    private int powerUsed;
    private int requiredPower;
    public static final ResourceLocation ACTIVE_RES = AbstractMachineEntity.getSoundFor("telepad.active");
    @SideOnly(value=Side.CLIENT)
    private MachineSound activeSound;
    @Store
    private boolean redstoneActivePrev;
    private final Fluid fluidType;
    @Store
    protected SmartTank tank;
    private boolean tankDirty = false;
    public static final String TELEPORTING_KEY = "eio:teleporting";
    public static final String PROGRESS_KEY = "teleportprogress";
    boolean wasBlocked = false;
    public float[] bladeRots = new float[3];
    public float spinSpeed = 0.0f;
    public float speedMult = 2.5f;
    @Store
    protected ItemStack[] inventory = new ItemStack[2];

    public TileTelePad() {
        Fluid fluid = null;
        if (Config.rodOfReturnFluidType != null) {
            fluid = FluidRegistry.getFluid((String)Config.telepadFluidType);
        }
        if (fluid == null) {
            fluid = Fluids.fluidEnderDistillation;
        }
        this.fluidType = fluid;
        int tankCap = 0;
        if (Config.telepadFluidUse > 0) {
            tankCap = Config.telepadFluidUse * 10;
        }
        this.tank = new SmartTank(this.fluidType, tankCap);
        if (tankCap <= 0) {
            this.tank.setCanFill(false);
        }
        this.tank.setCanDrain(false);
        this.tank.setTileEntity((TileEntity)this);
    }

    public boolean isFluidEnabled() {
        return this.tank.getCapacity() > 0;
    }

    public boolean wasBlocked() {
        return this.wasBlocked;
    }

    public void setBlocked(boolean blocked) {
        this.wasBlocked = blocked;
    }

    @Override
    public boolean isMaster() {
        return BlockType.getType(this.func_145832_p()) == BlockType.MASTER;
    }

    @Override
    public TileTelePad getMaster() {
        if (BlockType.getType(this.func_145832_p()) == BlockType.MASTER) {
            return this;
        }
        BlockPos offset = BlockType.getType(this.func_145832_p()).getOffsetToMaster();
        if (offset == null) {
            return null;
        }
        BlockPos materPos = this.func_174877_v().func_177982_a(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
        if (!this.field_145850_b.func_175667_e(materPos)) {
            return null;
        }
        TileEntity res = this.field_145850_b.func_175625_s(materPos);
        if (res instanceof TileTelePad) {
            return (TileTelePad)res;
        }
        return null;
    }

    @Override
    public boolean inNetwork() {
        return this.getMaster() != null;
    }

    @Override
    public void doUpdate() {
        boolean powerChanged;
        if (!this.isMaster()) {
            return;
        }
        if (this.target.getDimension() == Integer.MIN_VALUE) {
            this.target.setDimension(this.field_145850_b.field_73011_w.getDimension());
        }
        if (this.field_145850_b.field_72995_K) {
            this.updateEntityClient();
            return;
        }
        if (this.inventory[0] != null && this.inventory[1] == null) {
            ItemStack stack = this.inventory[0];
            TelepadTarget newTarg = TelepadTarget.readFromNBT(stack);
            this.setTarget(newTarg);
            this.inventory[0] = null;
            this.inventory[1] = stack;
            this.func_70296_d();
        }
        if (this.tankDirty && this.shouldDoWorkThisTick(5)) {
            PacketHandler.sendToAllAround((IMessage)new PacketFluidLevel(this), (TileEntity)this);
            this.tankDirty = false;
        }
        if (this.active()) {
            if (this.powerUsed >= this.requiredPower) {
                this.teleport(this.toTeleport.poll());
                this.powerUsed = 0;
            } else {
                int usable = Math.min(Math.min(this.getUsage(), this.requiredPower), this.getEnergyStored(null));
                this.setEnergyStored(this.getEnergyStored(null) - usable);
                this.powerUsed += usable;
            }
            if (this.shouldDoWorkThisTick(5)) {
                this.updateQueuedEntities();
            }
        }
        boolean bl = powerChanged = this.lastSyncPowerStored != this.getEnergyStored(null) && this.shouldDoWorkThisTick(5);
        if (powerChanged) {
            this.lastSyncPowerStored = this.getEnergyStored(null);
            PacketHandler.sendToAllAround(new PacketPowerStorage(this), (TileEntity)this);
        }
        if (this.coordsChanged) {
            this.coordsChanged = false;
            PacketHandler.sendToAllAround((IMessage)new PacketSetTarget(this, this.target), (TileEntity)this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateEntityClient() {
        this.updateRotations();
        if (this.activeSound != null) {
            this.activeSound.setPitch(MathHelper.func_76131_a((float)(0.5f + this.spinSpeed / 1.5f), (float)0.5f, (float)2.0f));
        }
        if (this.active()) {
            if (this.activeSound == null) {
                BlockPos p = this.func_174877_v();
                this.activeSound = new MachineSound(ACTIVE_RES, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), 0.3f, 1.0f);
                this.playSound();
            }
            this.updateQueuedEntities();
        } else if (!this.active() && this.activeSound != null && this.activeSound.func_147655_f() <= 0.5f) {
            this.activeSound.endPlaying();
            this.activeSound = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playSound() {
        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.activeSound);
    }

    private void updateQueuedEntities() {
        if (this.field_145850_b.field_72995_K && this.active()) {
            this.getCurrentTarget().getEntityData().func_74776_a(PROGRESS_KEY, this.getProgress());
        }
        ArrayList toRemove = Lists.newArrayList();
        for (Entity e : this.toTeleport) {
            if (this.isEntityInRange(e) && !e.field_70128_L) continue;
            toRemove.add(e);
        }
        for (Entity e : toRemove) {
            this.dequeueTeleport(e, true);
        }
    }

    public void updateRedstoneState() {
        if (!this.inNetwork()) {
            return;
        }
        boolean redstone = this.isPoweredRedstone();
        if (!this.getMasterTile().redstoneActivePrev && redstone) {
            this.teleportAll();
        }
        this.getMasterTile().redstoneActivePrev = redstone;
    }

    public boolean isPainted() {
        return this.sourceBlock != null;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.stopPlayingSound();
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.field_145850_b.field_72995_K) {
            this.stopPlayingSound();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopPlayingSound() {
        if (this.activeSound != null) {
            this.activeSound.endPlaying();
            this.activeSound = null;
        }
    }

    public int getPowerScaled(int scale) {
        return (int)((float)this.getEnergyStored(null) / (float)this.getMaxEnergyStored(null) * (float)scale);
    }

    private int calculateTeleportPower() {
        if (this.field_145850_b.field_73011_w.getDimension() == this.target.getDimension()) {
            int distance = (int)Math.ceil(this.field_174879_c.func_185332_f(this.target.getLocation().func_177958_n(), this.target.getLocation().func_177956_o(), this.target.getLocation().func_177952_p()));
            double base = Math.log(0.005 * (double)distance + 1.0);
            this.requiredPower = (int)(base * (double)Config.telepadPowerCoefficient);
        } else {
            this.requiredPower = Config.telepadPowerInterdimensional;
        }
        int res = MathHelper.func_76125_a((int)this.requiredPower, (int)5000, (int)Config.telepadPowerInterdimensional);
        return res;
    }

    public boolean active() {
        return !this.toTeleport.isEmpty();
    }

    public Entity getCurrentTarget() {
        return this.toTeleport.peek();
    }

    public AxisAlignedBB getBoundingBox() {
        BlockPos p = this.func_174877_v();
        if (!this.inNetwork()) {
            return new AxisAlignedBB(p, p.func_177972_a(EnumFacing.UP).func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.EAST));
        }
        p = this.getMaster().getLocation().getBlockPos();
        return new AxisAlignedBB((double)(p.func_177958_n() - 1), (double)p.func_177956_o(), (double)(p.func_177952_p() - 1), (double)(p.func_177958_n() + 2), (double)(p.func_177956_o() + 1), (double)(p.func_177952_p() + 2));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getBoundingBox();
    }

    public void updateRotations() {
        this.spinSpeed = this.active() ? this.getProgress() * 2.0f : Math.max(0.0f, this.spinSpeed - 0.025f);
        int i = 0;
        while (i < this.bladeRots.length) {
            int n = i;
            this.bladeRots[n] = this.bladeRots[n] + this.spinSpeed * (float)(i * 2 + 20);
            int n2 = i++;
            this.bladeRots[n2] = this.bladeRots[n2] % 360.0f;
        }
    }

    public float getProgress() {
        return (float)this.powerUsed / (float)this.requiredPower;
    }

    protected int getProgressUpdateFreq() {
        return 1;
    }

    public void setProgress(float progress) {
        this.powerUsed = progress < 0.0f ? 0 : (int)((float)this.requiredPower * progress);
    }

    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public int getX() {
        if (this.inNetwork()) {
            return this.getMasterTile().target.getX();
        }
        return this.target.getX();
    }

    @Override
    public int getY() {
        if (this.inNetwork()) {
            return this.getMasterTile().target.getY();
        }
        return this.target.getY();
    }

    @Override
    public int getZ() {
        if (this.inNetwork()) {
            return this.getMasterTile().target.getZ();
        }
        return this.target.getZ();
    }

    @Override
    public int getTargetDim() {
        if (this.inNetwork()) {
            return this.getMasterTile().target.getDimension();
        }
        return this.target.getDimension();
    }

    @Override
    public void setX(int x) {
        if (Config.telepadLockCoords) {
            return;
        }
        this.setTarget(this.getTarget().setX(x));
    }

    @Override
    public void setY(int y) {
        if (Config.telepadLockCoords) {
            return;
        }
        this.setTarget(this.getTarget().setY(y));
    }

    @Override
    public void setZ(int z) {
        if (Config.telepadLockCoords) {
            return;
        }
        this.setTarget(this.getTarget().setZ(z));
    }

    @Override
    public void setTargetDim(int dimID) {
        if (Config.telepadLockCoords) {
            return;
        }
        this.setTarget(this.getTarget().setDimension(dimID));
    }

    @Override
    public void setCoords(BlockPos coords) {
        if (Config.telepadLockCoords) {
            return;
        }
        this.setTarget(this.getTarget().setLocation(coords));
    }

    public void setTarget(TelepadTarget newTarget) {
        if (this.inNetwork() && !this.isMaster()) {
            this.getMaster().setTarget(newTarget);
            return;
        }
        if (newTarget == null) {
            newTarget = new TelepadTarget();
        }
        this.target = new TelepadTarget(newTarget);
        this.coordsChanged = true;
        this.func_70296_d();
    }

    public TelepadTarget getTarget() {
        if (!this.inNetwork() || this.isMaster()) {
            return this.target;
        }
        return this.getMaster().getTarget();
    }

    @Override
    public void teleportSpecific(Entity entity) {
        if (!this.inNetwork()) {
            return;
        }
        if (this.isMaster()) {
            if (this.isEntityInRange(entity)) {
                this.enqueueTeleport(entity, true);
            }
        } else {
            this.getMasterTile().teleportSpecific(entity);
        }
    }

    @Override
    public void teleportAll() {
        TileTelePad m = this.getMasterTile();
        if (m == null) {
            return;
        }
        for (Entity e : m.getEntitiesInRange()) {
            m.enqueueTeleport(e, true);
        }
    }

    private List<Entity> getEntitiesInRange() {
        return this.field_145850_b.func_72872_a(Entity.class, this.getRange());
    }

    private boolean isEntityInRange(Entity entity) {
        return this.getRange().func_72318_a(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
    }

    private AxisAlignedBB getRange() {
        BlockPos p = this.func_174877_v();
        return new AxisAlignedBB((double)(p.func_177958_n() - 1), (double)p.func_177956_o(), (double)(p.func_177952_p() - 1), (double)(p.func_177958_n() + 2), (double)(p.func_177956_o() + 3), (double)(p.func_177952_p() + 2));
    }

    public void enqueueTeleport(Entity entity, boolean sendUpdate) {
        if (entity == null || this.toTeleport.contains(entity)) {
            return;
        }
        this.calculateTeleportPower();
        entity.getEntityData().func_74757_a(TELEPORTING_KEY, true);
        this.toTeleport.add(entity);
        if (sendUpdate) {
            if (entity.field_70170_p.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTeleport(PacketTeleport.Type.BEGIN, this, entity));
            } else {
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTeleport(PacketTeleport.Type.BEGIN, this, entity));
            }
        }
    }

    public void dequeueTeleport(Entity entity, boolean sendUpdate) {
        if (entity == null) {
            return;
        }
        this.toTeleport.remove(entity);
        entity.getEntityData().func_74757_a(TELEPORTING_KEY, false);
        if (sendUpdate) {
            if (this.field_145850_b.field_72995_K) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTeleport(PacketTeleport.Type.END, this, entity));
            } else {
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTeleport(PacketTeleport.Type.END, this, entity));
            }
        }
        if (!this.active()) {
            this.powerUsed = 0;
        }
    }

    private boolean teleport(Entity entity) {
        if (this.requiredPower <= 0) {
            return false;
        }
        if (Config.telepadFluidUse > 0) {
            if (this.tank.getFluidAmount() < Config.telepadFluidUse) {
                this.tank.drain(Config.telepadFluidUse, true);
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED.toString() + EnderIO.lang.localize("chat.telepad.noFluid", new Object[]{new FluidStack(this.fluidType, 1).getLocalizedName()})));
                }
                this.wasBlocked = true;
                return true;
            }
            this.tank.drainInternal(Config.telepadFluidUse, true);
        }
        entity.getEntityData().func_74757_a(TELEPORTING_KEY, false);
        this.wasBlocked = !(!entity.field_70170_p.field_72995_K ? this.serverTeleport(entity) : this.clientTeleport(entity));
        PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTeleport(PacketTeleport.Type.TELEPORT, this, this.wasBlocked));
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_71053_j();
        }
        return !this.wasBlocked;
    }

    private boolean clientTeleport(Entity entity) {
        return TeleportUtil.checkClientTeleport(entity, this.target.getLocation(), this.target.getDimension(), TravelSource.TELEPAD);
    }

    private boolean serverTeleport(Entity entity) {
        this.dequeueTeleport(entity, true);
        return TeleportUtil.serverTeleport(entity, this.target.getLocation(), this.target.getDimension(), false, TravelSource.TELEPAD);
    }

    @Override
    public boolean canSeeBlock(EntityPlayer playerName) {
        return this.isMaster() && this.inNetwork();
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        return this.inNetwork() && this.getMasterTile() != null ? (this.getMasterTile() == this ? this.maxEnergyRecieved.get(this.capacitorData) : this.getMasterTile().getMaxEnergyRecieved(dir)) : 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.inNetwork() && this.getMasterTile() != null ? (this.getMasterTile() == this ? this.maxEnergyStored.get(this.capacitorData) : this.getMasterTile().getMaxEnergyStored(from)) : 0;
    }

    @Override
    public boolean displayPower() {
        return this.inNetwork() && this.getMasterTile() != null;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.inNetwork() && this.getMasterTile() != null ? (this.getMasterTile() == this ? this.storedEnergyRF : this.getMasterTile().getEnergyStored(from)) : 0;
    }

    @Override
    public void setEnergyStored(int storedEnergy) {
        if (this.inNetwork() && this.getMasterTile() != null) {
            if (this.getMasterTile() == this) {
                this.storedEnergyRF = Math.min(this.getMaxEnergyStored(null), storedEnergy);
            } else {
                this.getMasterTile().setEnergyStored(storedEnergy);
            }
        }
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return this.inNetwork() && this.getMasterTile() != null;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (!this.inNetwork()) {
            return 0;
        }
        int max = Math.max(0, Math.min(Math.min(this.getMaxEnergyRecieved(from), maxReceive), this.getMaxEnergyStored(from) - this.getEnergyStored(from)));
        if (!simulate) {
            this.setEnergyStored(this.getEnergyStored(null) + max);
        }
        return max;
    }

    public int getUsage() {
        return this.maxEnergyUsed.get(this.capacitorData);
    }

    private TileTelePad getMasterTile() {
        if (this.masterTile != null) {
            return this.masterTile;
        }
        this.masterTile = this.getMaster();
        return this.masterTile;
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.inNetwork() && (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (!this.inNetwork()) {
            return (T)super.getCapability(capability, facing);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.getMaster();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.getMaster().tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getSlots() {
        return 2;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.inventory.length) {
            return;
        }
        this.inventory[slot] = stack;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot != 0 || this.inventory[0] != null || stack == null || stack.func_77973_b() != ModObject.itemLocationPrintout.getItem()) {
            return stack;
        }
        if (!simulate) {
            this.inventory[0] = stack.func_77946_l();
            this.func_70296_d();
        }
        return null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 1 || amount < 1 || this.inventory[1] == null) {
            return null;
        }
        ItemStack res = this.inventory[1].func_77946_l();
        if (!simulate) {
            this.func_70296_d();
            this.inventory[1] = null;
        }
        return res;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType == null || forFluidType.getFluid() != this.fluidType) {
            return null;
        }
        TileTelePad master = this.getMaster();
        if (master == null) {
            return null;
        }
        return master.tank;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tankDirty = true;
        this.func_70296_d();
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public void setFluidAmount(int level) {
        this.tank.setFluidAmount(level);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public Fluid getFluidType() {
        return this.fluidType;
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        if (this.inNetwork()) {
            return this.getMaster().createDisplayData();
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<ITankAccess.ITankData> createDisplayData() {
        TankData data = new TankData();
        return Collections.singletonList(data);
    }

    private class TankData
    implements ITankAccess.ITankData {
        private TankData() {
        }

        @Nonnull
        public ITankAccess.ITankData.EnumTankType getTankType() {
            return ITankAccess.ITankData.EnumTankType.INPUT;
        }

        public FluidStack getContent() {
            return TileTelePad.this.getTank().getFluid();
        }

        public int getCapacity() {
            return TileTelePad.this.tank.getCapacity();
        }
    }
}

