/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vacuum;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.fluid.FluidWrapper;
import com.google.common.base.Predicate;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.YetaUtil;
import crazypants.enderio.xp.ExperienceContainer;
import crazypants.util.MagnetUtil;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

@Storable
public class TileXPVacuum
extends TileEntityEio
implements Predicate<EntityXPOrb>,
IPaintable.IPaintableTileEntity,
ITankAccess {
    private static final int IO_MB_TICK = 10000;
    private double range = Config.xpVacuumRange;
    @Store
    private boolean formed = false;
    private boolean formedRender = false;
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    private final ExperienceContainer xpCon = new ExperienceContainer(Integer.MAX_VALUE);
    private static final double speed = 0.03;
    @Store(value={Store.StoreFor.CLIENT, Store.StoreFor.SAVE})
    protected IBlockState sourceBlock;

    public TileXPVacuum() {
        this.xpCon.setTileEntity((TileEntity)this);
        this.xpCon.setCanFill(!this.formed);
    }

    @Override
    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            YetaUtil.refresh((TileEntity)this);
            if (this.formed != this.formedRender) {
                this.formedRender = this.formed;
                this.updateBlock();
            }
            if (this.formed) {
                this.doHoover();
            }
        } else {
            if (this.formed) {
                this.doHoover();
                if (this.xpCon.getFluidAmount() > 0) {
                    this.doPush();
                }
            } else if (this.xpCon.getFluidAmount() > 0) {
                this.formed = true;
                this.func_70296_d();
                this.updateBlock();
            }
            this.xpCon.setCanFill(!this.formed);
        }
    }

    public boolean apply(@Nullable EntityXPOrb entity) {
        return MagnetUtil.shouldAttract(this.func_174877_v(), (Entity)entity);
    }

    private void doHoover() {
        boolean pickUpThisTick = this.xpCon.getFluidAmount() == 0;
        for (EntityXPOrb entity : this.field_145850_b.func_175647_a(EntityXPOrb.class, (AxisAlignedBB)this.getBounds(), (Predicate)this)) {
            double z;
            double y;
            double x = (double)this.field_174879_c.func_177958_n() + 0.5 - entity.field_70165_t;
            double distance = Math.sqrt(x * x + (y = (double)this.field_174879_c.func_177956_o() + 0.5 - entity.field_70163_u) * y + (z = (double)this.field_174879_c.func_177952_p() + 0.5 - entity.field_70161_v) * z);
            if (distance < 1.25) {
                if (!pickUpThisTick) continue;
                this.hooverEntity(entity);
                continue;
            }
            double distScale = Math.min(1.0, Math.max(0.25, 1.0 - distance / this.range));
            distScale *= distScale;
            entity.field_70159_w += x / distance * distScale * 0.03;
            entity.field_70181_x = entity.field_70163_u < (double)this.field_174879_c.func_177956_o() ? (entity.field_70181_x += y / distance * distScale * 0.03 + 0.03) : (entity.field_70181_x += y / distance * distScale * 0.03);
            entity.field_70179_y += z / distance * distScale * 0.03;
        }
    }

    private void hooverEntity(EntityXPOrb entity) {
        if (!this.field_145850_b.field_72995_K && !entity.field_70128_L) {
            int xpValue = entity.func_70526_d();
            this.xpCon.addExperience(xpValue);
            entity.func_70106_y();
        }
    }

    private int limitRange(int rangeIn) {
        return Math.max(0, Math.min(Config.vacuumChestRange, rangeIn));
    }

    public void setRange(int range) {
        this.range = this.limitRange(range);
        this.updateBlock();
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    @Override
    public IBlockState getPaintSource() {
        return this.sourceBlock;
    }

    @Override
    public void setPaintSource(@Nullable IBlockState sourceBlock) {
        this.sourceBlock = sourceBlock;
        this.func_70296_d();
        this.updateBlock();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public BoundingBox getBounds() {
        return new BoundingBox(this.func_174877_v()).expand(this.getRange());
    }

    public double getRange() {
        return this.range;
    }

    private void doPush() {
        for (EnumFacing dir : EnumFacing.values()) {
            if (this.xpCon.getFluidAmount() <= 0 || FluidWrapper.transfer((FluidTank)this.xpCon, (IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (int)10000) <= 0) continue;
            this.setTanksDirty();
        }
    }

    public boolean isFormed() {
        return this.formedRender;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (!this.formed && forFluidType != null && forFluidType.getFluid() == Fluids.fluidXpJuice) {
            return this.xpCon;
        }
        return null;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.xpCon};
    }

    public void setTanksDirty() {
        this.func_70296_d();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facingIn);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.xpCon);
        }
        return (T)super.getCapability(capability, facingIn);
    }
}

