/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import com.enderio.core.common.util.ItemUtil;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.painter.recipe.AbstractPainterTemplate;
import crazypants.enderio.paint.IPaintable;
import info.loenwind.autosave.annotations.Storable;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

@Storable
public class TileEntityPainter
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity {
    public TileEntityPainter() {
        super(new SlotDefinition(2, 1), CapacitorKey.PAINTER_POWER_INTAKE, CapacitorKey.PAINTER_POWER_BUFFER, CapacitorKey.PAINTER_POWER_USE);
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        return "Auto Painter";
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, ItemStack itemStack) {
        if (i > 1) {
            return false;
        }
        ItemStack paint = i == 0 ? this.inventory[1] : itemStack;
        ItemStack targt = i == 0 ? itemStack : this.inventory[0];
        Map<String, IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForMachine(this.getMachineName());
        for (IMachineRecipe rec : recipes.values()) {
            AbstractPainterTemplate temp;
            if (!(rec instanceof AbstractPainterTemplate) || !(temp = (AbstractPainterTemplate)rec).isPartialRecipe(paint, targt)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockPainter.getUnlocalisedName();
    }

    @Override
    protected int getNumCanMerge(ItemStack itemStack, ItemStack result) {
        if (!ItemUtil.areStackMergable((ItemStack)itemStack, (ItemStack)result)) {
            return 0;
        }
        return Math.min(itemStack.func_77976_d() - itemStack.field_77994_a, result.field_77994_a);
    }
}

