/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.alloy;

import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.alloy.VanillaSmeltingRecipe;
import crazypants.enderio.machine.recipe.CustomTagHandler;
import crazypants.enderio.machine.recipe.ManyToOneMachineRecipe;
import crazypants.enderio.machine.recipe.ManyToOneRecipeManager;
import crazypants.enderio.machine.recipe.RecipeConfigParser;
import crazypants.enderio.machine.recipe.RecipeInput;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AlloyRecipeManager
extends ManyToOneRecipeManager {
    private static final String CORE_FILE_NAME = "AlloySmelterRecipes_Core.xml";
    private static final String CUSTOM_FILE_NAME = "AlloySmelterRecipes_User.xml";
    static final AlloyRecipeManager instance = new AlloyRecipeManager();
    VanillaSmeltingRecipe vanillaRecipe = new VanillaSmeltingRecipe();
    private static final String ELEMENT_ROOT = "vanillaFurnaceRecipes";
    private static final String ELEMENT_EXCLUDE = "exclude";

    public static AlloyRecipeManager getInstance() {
        return instance;
    }

    public AlloyRecipeManager() {
        super(CORE_FILE_NAME, CUSTOM_FILE_NAME, "Alloy Smelter");
    }

    public VanillaSmeltingRecipe getVanillaRecipe() {
        return this.vanillaRecipe;
    }

    public void setVanillaRecipe(VanillaSmeltingRecipe vanillaRecipe) {
        this.vanillaRecipe = vanillaRecipe;
    }

    @Override
    protected CustomTagHandler createCustomTagHandler() {
        return new VanillaFurnaceTagHandler();
    }

    @Override
    public void loadRecipesFromConfig() {
        super.loadRecipesFromConfig();
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockAlloySmelter.getUnlocalisedName(), new ManyToOneMachineRecipe("AlloySmelterRecipe", ModObject.blockAlloySmelter.getUnlocalisedName(), this));
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockAlloySmelter.getUnlocalisedName(), this.vanillaRecipe);
    }

    private class VanillaFurnaceTagHandler
    implements CustomTagHandler {
        private boolean inTag = false;
        private boolean inExcludes = false;
        private Boolean enabled = null;
        private List<RecipeInput> excludes = new ArrayList<RecipeInput>();

        private VanillaFurnaceTagHandler() {
        }

        @Override
        public boolean startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (AlloyRecipeManager.ELEMENT_ROOT.equals(localName)) {
                this.inTag = true;
                if (RecipeConfigParser.hasAttribute("enabled", attributes)) {
                    boolean defVal = true;
                    if (this.enabled != null) {
                        defVal = this.enabled;
                    }
                    this.enabled = RecipeConfigParser.getBooleanValue("enabled", attributes, defVal);
                }
            } else if (AlloyRecipeManager.ELEMENT_EXCLUDE.equals(localName)) {
                this.inExcludes = true;
            } else if (this.inExcludes && "itemStack".equals(localName)) {
                RecipeInput ri = RecipeConfigParser.getItemStack(attributes);
                this.excludes.add(ri);
            }
            return this.inTag;
        }

        @Override
        public boolean endElement(String uri, String localName, String qName) throws SAXException {
            if (AlloyRecipeManager.ELEMENT_ROOT.equals(localName)) {
                this.inTag = false;
            } else if (AlloyRecipeManager.ELEMENT_EXCLUDE.equals(localName)) {
                this.inExcludes = false;
            }
            return this.inTag;
        }

        @Override
        public void configProcessed() {
            if (this.enabled != null) {
                Log.info("AlloyRecipeManager: Vannila smelting in AlloySmelting enabled=" + this.enabled);
                AlloyRecipeManager.this.vanillaRecipe.setEnabled(this.enabled);
            }
            for (RecipeInput ri : this.excludes) {
                Log.info("Excluding furnace recipe from Alloy Smelter: " + ri);
                AlloyRecipeManager.this.vanillaRecipe.addExclude(ri);
            }
        }
    }
}

