/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.config.recipes.xml;

import crazypants.enderio.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.config.recipes.StaxFactory;
import crazypants.enderio.config.recipes.xml.AbstractConditional;
import crazypants.enderio.config.recipes.xml.Item;
import javax.xml.stream.XMLStreamException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class Output
extends AbstractConditional {
    private int amount;
    private String nbt;
    private Item item;
    private transient NBTTagCompound tag;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        super.readResolve();
        if (this.item == null) {
            throw new InvalidRecipeConfigException("Missing name in <output>");
        }
        if (this.item.isValid()) {
            if (this.amount < 0) {
                throw new InvalidRecipeConfigException("Invalid negative amount in <output>");
            }
            if (this.amount > this.item.getItemStack().func_77976_d()) {
                throw new InvalidRecipeConfigException("Invalid amount in <output>, bigger than maximum stack size");
            }
            if (this.amount == 0) {
                this.amount = 1;
            }
        }
        if (this.nbt != null) {
            if (this.nbt.trim().isEmpty()) {
                this.tag = null;
            } else {
                try {
                    this.tag = JsonToNBT.func_180713_a((String)this.nbt);
                }
                catch (NBTException e) {
                    throw new InvalidRecipeConfigException(this.nbt + " is not valid NBT json.");
                }
            }
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        this.item.enforceValidity();
    }

    @Override
    public boolean isValid() {
        return this.item != null && this.item.isValid();
    }

    public ItemStack getItemStack() {
        ItemStack itemStack = this.item.getItemStack().func_77946_l();
        itemStack.field_77994_a = this.amount;
        if (this.tag != null) {
            itemStack.func_77982_d(this.tag);
        }
        return itemStack;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("amount".equals(name)) {
            this.amount = Integer.valueOf(value);
            return true;
        }
        if ("nbt".equals(name)) {
            this.nbt = value;
            return true;
        }
        if ("name".equals(name)) {
            this.item = new Item();
            this.item.setName(value);
            this.item.readResolve();
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public void register() {
    }
}

