/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.fluid.IFluidWrapper;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitComponent;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.liquid.AbstractTankConduit;
import crazypants.enderio.conduit.liquid.AbstractTankConduitNetwork;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.liquid.LiquidConduitNetwork;
import crazypants.enderio.conduit.liquid.PacketFluidLevel;
import crazypants.enderio.config.Config;
import crazypants.enderio.network.PacketHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LiquidConduit
extends AbstractTankConduit
implements IConduitComponent {
    static final int VOLUME_PER_CONNECTION = 250;
    public static final String ICON_KEY = "enderio:blocks/liquidConduit";
    public static final String ICON_KEY_LOCKED = "enderio:blocks/liquidConduitLocked";
    public static final String ICON_CORE_KEY = "enderio:blocks/liquidConduitCore";
    public static final String ICON_EXTRACT_KEY = "enderio:blocks/liquidConduitExtract";
    public static final String ICON_EMPTY_EXTRACT_KEY = "enderio:blocks/emptyLiquidConduitExtract";
    public static final String ICON_INSERT_KEY = "enderio:blocks/liquidConduitInsert";
    public static final String ICON_EMPTY_INSERT_KEY = "enderio:blocks/emptyLiquidConduitInsert";
    static final Map<String, TextureAtlasSprite> ICONS = new HashMap<String, TextureAtlasSprite>();
    private LiquidConduitNetwork network;
    private float lastSyncRatio = -99.0f;
    private int currentPushToken;
    public static final int MAX_EXTRACT_PER_TICK = Config.fluidConduitExtractRate;
    public static final int MAX_IO_PER_TICK = Config.fluidConduitMaxIoRate;
    private EnumFacing startPushDir = EnumFacing.DOWN;
    private final Set<BlockCoord> filledFromThisTick = new HashSet<BlockCoord>();
    private long ticksSinceFailedExtract = 0L;

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(TextureMap register) {
                ICONS.put(LiquidConduit.ICON_KEY, register.func_174942_a(new ResourceLocation(LiquidConduit.ICON_KEY)));
                ICONS.put(LiquidConduit.ICON_CORE_KEY, register.func_174942_a(new ResourceLocation(LiquidConduit.ICON_CORE_KEY)));
                ICONS.put(LiquidConduit.ICON_EXTRACT_KEY, register.func_174942_a(new ResourceLocation(LiquidConduit.ICON_EXTRACT_KEY)));
                ICONS.put(LiquidConduit.ICON_EMPTY_EXTRACT_KEY, register.func_174942_a(new ResourceLocation(LiquidConduit.ICON_EMPTY_EXTRACT_KEY)));
                ICONS.put(LiquidConduit.ICON_EMPTY_INSERT_KEY, register.func_174942_a(new ResourceLocation(LiquidConduit.ICON_EMPTY_INSERT_KEY)));
                ICONS.put(LiquidConduit.ICON_INSERT_KEY, register.func_174942_a(new ResourceLocation(LiquidConduit.ICON_INSERT_KEY)));
                ICONS.put(LiquidConduit.ICON_KEY_LOCKED, register.func_174942_a(new ResourceLocation(LiquidConduit.ICON_KEY_LOCKED)));
            }
        });
    }

    @Override
    public void updateEntity(World world) {
        super.updateEntity(world);
        if (world.field_72995_K) {
            return;
        }
        this.filledFromThisTick.clear();
        this.updateStartPushDir();
        this.doExtract();
        if (this.stateDirty) {
            this.getBundle().dirty();
            this.stateDirty = false;
            this.lastSyncRatio = this.tank.getFilledRatio();
        } else if (this.lastSyncRatio != this.tank.getFilledRatio() && world.func_82737_E() % 2L == 0L) {
            BlockCoord loc = this.getLocation();
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFluidLevel(this), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)loc.x, (double)loc.y, (double)loc.z, 64.0));
            this.lastSyncRatio = this.tank.getFilledRatio();
        }
    }

    private void doExtract() {
        if (!this.hasExtractableMode()) {
            return;
        }
        ++this.ticksSinceFailedExtract;
        if (this.ticksSinceFailedExtract > 9L && this.ticksSinceFailedExtract % 10L != 0L) {
            return;
        }
        for (EnumFacing dir : this.externalConnections) {
            int used;
            FluidStack couldDrain;
            IFluidWrapper extTank;
            if (!this.autoExtractForDir(dir) || (extTank = this.getExternalHandler(dir)) == null || (couldDrain = extTank.getAvailableFluid()) == null || couldDrain.amount <= 0 || !this.canFill(dir, couldDrain.getFluid())) continue;
            couldDrain = couldDrain.copy();
            if (couldDrain.amount > MAX_EXTRACT_PER_TICK) {
                couldDrain.amount = MAX_EXTRACT_PER_TICK;
            }
            if ((used = this.pushLiquid(dir, couldDrain, true, this.network == null ? -1 : this.network.getNextPushToken())) <= 0) continue;
            couldDrain.amount = used;
            extTank.drain(couldDrain);
            if (this.network != null && this.network.getFluidType() == null) {
                this.network.setFluidType(couldDrain);
            }
            this.ticksSinceFailedExtract = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (this.network == null || resource == null) {
            return 0;
        }
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        if (this.filledFromThisTick.contains(this.getLocation().getLocation(from))) {
            return 0;
        }
        if (this.network.lockNetworkForFill()) {
            if (doFill) {
                this.filledFromThisTick.add(this.getLocation().getLocation(from));
            }
            try {
                int res = this.fill(from, resource, doFill, true, this.network == null ? -1 : this.network.getNextPushToken());
                if (doFill && this.externalConnections.contains(from) && this.network != null) {
                    this.network.addedFromExternal(res);
                }
                int n = res;
                return n;
            }
            finally {
                this.network.unlockNetworkFromFill();
            }
        }
        return 0;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill, boolean doPush, int pushToken) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        if (this.network == null) {
            return 0;
        }
        if (!this.network.canAcceptLiquid(resource)) {
            return 0;
        }
        this.network.setFluidType(resource);
        resource = resource.copy();
        resource.amount = Math.min(MAX_IO_PER_TICK, resource.amount);
        if (doPush) {
            return this.pushLiquid(from, resource, doFill, pushToken);
        }
        return this.tank.fill(resource, doFill);
    }

    private void updateStartPushDir() {
        EnumFacing newVal = this.getNextDir(this.startPushDir);
        boolean foundNewStart = false;
        while (newVal != this.startPushDir && !foundNewStart) {
            foundNewStart = this.getConduitConnections().contains(newVal) || this.getExternalConnections().contains(newVal);
            newVal = this.getNextDir(newVal);
        }
        this.startPushDir = newVal;
    }

    private EnumFacing getNextDir(EnumFacing dir) {
        if (dir.ordinal() >= EnumFacing.field_82609_l.length - 1) {
            return EnumFacing.field_82609_l[0];
        }
        return EnumFacing.field_82609_l[dir.ordinal() + 1];
    }

    private int pushLiquid(EnumFacing from, FluidStack pushStack, boolean doPush, int token) {
        if (token == this.currentPushToken || pushStack == null || pushStack.amount <= 0 || this.network == null) {
            return 0;
        }
        this.currentPushToken = token;
        int pushed = 0;
        int total = pushStack.amount;
        EnumFacing dir = this.startPushDir;
        FluidStack toPush = pushStack.copy();
        int filledLocal = this.tank.fill(toPush, doPush);
        toPush.amount -= filledLocal;
        pushed += filledLocal;
        do {
            IFluidWrapper con;
            if (dir == from || !this.canOutputToDir(dir) || this.autoExtractForDir(dir)) continue;
            if (this.getConduitConnections().contains(dir)) {
                ILiquidConduit conduitCon = this.getFluidConduit(dir);
                if (conduitCon == null) continue;
                int toCon = ((LiquidConduit)conduitCon).pushLiquid(dir.func_176734_d(), toPush, doPush, token);
                toPush.amount -= toCon;
                pushed += toCon;
                continue;
            }
            if (!this.getExternalConnections().contains(dir) || (con = this.getExternalHandler(dir)) == null) continue;
            int toExt = doPush ? con.fill(toPush) : con.offer(toPush);
            toPush.amount -= toExt;
            pushed += toExt;
            if (!doPush) continue;
            this.network.outputedToExternal(toExt);
        } while ((dir = this.getNextDir(dir)) != this.startPushDir && pushed < total);
        return pushed;
    }

    private ILiquidConduit getFluidConduit(EnumFacing dir) {
        TileEntity ent = this.getBundle().getEntity();
        return ConduitUtil.getConduit(ent.func_145831_w(), ent, dir, ILiquidConduit.class);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.getConnectionMode(from) == ConnectionMode.INPUT || this.getConnectionMode(from) == ConnectionMode.DISABLED) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (this.getConnectionMode(from) == ConnectionMode.OUTPUT || this.getConnectionMode(from) == ConnectionMode.DISABLED) {
            return false;
        }
        if (this.tank.getFluid() == null) {
            return true;
        }
        return fluid != null && FluidUtil.areFluidsTheSame((Fluid)fluid, (Fluid)this.tank.getFluid().getFluid());
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (this.getConnectionMode(from) == ConnectionMode.INPUT || this.getConnectionMode(from) == ConnectionMode.DISABLED || this.tank.getFluid() == null || fluid == null) {
            return false;
        }
        return FluidUtil.areFluidsTheSame((Fluid)this.tank.getFluid().getFluid(), (Fluid)fluid);
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public void connectionsChanged() {
        super.connectionsChanged();
        this.updateTank();
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack(ModObject.itemLiquidConduit.getItem(), 1, 0);
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        if (network == null) {
            this.network = null;
            return true;
        }
        if (!(network instanceof AbstractTankConduitNetwork)) {
            return false;
        }
        AbstractTankConduitNetwork n = (AbstractTankConduitNetwork)network;
        if (this.tank.getFluid() == null) {
            this.tank.setLiquid(n.getFluidType() == null ? null : n.getFluidType().copy());
        } else if (n.getFluidType() == null) {
            n.setFluidType(this.tank.getFluid());
        } else if (!this.tank.getFluid().isFluidEqual(n.getFluidType())) {
            return false;
        }
        this.network = (LiquidConduitNetwork)network;
        return true;
    }

    @Override
    public boolean canConnectToConduit(EnumFacing direction, IConduit con) {
        if (!super.canConnectToConduit(direction, con)) {
            return false;
        }
        if (!(con instanceof LiquidConduit)) {
            return false;
        }
        if (this.getFluidType() != null && ((LiquidConduit)con).getFluidType() == null) {
            return false;
        }
        return LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), ((LiquidConduit)con).getFluidType());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForState(CollidableComponent component) {
        if (component.dir == null) {
            return ICONS.get(ICON_CORE_KEY);
        }
        if (this.getConnectionMode(component.dir) == ConnectionMode.INPUT) {
            return ICONS.get(this.getFluidType() == null ? ICON_EMPTY_EXTRACT_KEY : ICON_EXTRACT_KEY);
        }
        if (this.getConnectionMode(component.dir) == ConnectionMode.OUTPUT) {
            return ICONS.get(this.getFluidType() == null ? ICON_EMPTY_INSERT_KEY : ICON_INSERT_KEY);
        }
        return this.fluidTypeLocked ? ICONS.get(ICON_KEY_LOCKED) : ICONS.get(ICON_KEY);
    }

    @Override
    public TextureAtlasSprite getTransmitionTextureForState(CollidableComponent component) {
        if (this.tank.getFluid() != null && this.tank.getFluid().getFluid() != null) {
            return RenderUtil.getStillTexture((FluidStack)this.tank.getFluid());
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector4f getTransmitionTextureColorForState(CollidableComponent component) {
        if (this.tank.getFluid() != null && this.tank.getFluid().getFluid() != null) {
            int color = this.tank.getFluid().getFluid().getColor(this.tank.getFluid());
            return new Vector4f((double)(color >> 16 & 0xFF) / 255.0, (double)(color >> 8 & 0xFF) / 255.0, (double)(color & 0xFF) / 255.0, 1.0);
        }
        return null;
    }

    @Override
    public float getTransmitionGeometryScale() {
        return this.tank.getFilledRatio();
    }

    @Override
    protected void updateTank() {
        int totalConnections = this.getConduitConnections().size() + this.getExternalConnections().size();
        this.tank.setCapacity(totalConnections * 250);
    }

    @Override
    protected boolean canJoinNeighbour(ILiquidConduit n) {
        return n instanceof LiquidConduit;
    }

    @Override
    public AbstractTankConduitNetwork<? extends AbstractTankConduit> getTankNetwork() {
        return this.network;
    }

    public LiquidConduitNetwork createNetworkForType() {
        return new LiquidConduitNetwork();
    }
}

