/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capability;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import crazypants.enderio.ModObject;
import crazypants.enderio.capability.Callback;
import crazypants.enderio.capacitor.CapacitorHelper;
import crazypants.enderio.machine.sagmill.SagMillRecipeManager;
import crazypants.enderio.paint.IPaintable;
import crazypants.util.CapturedMob;
import crazypants.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Filters {
    @Nonnull
    public static final Callback<ItemStack> NO_CALLBACK = new Callback<ItemStack>(){

        @Override
        public final void onChange(@Nullable ItemStack oldStack, @Nullable ItemStack newStack) {
        }
    };
    @Nonnull
    public static final Predicate<ItemStack> ALWAYS_TRUE = Predicates.alwaysTrue();
    @Nonnull
    public static final Predicate<ItemStack> ALWAYS_FALSE = Predicates.alwaysFalse();
    @Nonnull
    public static final Predicate<ItemStack> ONLY_STACKABLE = new PredicateItemStack(){

        @Override
        public boolean doApply(@Nonnull ItemStack input) {
            return input.func_77985_e();
        }
    };
    @Nonnull
    public static final Predicate<ItemStack> PAINTABLE = new PredicateItemStack(){

        @Override
        public boolean doApply(@Nonnull ItemStack input) {
            return Block.func_149634_a((Item)input.func_77973_b()) instanceof IPaintable;
        }
    };
    @Nonnull
    public static final Predicate<ItemStack> SOUL_VIALS = new PredicateItemStack(){

        @Override
        public boolean doApply(@Nonnull ItemStack input) {
            return input.func_77973_b() == ModObject.itemSoulVessel.getItem();
        }
    };
    @Nonnull
    public static final Predicate<ItemStack> WITH_MOB_SOUL = new PredicateItemStack(){

        @Override
        public boolean doApply(@Nonnull ItemStack input) {
            return CapturedMob.containsSoul(input);
        }
    };
    @Nonnull
    public static final Predicate<ItemStack> FILLED_SOUL_VIALS = Filters.and(SOUL_VIALS, WITH_MOB_SOUL);
    @Nonnull
    public static final Predicate<ItemStack> EMPTY_SOUL_VIALS = Filters.and(SOUL_VIALS, Filters.not(WITH_MOB_SOUL));
    @Nonnull
    public static final Predicate<ItemStack> GRINDING_BALLS = new PredicateItemStack(){

        @Override
        public boolean doApply(@Nonnull ItemStack input) {
            return SagMillRecipeManager.getInstance().isValidSagBall(input);
        }
    };
    @Nonnull
    public static final Predicate<ItemStack> CAPACITORS = new PredicateItemStack(){

        @Override
        public boolean doApply(@Nonnull ItemStack input) {
            return input.func_77973_b() == ModObject.itemBasicCapacitor.getItem() && input.func_77952_i() > 0 || CapacitorHelper.getCapacitorDataFromItemStack(input) != null;
        }
    };

    @Nonnull
    public static Predicate<ItemStack> and(final @Nonnull Predicate<ItemStack> a, final @Nonnull Predicate<ItemStack> b) {
        return new PredicateItemStack(){

            @Override
            public boolean doApply(@Nonnull ItemStack input) {
                return a.apply((Object)input) && b.apply((Object)input);
            }
        };
    }

    @Nonnull
    public static Predicate<ItemStack> or(final @Nonnull Predicate<ItemStack> a, final @Nonnull Predicate<ItemStack> b) {
        return new PredicateItemStack(){

            @Override
            public boolean doApply(@Nonnull ItemStack input) {
                return a.apply((Object)input) || b.apply((Object)input);
            }
        };
    }

    @Nonnull
    public static Predicate<ItemStack> not(final @Nonnull Predicate<ItemStack> a) {
        return new PredicateItemStack(){

            @Override
            public boolean doApply(@Nonnull ItemStack input) {
                return !a.apply((Object)input);
            }
        };
    }

    private Filters() {
    }

    public static abstract class PredicateItemStack
    implements Predicate<ItemStack> {
        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj);
        }

        public boolean apply(@Nullable ItemStack input) {
            return Prep.isValid(input) && this.doApply(input);
        }

        public abstract boolean doApply(@Nonnull ItemStack var1);
    }
}

