/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vertex;
import java.util.Collection;
import java.util.Iterator;

public class VertexTransformComposite
implements VertexTransform {
    public final VertexTransform[] xforms;

    public VertexTransformComposite(VertexTransform ... xforms) {
        this.xforms = xforms;
    }

    VertexTransformComposite(Collection<VertexTransform> xformsIn) {
        this.xforms = new VertexTransform[xformsIn.size()];
        int i = 0;
        Iterator<VertexTransform> i$ = xformsIn.iterator();
        while (i$.hasNext()) {
            VertexTransform xform;
            this.xforms[i] = xform = i$.next();
            ++i;
        }
    }

    @Override
    public void apply(Vertex vertex) {
        for (VertexTransform xform : this.xforms) {
            xform.apply(vertex);
        }
    }

    @Override
    public void apply(Vector3d vec) {
        for (VertexTransform xform : this.xforms) {
            xform.apply(vec);
        }
    }

    @Override
    public void applyToNormal(Vector3f vec) {
        for (VertexTransform xform : this.xforms) {
            xform.applyToNormal(vec);
        }
    }
}

