/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.soul.IDemonWillConduit;
import WayofTime.bloodmagic.api.soul.IDemonWillGem;
import WayofTime.bloodmagic.api.soul.IDiscreteDemonWill;
import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.tile.TileInventory;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileDemonCrucible
extends TileInventory
implements ITickable,
IDemonWillConduit,
ISidedInventory {
    public HashMap<EnumDemonWillType, Double> willMap = new HashMap();
    public final int maxWill = 100;
    public final double gemDrainRate = 10.0;
    public int internalCounter = 0;

    public TileDemonCrucible() {
        super(1, "demonCrucible");
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ++this.internalCounter;
        if (this.func_145831_w().func_175640_z(this.func_174877_v())) {
            ItemStack stack = this.func_70301_a(0);
            if (stack != null && stack.func_77973_b() instanceof IDemonWillGem) {
                IDemonWillGem gemItem = (IDemonWillGem)stack.func_77973_b();
                for (EnumDemonWillType type : EnumDemonWillType.values()) {
                    double current;
                    double fillAmount;
                    if (!this.willMap.containsKey((Object)type) || !((fillAmount = Math.min(10.0, current = this.willMap.get((Object)type).doubleValue())) > 0.0)) continue;
                    fillAmount = gemItem.fillWill(type, stack, fillAmount, true);
                    if (this.willMap.get((Object)type) - fillAmount <= 0.0) {
                        this.willMap.remove((Object)type);
                        continue;
                    }
                    this.willMap.put(type, this.willMap.get((Object)type) - fillAmount);
                }
            }
        } else {
            ItemStack stack = this.func_70301_a(0);
            if (stack != null) {
                if (stack.func_77973_b() instanceof IDemonWillGem) {
                    IDemonWillGem gemItem = (IDemonWillGem)stack.func_77973_b();
                    for (EnumDemonWillType type : EnumDemonWillType.values()) {
                        double currentAmount = WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, type);
                        double drainAmount = Math.min(100.0 - currentAmount, 10.0);
                        double filled = WorldDemonWillHandler.fillWillToMaximum(this.func_145831_w(), this.field_174879_c, type, drainAmount, 100.0, false);
                        if (!((filled = gemItem.drainWill(type, stack, filled, false)) > 0.0)) continue;
                        filled = gemItem.drainWill(type, stack, filled, true);
                        WorldDemonWillHandler.fillWillToMaximum(this.func_145831_w(), this.field_174879_c, type, filled, 100.0, true);
                    }
                } else if (stack.func_77973_b() instanceof IDiscreteDemonWill) {
                    double filled;
                    double discreteAmount;
                    IDiscreteDemonWill willItem = (IDiscreteDemonWill)stack.func_77973_b();
                    EnumDemonWillType type = willItem.getType(stack);
                    double currentAmount = WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, type);
                    double needed = 100.0 - currentAmount;
                    if (needed >= (discreteAmount = willItem.getDiscretization(stack)) && (filled = willItem.drainWill(stack, discreteAmount)) > 0.0) {
                        WorldDemonWillHandler.fillWillToMaximum(this.func_145831_w(), this.field_174879_c, type, filled, 100.0, true);
                        if (stack.field_77994_a <= 0) {
                            this.func_70299_a(0, null);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        super.deserialize(tag);
        this.willMap.clear();
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            double amount = tag.func_74769_h("EnumWill" + type.func_176610_l());
            if (!(amount > 0.0)) continue;
            this.willMap.put(type, amount);
        }
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        super.serialize(tag);
        for (Map.Entry<EnumDemonWillType, Double> entry : this.willMap.entrySet()) {
            tag.func_74780_a("EnumWill" + entry.getKey().func_176610_l(), entry.getValue().doubleValue());
        }
        return tag;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public double fillDemonWill(EnumDemonWillType type, double amount, boolean doFill) {
        if (amount <= 0.0) {
            return 0.0;
        }
        if (!this.canFill(type)) {
            return 0.0;
        }
        if (!doFill) {
            if (!this.willMap.containsKey((Object)type)) {
                return Math.min(100.0, amount);
            }
            return Math.min(100.0 - this.willMap.get((Object)type), amount);
        }
        if (!this.willMap.containsKey((Object)type)) {
            double max = Math.min(100.0, amount);
            this.willMap.put(type, max);
            return max;
        }
        double current = this.willMap.get((Object)type);
        double filled = 100.0 - current;
        if (amount < filled) {
            this.willMap.put(type, current + amount);
            filled = amount;
        } else {
            this.willMap.put(type, 100.0);
        }
        return filled;
    }

    @Override
    public double drainDemonWill(EnumDemonWillType type, double amount, boolean doDrain) {
        if (!this.willMap.containsKey((Object)type)) {
            return 0.0;
        }
        double drained = amount;
        double current = this.willMap.get((Object)type);
        if (current < drained) {
            drained = current;
        }
        if (doDrain) {
            if ((current -= drained) <= 0.0) {
                this.willMap.remove((Object)type);
            } else {
                this.willMap.put(type, current);
            }
        }
        return drained;
    }

    @Override
    public boolean canFill(EnumDemonWillType type) {
        return true;
    }

    @Override
    public boolean canDrain(EnumDemonWillType type) {
        return true;
    }

    @Override
    public double getCurrentWill(EnumDemonWillType type) {
        return this.willMap.containsKey((Object)type) ? this.willMap.get((Object)type) : 0.0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return stack != null ? stack.func_77973_b() instanceof IDemonWillGem || stack.func_77973_b() instanceof IDiscreteDemonWill : false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }
}

