/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item.armour;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.iface.IMultiWillTool;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.soul.PlayerDemonWillHandler;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.client.IMeshProvider;
import WayofTime.bloodmagic.registry.ModItems;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSentientArmour
extends ItemArmor
implements ISpecialArmor,
IMeshProvider,
IMultiWillTool {
    public static String[] names = new String[]{"helmet", "chest", "legs", "boots"};
    public static double[] willBracket = new double[]{30.0, 200.0, 600.0, 1500.0, 4000.0, 6000.0, 8000.0, 16000.0};
    public static double[] consumptionPerHit = new double[]{0.1, 0.12, 0.15, 0.2, 0.3, 0.35, 0.4, 0.5};
    public static double[] extraProtectionLevel = new double[]{0.0, 0.25, 0.5, 0.6, 0.7, 0.75, 0.85, 0.9};
    public static double[] steadfastProtectionLevel = new double[]{0.25, 0.5, 0.6, 0.7, 0.75, 0.85, 0.9, 0.95};
    public static double[] knockbackBonus = new double[]{0.2, 0.4, 0.6, 0.8, 1.0, 1.0, 1.0, 1.0};
    public static double[] damageBoost = new double[]{0.03, 0.06, 0.09, 0.12, 0.15, 0.18, 0.22, 0.25};
    public static double[] attackSpeed = new double[]{-0.02, -0.04, -0.06, -0.08, -0.1, -0.12, -0.14, -0.16};
    public static double[] speedBonus = new double[]{0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4};

    public ItemSentientArmour(EntityEquipmentSlot armorType) {
        super(ItemArmor.ArmorMaterial.IRON, 0, armorType);
        this.func_77655_b("BloodMagic.sentientArmour.");
        this.func_77656_e(250);
        this.func_77637_a(BloodMagic.tabBloodMagic);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (this == ModItems.SENTIENT_ARMOUR_CHEST || this == ModItems.SENTIENT_ARMOUR_HELMET || this == ModItems.SENTIENT_ARMOUR_BOOTS) {
            switch (this.getCurrentType(stack)) {
                case DEFAULT: {
                    return "bloodmagic:models/armor/sentientArmour_layer_1.png";
                }
                case CORROSIVE: {
                    return "bloodmagic:models/armor/sentientArmour_corrosive_layer_1.png";
                }
                case VENGEFUL: {
                    return "bloodmagic:models/armor/sentientArmour_vengeful_layer_1.png";
                }
                case DESTRUCTIVE: {
                    return "bloodmagic:models/armor/sentientArmour_destructive_layer_1.png";
                }
                case STEADFAST: {
                    return "bloodmagic:models/armor/sentientArmour_steadfast_layer_1.png";
                }
            }
            return "bloodmagic:models/armor/sentientArmour_layer_1.png";
        }
        if (this == ModItems.SENTIENT_ARMOUR_LEGS) {
            switch (this.getCurrentType(stack)) {
                case DEFAULT: {
                    return "bloodmagic:models/armor/sentientArmour_layer_2.png";
                }
                case CORROSIVE: {
                    return "bloodmagic:models/armor/sentientArmour_corrosive_layer_2.png";
                }
                case VENGEFUL: {
                    return "bloodmagic:models/armor/sentientArmour_vengeful_layer_2.png";
                }
                case DESTRUCTIVE: {
                    return "bloodmagic:models/armor/sentientArmour_destructive_layer_2.png";
                }
                case STEADFAST: {
                    return "bloodmagic:models/armor/sentientArmour_steadfast_layer_2.png";
                }
            }
            return "bloodmagic:models/armor/sentientArmour_layer_1.png";
        }
        return null;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (this.field_77881_a == EntityEquipmentSlot.CHEST) {
            EnumDemonWillType type = this.getCurrentType(stack);
            switch (type) {
                case CORROSIVE: {
                    if (player.func_70644_a(MobEffects.field_76436_u)) {
                        player.func_184596_c(MobEffects.field_76436_u);
                    }
                    if (!player.func_70644_a(MobEffects.field_82731_v)) break;
                    player.func_184596_c(MobEffects.field_82731_v);
                    break;
                }
            }
        }
    }

    public void onPlayerAttacked(ItemStack stack, DamageSource source, EntityPlayer attackedPlayer) {
        if (source.func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
            EnumDemonWillType type = this.getCurrentType(stack);
            switch (type) {
                case CORROSIVE: {
                    if (source.func_76352_a()) break;
                    attacker.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100));
                    break;
                }
                case DEFAULT: {
                    break;
                }
                case DESTRUCTIVE: {
                    break;
                }
                case STEADFAST: {
                    break;
                }
            }
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack stack, DamageSource source, double damage, int slot) {
        double armourReduction = 0.0;
        double damageAmount = 0.25;
        if (this == ModItems.SENTIENT_ARMOUR_BOOTS || this == ModItems.SENTIENT_ARMOUR_HELMET) {
            damageAmount = 0.09;
        } else if (this == ModItems.SENTIENT_ARMOUR_LEGS) {
            damageAmount = 0.18;
        } else if (this == ModItems.SENTIENT_ARMOUR_CHEST) {
            damageAmount = 0.64;
        }
        double armourPenetrationReduction = 0.0;
        int maxAbsorption = 100000;
        if (source.equals(DamageSource.field_76369_e)) {
            return new ISpecialArmor.ArmorProperties(-1, 0.0, 0);
        }
        if (source.equals(DamageSource.field_76380_i)) {
            return new ISpecialArmor.ArmorProperties(-1, 0.0, 0);
        }
        if (this == ModItems.SENTIENT_ARMOUR_CHEST) {
            armourReduction = 0.375;
            ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
            ItemStack leggings = player.func_184582_a(EntityEquipmentSlot.LEGS);
            ItemStack boots = player.func_184582_a(EntityEquipmentSlot.FEET);
            if (helmet == null || leggings == null || boots == null) {
                return new ISpecialArmor.ArmorProperties(-1, damageAmount *= armourReduction, maxAbsorption);
            }
            if (helmet.func_77973_b() instanceof ItemSentientArmour && leggings.func_77973_b() instanceof ItemSentientArmour && boots.func_77973_b() instanceof ItemSentientArmour) {
                double remainder = 1.0;
                armourReduction += (1.0 - (remainder *= 1.0 - this.getArmourModifier(stack))) * (1.0 - armourReduction);
                damageAmount *= armourReduction;
                if (source.func_76363_c()) {
                    return new ISpecialArmor.ArmorProperties(-1, damageAmount * armourPenetrationReduction, maxAbsorption);
                }
                return new ISpecialArmor.ArmorProperties(-1, damageAmount, maxAbsorption);
            }
        } else {
            if (source.func_76363_c()) {
                return new ISpecialArmor.ArmorProperties(-1, damageAmount * armourPenetrationReduction, maxAbsorption);
            }
            return new ISpecialArmor.ArmorProperties(-1, damageAmount, maxAbsorption);
        }
        return new ISpecialArmor.ArmorProperties(-1, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (armor.func_77973_b() == ModItems.SENTIENT_ARMOUR_HELMET) {
            return 3;
        }
        if (armor.func_77973_b() == ModItems.SENTIENT_ARMOUR_CHEST) {
            return 8;
        }
        if (armor.func_77973_b() == ModItems.SENTIENT_ARMOUR_LEGS) {
            return 6;
        }
        if (armor.func_77973_b() == ModItems.SENTIENT_ARMOUR_BOOTS) {
            return 3;
        }
        return 5;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            EnumDemonWillType type = this.getCurrentType(stack);
            double willRequired = this.getCostModifier(stack) * (double)damage;
            double willLeft = PlayerDemonWillHandler.getTotalDemonWill(type, player);
            if (willLeft >= willRequired && ItemSentientArmour.canSustainArmour(type, willLeft)) {
                this.setAbilitiesOfArmour(type, willLeft - willRequired, stack);
                PlayerDemonWillHandler.consumeDemonWill(type, player, willRequired);
            } else {
                this.revertArmour(player, stack);
            }
        }
    }

    public double getCostModifier(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("costModifier");
    }

    public void setCostModifier(ItemStack stack, double modifier) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("costModifier", modifier);
    }

    public double getArmourModifier(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("armourModifier");
    }

    public void setArmourModifier(ItemStack stack, double modifier) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("armourModifier", modifier);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + names[3 - this.field_77881_a.func_188454_b()];
    }

    public void revertArmour(EntityPlayer player, ItemStack itemStack) {
        ItemStack stack = this.getContainedArmourStack(itemStack);
        player.func_184201_a(this.field_77881_a, stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                assert (ItemSentientArmour.this.getCustomLocation() != null);
                EnumDemonWillType type = ((ItemSentientArmour)ModItems.SENTIENT_ARMOUR_HELMET).getCurrentType(stack);
                String additional = "_" + type.func_176610_l().toLowerCase();
                if (stack.func_77973_b() == ModItems.SENTIENT_ARMOUR_HELMET) {
                    return new ModelResourceLocation(ItemSentientArmour.this.getCustomLocation(), "armour=head" + additional);
                }
                if (stack.func_77973_b() == ModItems.SENTIENT_ARMOUR_CHEST) {
                    return new ModelResourceLocation(ItemSentientArmour.this.getCustomLocation(), "armour=body" + additional);
                }
                if (stack.func_77973_b() == ModItems.SENTIENT_ARMOUR_LEGS) {
                    return new ModelResourceLocation(ItemSentientArmour.this.getCustomLocation(), "armour=leg" + additional);
                }
                return new ModelResourceLocation(ItemSentientArmour.this.getCustomLocation(), "armour=feet" + additional);
            }
        };
    }

    @Override
    public ResourceLocation getCustomLocation() {
        return new ResourceLocation("BloodMagic", "item/ItemSentientArmour");
    }

    @Override
    public List<String> getVariants() {
        ArrayList<String> ret = new ArrayList<String>();
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            String additional = "_" + type.func_176610_l().toLowerCase();
            ret.add("armour=head" + additional);
            ret.add("armour=body" + additional);
            ret.add("armour=leg" + additional);
            ret.add("armour=feet" + additional);
        }
        return ret;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.CHEST) {
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(new UUID(0L, 318145L), "Armor modifier", this.getHealthBonus(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(new UUID(0L, 8145L), "Armor modifier", this.getKnockbackResistance(stack), 0));
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(new UUID(0L, 94021L), "Armor modifier", this.getSpeedBoost(stack), 2));
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(new UUID(0L, 96721L), "Armor modifier", this.getDamageBoost(stack), 2));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(new UUID(0L, 73245L), "Armor modifier", this.getAttackSpeedBoost(stack), 2));
        }
        return multimap;
    }

    public static void revertAllArmour(EntityPlayer player) {
        ItemStack[] armourInventory;
        for (ItemStack stack : armourInventory = player.field_71071_by.field_70460_b) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemSentientArmour)) continue;
            ((ItemSentientArmour)stack.func_77973_b()).revertArmour(player, stack);
        }
    }

    public void setContainedArmourStack(ItemStack newArmour, ItemStack previousArmour) {
        if (newArmour == null || previousArmour == null) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        previousArmour.func_77955_b(tag);
        NBTTagCompound omegaTag = newArmour.func_77978_p();
        if (omegaTag == null) {
            omegaTag = new NBTTagCompound();
            newArmour.func_77982_d(omegaTag);
        }
        omegaTag.func_74782_a("armour", (NBTBase)tag);
        Map enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)previousArmour);
        EnchantmentHelper.func_82782_a((Map)enchantmentMap, (ItemStack)newArmour);
    }

    public ItemStack getContainedArmourStack(ItemStack newArmour) {
        NBTTagCompound omegaTag = newArmour.func_77978_p();
        if (omegaTag == null) {
            return null;
        }
        NBTTagCompound tag = omegaTag.func_74775_l("armour");
        ItemStack armourStack = ItemStack.func_77949_a((NBTTagCompound)tag);
        return armourStack;
    }

    public static boolean convertPlayerArmour(EnumDemonWillType type, double will, EntityPlayer player) {
        if (!ItemSentientArmour.canSustainArmour(type, will)) {
            return false;
        }
        ItemStack helmetStack = player.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack leggingsStack = player.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack bootsStack = player.func_184582_a(EntityEquipmentSlot.FEET);
        ItemStack omegaHelmetStack = ((ItemSentientArmour)ModItems.SENTIENT_ARMOUR_HELMET).getSubstituteStack(type, will, helmetStack);
        ItemStack omegaChestStack = ((ItemSentientArmour)ModItems.SENTIENT_ARMOUR_CHEST).getSubstituteStack(type, will, chestStack);
        ItemStack omegaLeggingsStack = ((ItemSentientArmour)ModItems.SENTIENT_ARMOUR_LEGS).getSubstituteStack(type, will, leggingsStack);
        ItemStack omegaBootsStack = ((ItemSentientArmour)ModItems.SENTIENT_ARMOUR_BOOTS).getSubstituteStack(type, will, bootsStack);
        player.func_184201_a(EntityEquipmentSlot.HEAD, omegaHelmetStack);
        player.func_184201_a(EntityEquipmentSlot.CHEST, omegaChestStack);
        player.func_184201_a(EntityEquipmentSlot.LEGS, omegaLeggingsStack);
        player.func_184201_a(EntityEquipmentSlot.FEET, omegaBootsStack);
        return true;
    }

    public ItemStack getSubstituteStack(EnumDemonWillType type, double will, ItemStack previousArmour) {
        ItemStack newArmour = new ItemStack((Item)this);
        this.setContainedArmourStack(newArmour, previousArmour);
        this.setAbilitiesOfArmour(type, will, newArmour);
        return newArmour;
    }

    @Override
    public EnumDemonWillType getCurrentType(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_74764_b("demonWillType")) {
            return EnumDemonWillType.DEFAULT;
        }
        return EnumDemonWillType.valueOf(tag.func_74779_i("demonWillType").toUpperCase(Locale.ENGLISH));
    }

    public void setCurrentType(EnumDemonWillType type, ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74778_a("demonWillType", type.toString());
    }

    public void setAbilitiesOfArmour(EnumDemonWillType type, double willValue, ItemStack armourStack) {
        int willBracket = ItemSentientArmour.getWillBracket(willValue);
        if (willBracket >= 0) {
            double recurringCost = consumptionPerHit[willBracket];
            this.setCostModifier(armourStack, recurringCost);
            this.setCurrentType(type, armourStack);
            if (this.field_77881_a == EntityEquipmentSlot.CHEST) {
                this.setArmourModifier(armourStack, this.getArmourModifier(type, willBracket));
                this.setHealthBonus(armourStack, this.getHealthModifier(type, willBracket));
                this.setKnockbackResistance(armourStack, this.getKnockbackModifier(type, willBracket));
                this.setSpeedBoost(armourStack, this.getSpeedModifier(type, willBracket));
                this.setDamageBoost(armourStack, this.getDamageModifier(type, willBracket));
                this.setAttackSpeedBoost(armourStack, this.getAttackSpeedModifier(type, willBracket));
            }
        }
    }

    public double getArmourModifier(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case STEADFAST: {
                return steadfastProtectionLevel[willBracket];
            }
        }
        return extraProtectionLevel[willBracket];
    }

    public double getHealthModifier(EnumDemonWillType type, int willBracket) {
        switch (type) {
            default: 
        }
        return 0.0;
    }

    public double getKnockbackModifier(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case STEADFAST: {
                return knockbackBonus[willBracket];
            }
        }
        return 0.0;
    }

    public double getSpeedModifier(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case VENGEFUL: {
                return speedBonus[willBracket];
            }
        }
        return 0.0;
    }

    public double getDamageModifier(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case DESTRUCTIVE: {
                return damageBoost[willBracket];
            }
        }
        return 0.0;
    }

    public double getAttackSpeedModifier(EnumDemonWillType type, int willBracket) {
        switch (type) {
            case DESTRUCTIVE: {
                return attackSpeed[willBracket];
            }
        }
        return 0.0;
    }

    public static boolean canSustainArmour(EnumDemonWillType type, double willValue) {
        return ItemSentientArmour.getWillBracket(willValue) >= 0;
    }

    public static int getWillBracket(double will) {
        int bracket = -1;
        for (int i = 0; i < willBracket.length; ++i) {
            if (!(will >= willBracket[i])) continue;
            bracket = i;
        }
        return bracket;
    }

    public double getHealthBonus(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("soulSwordHealth");
    }

    public void setHealthBonus(ItemStack stack, double hp) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("soulSwordHealth", hp);
    }

    public double getKnockbackResistance(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("knockback");
    }

    public void setKnockbackResistance(ItemStack stack, double kb) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("knockback", kb);
    }

    public double getSpeedBoost(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("speed");
    }

    public void setSpeedBoost(ItemStack stack, double speed) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("speed", speed);
    }

    public double getDamageBoost(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("damage");
    }

    public void setDamageBoost(ItemStack stack, double damage) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("damage", damage);
    }

    public double getAttackSpeedBoost(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        return tag.func_74769_h("attackSpeed");
    }

    public void setAttackSpeedBoost(ItemStack stack, double attackSpeed) {
        NBTHelper.checkNBT(stack);
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74780_a("attackSpeed", attackSpeed);
    }
}

