/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.client.hud;

import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.client.hud.HUDElement;
import WayofTime.bloodmagic.proxy.ClientProxy;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class HUDElementDemonWillAura
extends HUDElement {
    protected List<EnumDemonWillType> barOrder = new ArrayList<EnumDemonWillType>();

    public HUDElementDemonWillAura() {
        super(5, 5, RenderGameOverlayEvent.ElementType.HOTBAR);
        this.barOrder.add(EnumDemonWillType.DEFAULT);
        this.barOrder.add(EnumDemonWillType.CORROSIVE);
        this.barOrder.add(EnumDemonWillType.STEADFAST);
        this.barOrder.add(EnumDemonWillType.DESTRUCTIVE);
        this.barOrder.add(EnumDemonWillType.VENGEFUL);
    }

    @Override
    public void render(Minecraft minecraft, ScaledResolution resolution, float partialTicks) {
        EntityPlayerSP player = minecraft.field_71439_g;
        if (!Utils.canPlayerSeeDemonWill((EntityPlayer)player)) {
            return;
        }
        minecraft.func_110434_K().func_110577_a(new ResourceLocation("BloodMagic", "textures/hud/bars.png"));
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.getXOffset(), this.getYOffset(), 0.0, 210.0, 80.0, 46.0);
        double maxAmount = Utils.getDemonWillResolution((EntityPlayer)player);
        int i = 0;
        for (EnumDemonWillType type : this.barOrder) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            minecraft.func_110434_K().func_110577_a(new ResourceLocation("BloodMagic", "textures/hud/bars.png"));
            int textureXOffset = ++i > 3 ? i - 3 : 3 - i;
            int maxBarSize = 30 - 2 * textureXOffset;
            double amount = ClientProxy.currentAura == null ? 0.0 : ClientProxy.currentAura.getWill(type);
            double ratio = Math.max(Math.min(amount / maxAmount, 1.0), 0.0);
            double width = (double)maxBarSize * ratio * 2.0;
            double height = 2.0;
            double x = this.getXOffset() + 2 * textureXOffset + 10;
            double y = this.getYOffset() + 4 * i + 10;
            double textureX = 2 * textureXOffset + 84;
            double textureY = 4 * i + 220;
            this.drawTexturedModalRect(x, y, textureX, textureY, width, height);
            if (!player.func_70093_af()) continue;
            GlStateManager.func_179094_E();
            String value = "" + (int)amount;
            GlStateManager.func_179137_b((double)(x - (double)(2 * textureXOffset) - (double)(value.length() * 0) + 70.0), (double)(y - 1.0), (double)0.0);
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            minecraft.field_71466_p.func_175063_a("" + (int)amount, 0.0f, 2.0f, 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public boolean shouldRender(Minecraft minecraft) {
        return true;
    }
}

