/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.teleport;

import java.io.Serializable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class PortalLocation
implements Serializable {
    private int x;
    private int y;
    private int z;
    private int dimension;

    public PortalLocation(int x, int y, int z, int dimension) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
    }

    public PortalLocation(BlockPos blockPos, int dimension) {
        this(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), dimension);
    }

    public static PortalLocation readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("portalLocation")) {
            NBTTagCompound locationTag = tag.func_74775_l("portalLocation");
            return new PortalLocation(locationTag.func_74762_e("xCoord"), locationTag.func_74762_e("yCoord"), locationTag.func_74762_e("zCoord"), locationTag.func_74762_e("dimensionId"));
        }
        return null;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound locationTag = new NBTTagCompound();
        locationTag.func_74768_a("xCoord", this.x);
        locationTag.func_74768_a("yCoord", this.y);
        locationTag.func_74768_a("zCoord", this.z);
        locationTag.func_74768_a("dimensionId", this.dimension);
        tag.func_74782_a("portalLocation", (NBTBase)locationTag);
        return tag;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortalLocation that = (PortalLocation)o;
        if (this.x != that.x) {
            return false;
        }
        if (this.y != that.y) {
            return false;
        }
        return this.z == that.z;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public String toString() {
        return "PortalLocation(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", dimension=" + this.getDimension() + ")";
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getDimension() {
        return this.dimension;
    }
}

