/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.init;

import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.MetalType;
import erogenousbeef.bigreactors.common.config.Config;
import erogenousbeef.bigreactors.common.item.ItemBRMetal;
import erogenousbeef.bigreactors.common.item.ItemMineral;
import erogenousbeef.bigreactors.common.item.ItemTieredComponent;
import erogenousbeef.bigreactors.common.item.ItemWrench;
import erogenousbeef.bigreactors.common.multiblock.PartTier;
import erogenousbeef.bigreactors.init.InitHandler;
import it.zerono.mods.zerocore.lib.MetalSize;
import it.zerono.mods.zerocore.util.OreDictionaryHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class BrItems {
    public static final ItemBRMetal ingotMetals;
    public static final ItemBRMetal dustMetals;
    public static final ItemMineral minerals;
    public static final ItemTieredComponent reactorCasingCores;
    public static final ItemTieredComponent turbineHousingCores;
    public static final ItemWrench wrench;

    static void initialize() {
    }

    static {
        InitHandler init = InitHandler.INSTANCE;
        ingotMetals = (ItemBRMetal)init.register(new ItemBRMetal("ingotmetals", MetalSize.Ingot){

            @Override
            public void registerRecipes() {
                Config configs = BigReactors.CONFIG;
                ItemStack ingotGraphite = OreDictionaryHelper.getOre((String)"ingotGraphite");
                ItemStack ingotCyanite = OreDictionaryHelper.getOre((String)"ingotCyanite");
                if (configs.registerCoalForSmelting) {
                    GameRegistry.addSmelting((Item)Items.field_151044_h, (ItemStack)ingotGraphite, (float)1.0f);
                }
                if (configs.registerCharcoalForSmelting) {
                    GameRegistry.addSmelting((ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (ItemStack)ingotGraphite, (float)1.0f);
                }
                if (configs.registerGraphiteCoalCraftingRecipes) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ingotGraphite, new Object[]{"GCG", Character.valueOf('G'), Blocks.field_150351_n, Character.valueOf('C'), new ItemStack(Items.field_151044_h, 1, 0)}));
                }
                if (configs.registerGraphiteCharcoalCraftingRecipes) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ingotGraphite, new Object[]{"GCG", Character.valueOf('G'), Blocks.field_150351_n, Character.valueOf('C'), new ItemStack(Items.field_151044_h, 1, 1)}));
                }
                if (configs.enableCyaniteFromYelloriumRecipe) {
                    GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(ingotCyanite, new Object[]{configs.recipeYelloriumIngotName, Blocks.field_150354_m}));
                }
                GameRegistry.addRecipe((ItemStack)ingotMetals.createItemStack(MetalType.Blutonium, 1), (Object[])new Object[]{"CCC", "C C", "CCC", Character.valueOf('C'), ingotCyanite});
            }
        });
        dustMetals = (ItemBRMetal)init.register(new ItemBRMetal("dustmetals", MetalSize.Dust){

            @Override
            public void registerRecipes() {
                for (MetalType metal : MetalType.VALUES) {
                    GameRegistry.addSmelting((ItemStack)dustMetals.createItemStack(metal, 1), (ItemStack)ingotMetals.createItemStack(metal, 1), (float)0.0f);
                }
            }
        });
        minerals = (ItemMineral)init.register(new ItemMineral("minerals"));
        reactorCasingCores = (ItemTieredComponent)init.register(new ItemTieredComponent("reactorcasingcores"){

            @Override
            public void registerRecipes() {
                if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Legacy)) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.createItemStack(PartTier.Legacy, 1), new Object[]{"IGI", "ARA", "IGI", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "ingotGraphite", Character.valueOf('A'), "ingotGold", Character.valueOf('R'), Items.field_151137_ax}));
                }
                if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Basic)) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.createItemStack(PartTier.Basic, 1), new Object[]{"IGI", "ARA", "IGI", Character.valueOf('I'), "ingotSteel", Character.valueOf('G'), "ingotGraphite", Character.valueOf('A'), "ingotGold", Character.valueOf('R'), Items.field_151137_ax}));
                }
            }
        });
        turbineHousingCores = (ItemTieredComponent)init.register(new ItemTieredComponent("turbinehousingcores"){

            @Override
            public void registerRecipes() {
                if (PartTier.TURBINE_TIERS.contains((Object)PartTier.Legacy)) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.createItemStack(PartTier.Legacy, 1), new Object[]{"IGI", "ARA", "IGI", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "ingotGraphite", Character.valueOf('A'), "ingotGold", Character.valueOf('R'), Items.field_151132_bS}));
                }
                if (PartTier.TURBINE_TIERS.contains((Object)PartTier.Basic)) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.createItemStack(PartTier.Basic, 1), new Object[]{"IGI", "ARA", "IGI", Character.valueOf('I'), "ingotSteel", Character.valueOf('G'), "ingotGraphite", Character.valueOf('A'), "ingotGold", Character.valueOf('R'), Items.field_151132_bS}));
                }
            }
        });
        wrench = (ItemWrench)init.register(new ItemWrench("wrench"));
    }
}

