/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.multiblock.IInputOutputPort;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePart;
import java.util.HashMap;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.network.ManagedPeripheral", modid="OpenComputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")})
public class TileEntityTurbineComputerPort
extends TileEntityTurbinePart
implements IPeripheral,
SimpleComponent,
ManagedPeripheral {
    public static final int numMethods;
    public static final String[] methodNames;
    public static final Map<String, Integer> methodIds;

    public Object[] callMethod(int method, Object[] arguments) throws Exception {
        if (method < 0 || method >= numMethods) {
            throw new IllegalArgumentException("Invalid method number");
        }
        if (method == 0) {
            return new Object[]{this.isConnected()};
        }
        if (!this.isConnected()) {
            throw new Exception("Unable to access turbine - port is not connected");
        }
        ComputerMethod computerMethod = ComputerMethod.values()[method];
        MultiblockTurbine turbine = this.getTurbine();
        switch (computerMethod) {
            case getConnected: {
                return new Object[]{this.isConnected()};
            }
            case getActive: {
                return new Object[]{turbine.getActive()};
            }
            case getEnergyProducedLastTick: {
                return new Object[]{Float.valueOf(turbine.getEnergyGeneratedLastTick())};
            }
            case getEnergyStored: {
                return new Object[]{turbine.getEnergyStored()};
            }
            case getFluidAmountMax: {
                return new Object[]{4000};
            }
            case getFluidFlowRate: {
                return new Object[]{turbine.getFluidConsumedLastTick()};
            }
            case getFluidFlowRateMax: {
                return new Object[]{turbine.getMaxIntakeRate()};
            }
            case getFluidFlowRateMaxMax: {
                return new Object[]{turbine.getMaxIntakeRateMax()};
            }
            case getInputAmount: {
                return new Object[]{this.getFluidAmount(IInputOutputPort.Direction.Input)};
            }
            case getInputType: {
                return new Object[]{this.getFluidName(IInputOutputPort.Direction.Input)};
            }
            case getOutputAmount: {
                return new Object[]{this.getFluidAmount(IInputOutputPort.Direction.Output)};
            }
            case getOutputType: {
                return new Object[]{this.getFluidName(IInputOutputPort.Direction.Output)};
            }
            case getRotorSpeed: {
                return new Object[]{Float.valueOf(turbine.getRotorSpeed())};
            }
            case getNumberOfBlades: {
                return new Object[]{turbine.getNumRotorBlades()};
            }
            case getBladeEfficiency: {
                return new Object[]{Float.valueOf(turbine.getRotorEfficiencyLastTick() * 100.0f)};
            }
            case getRotorMass: {
                return new Object[]{turbine.getRotorMass()};
            }
            case getInductorEngaged: {
                return new Object[]{turbine.getInductorEngaged()};
            }
            case getMinimumCoordinate: {
                BlockPos coord = turbine.getMinimumCoord();
                return new Object[]{coord.func_177958_n(), coord.func_177956_o(), coord.func_177952_p()};
            }
            case getMaximumCoordinate: {
                BlockPos coord = turbine.getMaximumCoord();
                return new Object[]{coord.func_177958_n(), coord.func_177956_o(), coord.func_177952_p()};
            }
            case setActive: {
                if (arguments.length < 1) {
                    throw new IllegalArgumentException("Insufficient number of arguments, expected 1");
                }
                if (!(arguments[0] instanceof Boolean)) {
                    throw new IllegalArgumentException("Invalid argument 0, expected Boolean");
                }
                turbine.setActive((Boolean)arguments[0]);
                break;
            }
            case setFluidFlowRateMax: {
                if (arguments.length < 1) {
                    throw new IllegalArgumentException("Insufficient number of arguments, expected 1");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new IllegalArgumentException("Invalid argument 0, expected Number");
                }
                int newRate = (int)Math.round((Double)arguments[0]);
                turbine.setMaxIntakeRate(newRate);
                break;
            }
            case setVentNone: {
                turbine.setVentStatus(MultiblockTurbine.VentStatus.DoNotVent, true);
                break;
            }
            case setVentOverflow: {
                turbine.setVentStatus(MultiblockTurbine.VentStatus.VentOverflow, true);
                break;
            }
            case setVentAll: {
                turbine.setVentStatus(MultiblockTurbine.VentStatus.VentAll, true);
                break;
            }
            case setInductorEngaged: {
                if (arguments.length < 1) {
                    throw new IllegalArgumentException("Insufficient number of arguments, expected 1");
                }
                if (!(arguments[0] instanceof Boolean)) {
                    throw new IllegalArgumentException("Invalid argument 0, expected Boolean");
                }
                turbine.setInductorEngaged((Boolean)arguments[0], true);
                break;
            }
            case getEnergyCapacity: {
                return new Object[]{turbine.getEnergyCapacity()};
            }
            default: {
                throw new Exception("Method unimplemented - yell at Beef");
            }
        }
        return null;
    }

    private IFluidTankProperties getTankProperties(IInputOutputPort.Direction direction) {
        MultiblockTurbine turbine = this.getTurbine();
        IFluidHandler handler = null != turbine ? turbine.getFluidHandler(direction) : null;
        IFluidTankProperties[] properties = null != handler ? handler.getTankProperties() : null;
        return null != properties && properties.length > 0 ? properties[0] : null;
    }

    private int getFluidAmount(IInputOutputPort.Direction direction) {
        IFluidTankProperties properties = this.getTankProperties(direction);
        FluidStack stack = null != properties ? properties.getContents() : null;
        return null != stack ? stack.amount : 0;
    }

    private String getFluidName(IInputOutputPort.Direction direction) {
        IFluidTankProperties properties = this.getTankProperties(direction);
        FluidStack stack = null != properties ? properties.getContents() : null;
        Fluid fluid = null != stack ? stack.getFluid() : null;
        return null != fluid ? fluid.getName() : null;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "BigReactors-Turbine";
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return methodNames;
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        try {
            return this.callMethod(method, arguments);
        }
        catch (Exception e) {
            BRLog.info("Exception encountered when invoking computercraft method: %s", e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "br_turbine";
    }

    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return methodNames;
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        Object[] arguments = new Object[args.count()];
        for (int i = 0; i < args.count(); ++i) {
            arguments[i] = args.checkAny(i);
        }
        Integer methodId = methodIds.get(method);
        if (methodId == null) {
            throw new NoSuchMethodError();
        }
        return this.callMethod(methodId, arguments);
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this.hashCode() == other.hashCode();
    }

    static {
        ComputerMethod[] methods;
        numMethods = ComputerMethod.values().length;
        methodNames = new String[numMethods];
        for (ComputerMethod method : methods = ComputerMethod.values()) {
            TileEntityTurbineComputerPort.methodNames[method.ordinal()] = method.toString();
        }
        methodIds = new HashMap<String, Integer>();
        for (int i = 0; i < numMethods; ++i) {
            methodIds.put(methodNames[i], i);
        }
    }

    public static enum ComputerMethod {
        getConnected,
        getActive,
        getEnergyStored,
        getRotorSpeed,
        getInputAmount,
        getInputType,
        getOutputAmount,
        getOutputType,
        getFluidAmountMax,
        getFluidFlowRate,
        getFluidFlowRateMax,
        getFluidFlowRateMaxMax,
        getEnergyProducedLastTick,
        getNumberOfBlades,
        getBladeEfficiency,
        getRotorMass,
        getInductorEngaged,
        getMaximumCoordinate,
        getMinimumCoordinate,
        setActive,
        setFluidFlowRateMax,
        setVentNone,
        setVentOverflow,
        setVentAll,
        setInductorEngaged,
        getEnergyCapacity;

    }
}

