/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock;

import erogenousbeef.bigreactors.api.data.CoilPartData;
import erogenousbeef.bigreactors.api.registry.TurbineCoil;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.MetalType;
import erogenousbeef.bigreactors.common.block.BlockBRMetal;
import erogenousbeef.bigreactors.common.multiblock.IInputOutputPort;
import erogenousbeef.bigreactors.common.multiblock.IPowerGenerator;
import erogenousbeef.bigreactors.common.multiblock.PartTier;
import erogenousbeef.bigreactors.common.multiblock.PowerSystem;
import erogenousbeef.bigreactors.common.multiblock.RotorShaftState;
import erogenousbeef.bigreactors.common.multiblock.block.ITurbineRotorPart;
import erogenousbeef.bigreactors.common.multiblock.helpers.FloatUpdateTracker;
import erogenousbeef.bigreactors.common.multiblock.interfaces.IActivateable;
import erogenousbeef.bigreactors.common.multiblock.interfaces.ITickableMultiblockPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPartBase;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartBase;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartGlass;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePowerTap;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePowerTapRedstoneFlux;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePowerTapTesla;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorBearing;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorBlade;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorShaft;
import erogenousbeef.bigreactors.gui.container.ISlotlessUpdater;
import erogenousbeef.bigreactors.init.BrBlocks;
import erogenousbeef.bigreactors.init.BrFluids;
import erogenousbeef.bigreactors.net.CommonPacketHandler;
import erogenousbeef.bigreactors.net.message.multiblock.TurbineUpdateMessage;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.zerocore.api.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.api.multiblock.rectangular.RectangularMultiblockControllerBase;
import it.zerono.mods.zerocore.api.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.api.multiblock.validation.ValidationError;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.lib.config.IConfigListener;
import it.zerono.mods.zerocore.util.CodeHelper;
import it.zerono.mods.zerocore.util.OreDictionaryHelper;
import it.zerono.mods.zerocore.util.WorldHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MultiblockTurbine
extends RectangularMultiblockControllerBase
implements IPowerGenerator,
ISlotlessUpdater,
IActivateable,
IConfigListener,
IDebuggable {
    public static final VentStatus[] s_VentStatuses = VentStatus.values();
    private Set<EntityPlayer> updatePlayers;
    private int ticksSinceLastUpdate = 0;
    private static final int ticksBetweenUpdates = 3;
    public static final int FLUID_NONE = -1;
    public static final int TANK_SIZE = 4000;
    public static final int MAX_PERMITTED_FLOW = 2000;
    public static final int BASE_FLUID_PER_BLADE = 25;
    private FluidTank _inputTank;
    private FluidTank _outputTank;
    static final float maxEnergyStored = 1000000.0f;
    float energyStored = 0.0f;
    private PowerSystem _powerSystem;
    private PartTier _partsTier;
    private boolean _legacyMode;
    private boolean active = false;
    float rotorEnergy = 0.0f;
    boolean inductorEngaged = true;
    VentStatus ventStatus;
    int maxIntakeRate = 2000;
    int bladeSurfaceArea = 0;
    int rotorMass = 0;
    int coilSize = 0;
    float inductorDragCoefficient = inductorBaseDragCoefficient;
    float inductionEfficiency = 0.5f;
    float inductionEnergyExponentBonus = 1.0f;
    float rotorDragCoefficient = 0.01f;
    float bladeDrag = 2.5E-4f;
    float frictionalDrag = 0.0f;
    public static int inputFluidPerBlade = 25;
    private static float inductorBaseDragCoefficient = 0.1f;
    private static final float baseBladeDragCoefficient = 2.5E-4f;
    float energyGeneratedLastTick = 0.0f;
    int fluidConsumedLastTick = 0;
    float rotorEfficiencyLastTick = 1.0f;
    private Set<IMultiblockPart> attachedControllers;
    private Set<TileEntityTurbineRotorBearing> attachedRotorBearings;
    private Set<TileEntityTurbinePowerTap> attachedPowerTaps;
    private Set<ITickableMultiblockPart> attachedTickables;
    private Set<TileEntityTurbineRotorShaft> attachedRotorShafts;
    private Set<TileEntityTurbineRotorBlade> attachedRotorBlades;
    private Set<TileEntityTurbinePartGlass> attachedGlass;
    private boolean _interiorInvisible;
    private Set<BlockPos> foundCoils;
    private FloatUpdateTracker rpmUpdateTracker;
    private static final EnumFacing[] RotorXBladeDirections = new EnumFacing[]{EnumFacing.UP, EnumFacing.SOUTH, EnumFacing.DOWN, EnumFacing.NORTH};
    private static final EnumFacing[] RotorZBladeDirections = new EnumFacing[]{EnumFacing.UP, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.WEST};

    public MultiblockTurbine(World world) {
        super(world);
        this.updatePlayers = new HashSet<EntityPlayer>();
        this.attachedControllers = new HashSet<IMultiblockPart>();
        this.attachedRotorBearings = new HashSet<TileEntityTurbineRotorBearing>();
        this.attachedPowerTaps = new HashSet<TileEntityTurbinePowerTap>();
        this.attachedTickables = new HashSet<ITickableMultiblockPart>();
        this.attachedRotorShafts = new HashSet<TileEntityTurbineRotorShaft>();
        this.attachedRotorBlades = new HashSet<TileEntityTurbineRotorBlade>();
        this.attachedGlass = new HashSet<TileEntityTurbinePartGlass>();
        this._powerSystem = PowerSystem.RedstoneFlux;
        this.ventStatus = VentStatus.VentOverflow;
        this.foundCoils = new HashSet<BlockPos>();
        this.rpmUpdateTracker = new FloatUpdateTracker(100, 5, 10.0f, 100.0f);
        this._inputTank = new FluidTank(4000){

            public boolean canFillFluidType(FluidStack fluidStack) {
                boolean allowed;
                boolean bl = allowed = null != fluidStack && super.canFillFluidType(fluidStack);
                if (allowed) {
                    allowed = BrFluids.isFluidUsableAsSteam(this.getFluid(), fluidStack);
                }
                return allowed;
            }
        };
        this._inputTank.setCanDrain(false);
        this._outputTank = new FluidTank(4000);
        this._outputTank.setCanFill(false);
        this._partsTier = PartTier.Legacy;
        this._legacyMode = false;
    }

    public void onConfigChanged() {
        inductorBaseDragCoefficient = 0.1f * BigReactors.CONFIG.turbineCoilDragMultiplier;
        inputFluidPerBlade = (int)Math.floor(25.0 * BigReactors.CONFIG.turbineFluidPerBladeMultiplier);
        this.recalculateDerivedStatistics();
    }

    protected void sendIndividualUpdate(EntityPlayer player) {
        if (this.WORLD.field_72995_K) {
            return;
        }
        CommonPacketHandler.INSTANCE.sendTo(this.getUpdatePacket(), (EntityPlayerMP)player);
    }

    protected IMessage getUpdatePacket() {
        return new TurbineUpdateMessage(this);
    }

    protected void sendTickUpdate() {
        if (this.updatePlayers.size() <= 0) {
            return;
        }
        for (EntityPlayer player : this.updatePlayers) {
            CommonPacketHandler.INSTANCE.sendTo(this.getUpdatePacket(), (EntityPlayerMP)player);
        }
    }

    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
        this.syncDataFrom(data, ModTileEntity.SyncReason.FullSync);
    }

    protected void onBlockAdded(IMultiblockPart newPart) {
        if (newPart instanceof TileEntityTurbineRotorBearing) {
            this.attachedRotorBearings.add((TileEntityTurbineRotorBearing)newPart);
        }
        if (newPart instanceof TileEntityTurbinePowerTap) {
            this.attachedPowerTaps.add((TileEntityTurbinePowerTap)newPart);
        }
        if (newPart instanceof ITickableMultiblockPart) {
            this.attachedTickables.add((ITickableMultiblockPart)newPart);
        }
        if (newPart instanceof TileEntityTurbineRotorShaft) {
            this.attachedRotorShafts.add((TileEntityTurbineRotorShaft)newPart);
        }
        if (newPart instanceof TileEntityTurbineRotorBlade) {
            this.attachedRotorBlades.add((TileEntityTurbineRotorBlade)newPart);
        }
        if (newPart instanceof TileEntityTurbinePartGlass) {
            this.attachedGlass.add((TileEntityTurbinePartGlass)newPart);
        }
    }

    protected void onBlockRemoved(IMultiblockPart oldPart) {
        if (oldPart instanceof TileEntityTurbineRotorBearing) {
            this.attachedRotorBearings.remove(oldPart);
        }
        if (oldPart instanceof TileEntityTurbinePowerTap) {
            this.attachedPowerTaps.remove(oldPart);
        }
        if (oldPart instanceof ITickableMultiblockPart) {
            this.attachedTickables.remove(oldPart);
        }
        if (oldPart instanceof TileEntityTurbineRotorShaft) {
            this.attachedRotorShafts.remove(oldPart);
        }
        if (oldPart instanceof TileEntityTurbineRotorBlade) {
            this.attachedRotorBlades.remove(oldPart);
        }
        if (oldPart instanceof TileEntityTurbinePartGlass) {
            this.attachedGlass.remove(oldPart);
        }
    }

    protected void onMachineAssembled() {
        this.recalculateDerivedStatistics();
        PartTier candidateTier = null;
        for (IMultiblockPart part : this.connectedParts) {
            if (!(part instanceof TileEntityReactorPartBase)) continue;
            PartTier tier = ((TileEntityReactorPartBase)part).getPartTier();
            if (null == candidateTier) {
                candidateTier = tier;
                continue;
            }
            if (candidateTier == tier) continue;
            throw new IllegalStateException("Found block of a different tier while assembling the machine!");
        }
        this._partsTier = candidateTier;
        this._legacyMode = PartTier.Legacy == candidateTier;
        PowerSystem candidatePowerSystem = PowerSystem.RedstoneFlux;
        if (this.attachedPowerTaps.size() > 0) {
            int rf = 0;
            int tesla = 0;
            for (TileEntityTurbinePowerTap tap : this.attachedPowerTaps) {
                if (tap instanceof TileEntityTurbinePowerTapRedstoneFlux) {
                    ++rf;
                    continue;
                }
                if (!(tap instanceof TileEntityTurbinePowerTapTesla)) continue;
                ++tesla;
            }
            if (rf != 0 && tesla != 0) {
                throw new IllegalStateException("Found different power taps while assembling the machine!");
            }
            candidatePowerSystem = tesla > 0 ? PowerSystem.Tesla : PowerSystem.RedstoneFlux;
        }
        this.switchPowerSystem(candidatePowerSystem);
        this._interiorInvisible = this.attachedGlass.size() == 0;
        this.markMultiblockForRenderUpdate();
    }

    protected void onMachineRestored() {
        this.onMachineAssembled();
    }

    protected void onMachinePaused() {
        this.markMultiblockForRenderUpdate();
    }

    protected void onMachineDisassembled() {
        this.active = false;
        this.rotorMass = 0;
        this.bladeSurfaceArea = 0;
        this.coilSize = 0;
        this.rotorEnergy = 0.0f;
        this.rpmUpdateTracker.setValue(0.0f);
        this.markMultiblockForRenderUpdate();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        boolean rotorEndValid;
        int turbineLength;
        if (this.attachedRotorBearings.size() != 1) {
            validatorCallback.setLastError("multiblock.validation.turbine.invalid_rotor_count", new Object[0]);
            return false;
        }
        this.foundCoils.clear();
        if (!super.isMachineWhole(validatorCallback)) {
            return false;
        }
        TileEntityTurbinePartBase rotorBearing = this.attachedRotorBearings.iterator().next();
        rotorBearing.recalculateOutwardsDirection(this.getMinimumCoord(), this.getMaximumCoord());
        EnumFacing rotorDir = rotorBearing.getOutwardFacing();
        EnumFacing.Axis rotatedDirAxis = rotorDir.func_176740_k();
        if (null == rotorDir) {
            validatorCallback.setLastError("multiblock.validation.turbine.incomplete", new Object[0]);
            return false;
        }
        rotorDir = rotorDir.func_176734_d();
        BlockPos turbineMinCoord = this.getMinimumCoord();
        BlockPos turbineMaxCoord = this.getMaximumCoord();
        switch (rotorDir.func_176740_k()) {
            case X: {
                turbineLength = turbineMaxCoord.func_177958_n() - turbineMinCoord.func_177958_n();
                break;
            }
            default: {
                turbineLength = turbineMaxCoord.func_177956_o() - turbineMinCoord.func_177956_o();
                break;
            }
            case Z: {
                turbineLength = turbineMaxCoord.func_177952_p() - turbineMinCoord.func_177952_p();
            }
        }
        turbineLength = Math.abs(turbineLength) - 1;
        BlockPos rotorCoord = rotorBearing.getWorldPosition();
        BlockPos endRotorCoord = rotorCoord.func_177967_a(rotorDir, turbineLength);
        EnumFacing[] bladeDirections = RotorShaftState.getBladesDirections(rotorDir.func_176740_k());
        HashSet<BlockPos> rotorShafts = new HashSet<BlockPos>(this.attachedRotorShafts.size());
        HashSet<BlockPos> rotorBlades = new HashSet<BlockPos>(this.attachedRotorBlades.size());
        for (TileEntityTurbineRotorShaft tileEntityTurbineRotorShaft : this.attachedRotorShafts) {
            rotorShafts.add(tileEntityTurbineRotorShaft.getWorldPosition());
        }
        for (TileEntityTurbineRotorBlade tileEntityTurbineRotorBlade : this.attachedRotorBlades) {
            rotorBlades.add(tileEntityTurbineRotorBlade.getWorldPosition());
        }
        boolean encounteredCoils = false;
        while (!rotorShafts.isEmpty() && !rotorCoord.equals((Object)endRotorCoord)) {
            if (!rotorShafts.remove(rotorCoord = rotorCoord.func_177972_a(rotorDir))) {
                validatorCallback.setLastError("multiblock.validation.turbine.block_must_be_rotor", new Object[]{rotorCoord});
                return false;
            }
            boolean encounteredBlades = false;
            for (EnumFacing bladeDir : bladeDirections) {
                void var14_20;
                boolean foundABlade = false;
                BlockPos blockPos = rotorCoord.func_177972_a(bladeDir);
                while (rotorBlades.remove(var14_20)) {
                    if (encounteredCoils) {
                        validatorCallback.setLastError("multiblock.validation.turbine.blades_too_far", new Object[]{var14_20});
                        return false;
                    }
                    encounteredBlades = true;
                    foundABlade = true;
                    BlockPos blockPos2 = var14_20.func_177972_a(bladeDir);
                }
                if (foundABlade || !this.foundCoils.remove(var14_20)) continue;
                encounteredCoils = true;
                if (encounteredBlades) {
                    validatorCallback.setLastError("multiblock.validation.turbine.metal_too_near", new Object[]{var14_20});
                    return false;
                }
                EnumFacing rotatedDir = bladeDir.func_176732_a(rotatedDirAxis);
                BlockPos coilCheck = var14_20.func_177972_a(rotatedDir);
                this.foundCoils.remove(coilCheck);
                rotatedDir = rotatedDir.func_176732_a(rotatedDirAxis).func_176732_a(rotatedDirAxis);
                coilCheck = var14_20.func_177972_a(rotatedDir);
                this.foundCoils.remove(coilCheck);
            }
        }
        if (!rotorCoord.equals((Object)endRotorCoord)) {
            validatorCallback.setLastError("multiblock.validation.turbine.shaft_too_short", new Object[0]);
            return false;
        }
        if (!rotorShafts.isEmpty()) {
            validatorCallback.setLastError("multiblock.validation.turbine.found_loose_rotor_blocks", new Object[]{rotorShafts.size()});
            return false;
        }
        if (!rotorBlades.isEmpty()) {
            validatorCallback.setLastError("multiblock.validation.turbine.found_loose_rotor_blades", new Object[]{rotorBlades.size()});
            return false;
        }
        if (!this.foundCoils.isEmpty()) {
            validatorCallback.setLastError("multiblock.validation.turbine.invalid_metals_shape", new Object[]{this.foundCoils.size()});
            return false;
        }
        TileEntity tileEntity = this.WORLD.func_175625_s(rotorCoord.func_177972_a(rotorDir));
        boolean bl = rotorEndValid = tileEntity instanceof TileEntityTurbinePart && BrBlocks.turbineHousing == tileEntity.func_145838_q();
        if (!rotorEndValid) {
            validatorCallback.setLastError("multiblock.validation.turbine.invalid_rotor_end", new Object[0]);
            return false;
        }
        PartTier candidateTier = null;
        for (IMultiblockPart part : this.connectedParts) {
            if (!(part instanceof TileEntityTurbinePartBase)) continue;
            PartTier tier = ((TileEntityTurbinePartBase)part).getPartTier();
            if (null == candidateTier) {
                candidateTier = tier;
                continue;
            }
            if (candidateTier == tier) continue;
            validatorCallback.setLastError("multiblock.validation.turbine.mixed_tiers", new Object[0]);
            return false;
        }
        if (this.attachedPowerTaps.size() > 0) {
            int rf = 0;
            int tesla = 0;
            for (TileEntityTurbinePowerTap tap : this.attachedPowerTaps) {
                if (tap instanceof TileEntityTurbinePowerTapRedstoneFlux) {
                    ++rf;
                    continue;
                }
                if (!(tap instanceof TileEntityTurbinePowerTapTesla)) continue;
                ++tesla;
            }
            if (rf != 0 && tesla != 0) {
                validatorCallback.setLastError("multiblock.validation.turbine.mixed_power_systems", new Object[0]);
                return false;
            }
        }
        return true;
    }

    protected boolean isBlockGoodForInterior(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        BlockPos position = new BlockPos(x, y, z);
        if (world.func_175623_d(position)) {
            return true;
        }
        if (this.getCoilPartData(world.func_180495_p(position)) != null) {
            this.foundCoils.add(position);
            return true;
        }
        validatorCallback.setLastError("multiblock.validation.turbine.invalid_block_for_interior", new Object[]{x, y, z});
        return false;
    }

    protected boolean isBlockGoodForFrame(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        IBlockState blockState = this.WORLD.func_180495_p(new BlockPos(x, y, z));
        Block block = blockState.func_177230_c();
        validatorCallback.setLastError("multiblock.validation.turbine.invalid_block_for_exterior", new Object[]{x, y, z, block.func_149732_F()});
        return false;
    }

    protected boolean isBlockGoodForTop(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        IBlockState blockState = this.WORLD.func_180495_p(new BlockPos(x, y, z));
        Block block = blockState.func_177230_c();
        validatorCallback.setLastError("multiblock.validation.turbine.invalid_block_for_exterior", new Object[]{x, y, z, block.func_149732_F()});
        return false;
    }

    protected boolean isBlockGoodForBottom(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        IBlockState blockState = this.WORLD.func_180495_p(new BlockPos(x, y, z));
        Block block = blockState.func_177230_c();
        validatorCallback.setLastError("multiblock.validation.turbine.invalid_block_for_exterior", new Object[]{x, y, z, block.func_149732_F()});
        return false;
    }

    protected boolean isBlockGoodForSides(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        IBlockState blockState = this.WORLD.func_180495_p(new BlockPos(x, y, z));
        Block block = blockState.func_177230_c();
        validatorCallback.setLastError("multiblock.validation.turbine.invalid_block_for_exterior", new Object[]{x, y, z, block.func_149732_F()});
        return false;
    }

    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 82;
    }

    protected int getMaximumXSize() {
        return BigReactors.CONFIG.maxTurbineSize;
    }

    protected int getMaximumZSize() {
        return BigReactors.CONFIG.maxTurbineSize;
    }

    protected int getMaximumYSize() {
        return BigReactors.CONFIG.maxTurbineHeight;
    }

    protected int getMinimumXSize() {
        return 5;
    }

    protected int getMinimumYSize() {
        return 4;
    }

    protected int getMinimumZSize() {
        return 5;
    }

    protected void onAssimilate(MultiblockControllerBase otherMachine) {
        if (!(otherMachine instanceof MultiblockTurbine)) {
            BRLog.warning("[%s] Turbine @ %s is attempting to assimilate a non-Turbine machine! That machine's data will be lost!", this.WORLD.field_72995_K ? "CLIENT" : "SERVER", this.getReferenceCoord());
            return;
        }
        MultiblockTurbine otherTurbine = (MultiblockTurbine)otherMachine;
        this.setRotorEnergy(Math.max(this.rotorEnergy, otherTurbine.rotorEnergy));
    }

    protected void onAssimilated(MultiblockControllerBase assimilator) {
        this.attachedControllers.clear();
        this.attachedRotorBearings.clear();
        this.attachedTickables.clear();
        this.attachedPowerTaps.clear();
    }

    protected boolean updateServer() {
        int energyAvailable;
        this.WORLD.field_72984_F.func_76320_a("Extreme Reactors|Turbine");
        this.energyGeneratedLastTick = 0.0f;
        this.fluidConsumedLastTick = 0;
        this.rotorEfficiencyLastTick = 1.0f;
        int steamIn = 0;
        if (this.getActive()) {
            steamIn = Math.min(this.maxIntakeRate, this._inputTank.getFluidAmount());
            if (this.ventStatus == VentStatus.DoNotVent) {
                int availableSpace = this._outputTank.getCapacity() - this._outputTank.getFluidAmount();
                steamIn = Math.min(steamIn, availableSpace);
            }
        }
        if (steamIn > 0 || this.rotorEnergy > 0.0f) {
            float inductionTorque;
            float energyToGenerate;
            float rotorSpeed = this.getRotorSpeed();
            float aerodynamicDragTorque = rotorSpeed * this.bladeDrag;
            float liftTorque = 0.0f;
            if (steamIn > 0) {
                float fluidEnergyDensity = 10.0f;
                int steamToProcess = this.bladeSurfaceArea * inputFluidPerBlade;
                steamToProcess = Math.min(steamToProcess, steamIn);
                liftTorque = (float)steamToProcess * fluidEnergyDensity;
                if (steamToProcess < steamIn) {
                    steamToProcess = steamIn - steamToProcess;
                    float bladeEfficiency = 1.0f;
                    int neededBlades = steamIn / inputFluidPerBlade;
                    int missingBlades = neededBlades - this.bladeSurfaceArea;
                    bladeEfficiency = 1.0f - (float)missingBlades / (float)neededBlades;
                    this.rotorEfficiencyLastTick = (liftTorque += (float)steamToProcess * fluidEnergyDensity * bladeEfficiency) / ((float)steamIn * fluidEnergyDensity);
                }
            }
            if ((energyToGenerate = (float)Math.pow(inductionTorque = this.inductorEngaged ? rotorSpeed * this.inductorDragCoefficient * (float)this.coilSize : 0.0f, this.inductionEnergyExponentBonus) * this.inductionEfficiency) > 0.0f) {
                float efficiency = (float)(0.25 * Math.cos((double)rotorSpeed / 142.94246573833559)) + 0.75f;
                if (rotorSpeed < 500.0f) {
                    efficiency = Math.min(0.5f, efficiency);
                }
                this.generateEnergy(energyToGenerate * efficiency);
            }
            this.rotorEnergy += liftTorque + -1.0f * inductionTorque + -1.0f * aerodynamicDragTorque + -1.0f * this.frictionalDrag;
            if (this.rotorEnergy < 0.0f) {
                this.rotorEnergy = 0.0f;
            }
            if (steamIn > 0) {
                this.fluidConsumedLastTick = steamIn;
                this._inputTank.drainInternal(steamIn, true);
                if (this.ventStatus != VentStatus.VentAll) {
                    Fluid effluent = FluidRegistry.WATER;
                    FluidStack effluentStack = new FluidStack(effluent, steamIn);
                    this._outputTank.fillInternal(effluentStack, true);
                }
            }
        }
        int energyRemaining = energyAvailable = (int)this.getEnergyStored();
        if (this.energyStored > 0.0f && this.attachedPowerTaps.size() > 0) {
            this.WORLD.field_72984_F.func_76320_a("Extreme Reactors|Turbine|SendPower");
            int splitEnergy = energyRemaining / this.attachedPowerTaps.size();
            for (TileEntityTurbinePowerTap powerTap : this.attachedPowerTaps) {
                if (energyRemaining <= 0) break;
                if (powerTap == null || !powerTap.isConnected()) continue;
                energyRemaining = (int)((long)energyRemaining - ((long)splitEnergy - powerTap.onProvidePower(splitEnergy)));
            }
            if (energyRemaining > 0) {
                for (TileEntityTurbinePowerTap powerTap : this.attachedPowerTaps) {
                    if (energyRemaining <= 0) break;
                    if (powerTap == null || !powerTap.isConnected()) continue;
                    energyRemaining = (int)powerTap.onProvidePower(energyRemaining);
                }
            }
            this.WORLD.field_72984_F.func_76319_b();
        }
        if (energyAvailable != energyRemaining) {
            this.reduceStoredEnergy(energyAvailable - energyRemaining);
        }
        this.WORLD.field_72984_F.func_76320_a("Extreme Reactors|Turbine|Tickables");
        for (ITickableMultiblockPart part : this.attachedTickables) {
            part.onMultiblockServerTick();
        }
        this.WORLD.field_72984_F.func_76318_c("Extreme Reactors|Turbine|Updates");
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate >= 3) {
            this.sendTickUpdate();
            this.ticksSinceLastUpdate = 0;
        }
        if (this.rpmUpdateTracker.shouldUpdate(this.getRotorSpeed())) {
            this.markReferenceCoordDirty();
        }
        this.WORLD.field_72984_F.func_76319_b();
        this.WORLD.field_72984_F.func_76319_b();
        return this.energyGeneratedLastTick > 0.0f || this.fluidConsumedLastTick > 0;
    }

    protected void updateClient() {
    }

    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        if (data.func_74764_b("inputTank")) {
            this._inputTank.readFromNBT(data.func_74775_l("inputTank"));
        }
        if (data.func_74764_b("outputTank")) {
            this._outputTank.readFromNBT(data.func_74775_l("outputTank"));
        }
        if (data.func_74764_b("active")) {
            this.setActive(data.func_74767_n("active"));
        }
        if (data.func_74764_b("energy")) {
            this.setEnergyStored(data.func_74760_g("energy"));
        }
        if (data.func_74764_b("ventStatus")) {
            this.setVentStatus(VentStatus.values()[data.func_74762_e("ventStatus")], false);
        }
        if (data.func_74764_b("rotorEnergy")) {
            this.setRotorEnergy(data.func_74760_g("rotorEnergy"));
            if (!this.WORLD.field_72995_K) {
                this.rpmUpdateTracker.setValue(this.getRotorSpeed());
            }
        }
        if (data.func_74764_b("maxIntakeRate")) {
            this.maxIntakeRate = data.func_74762_e("maxIntakeRate");
        }
        if (data.func_74764_b("inductorEngaged")) {
            this.setInductorEngaged(data.func_74767_n("inductorEngaged"), false);
        }
    }

    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        data.func_74782_a("inputTank", (NBTBase)this._inputTank.writeToNBT(new NBTTagCompound()));
        data.func_74782_a("outputTank", (NBTBase)this._outputTank.writeToNBT(new NBTTagCompound()));
        data.func_74757_a("active", this.active);
        data.func_74776_a("energy", this.energyStored);
        data.func_74768_a("ventStatus", this.ventStatus.ordinal());
        data.func_74776_a("rotorEnergy", this.rotorEnergy);
        data.func_74768_a("maxIntakeRate", this.maxIntakeRate);
        data.func_74757_a("inductorEngaged", this.inductorEngaged);
    }

    public void serialize(ByteBuf buf) {
        int outputFluidAmt;
        String outputFluidID;
        int inputFluidAmt;
        String inputFluidID;
        FluidStack inputFluid = this._inputTank.getFluid();
        FluidStack outputFluid = this._outputTank.getFluid();
        if (inputFluid == null || inputFluid.amount <= 0) {
            inputFluidID = "";
            inputFluidAmt = 0;
        } else {
            inputFluidID = inputFluid.getFluid().getName();
            inputFluidAmt = inputFluid.amount;
        }
        if (outputFluid == null || outputFluid.amount <= 0) {
            outputFluidID = "";
            outputFluidAmt = 0;
        } else {
            outputFluidID = outputFluid.getFluid().getName();
            outputFluidAmt = outputFluid.amount;
        }
        buf.writeBoolean(this.active);
        buf.writeBoolean(this.inductorEngaged);
        buf.writeInt(this.ventStatus.ordinal());
        buf.writeInt(this.maxIntakeRate);
        buf.writeFloat(this.energyStored);
        buf.writeFloat(this.rotorEnergy);
        buf.writeFloat(this.energyGeneratedLastTick);
        buf.writeInt(this.fluidConsumedLastTick);
        buf.writeFloat(this.rotorEfficiencyLastTick);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)inputFluidID);
        buf.writeInt(inputFluidAmt);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)outputFluidID);
        buf.writeInt(outputFluidAmt);
    }

    public void deserialize(ByteBuf buf) {
        Fluid fluid;
        this.setActive(buf.readBoolean());
        this.setInductorEngaged(buf.readBoolean(), false);
        this.setVentStatus(s_VentStatuses[buf.readInt()], false);
        this.setMaxIntakeRate(buf.readInt());
        this.setEnergyStored(buf.readFloat());
        this.setRotorEnergy(buf.readFloat());
        this.energyGeneratedLastTick = buf.readFloat();
        this.fluidConsumedLastTick = buf.readInt();
        this.rotorEfficiencyLastTick = buf.readFloat();
        String inputFluidID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int inputFluidAmt = buf.readInt();
        String outputFluidID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int outputFluidAmt = buf.readInt();
        if (inputFluidID.isEmpty() || inputFluidAmt <= 0) {
            this._inputTank.setFluid(null);
        } else {
            fluid = FluidRegistry.getFluid((String)inputFluidID);
            if (fluid == null) {
                BRLog.warning("[CLIENT] Multiblock Turbine received an unknown fluid of type %d, setting input tank to empty", inputFluidID);
                this._inputTank.setFluid(null);
            } else {
                this._inputTank.setFluid(new FluidStack(fluid, inputFluidAmt));
            }
        }
        if (outputFluidID.isEmpty() || outputFluidAmt <= 0) {
            this._outputTank.setFluid(null);
        } else {
            fluid = FluidRegistry.getFluid((String)outputFluidID);
            if (fluid == null) {
                BRLog.warning("[CLIENT] Multiblock Turbine received an unknown fluid of type %d, setting output tank to empty", outputFluidID);
                this._outputTank.setFluid(null);
            } else {
                this._outputTank.setFluid(new FluidStack(fluid, outputFluidAmt));
            }
        }
    }

    private void setEnergyStored(float newEnergy) {
        if (Float.isInfinite(newEnergy) || Float.isNaN(newEnergy)) {
            return;
        }
        this.energyStored = Math.max(0.0f, Math.min(1000000.0f, newEnergy));
    }

    protected void reduceStoredEnergy(float energy) {
        this.addStoredEnergy(-1.0f * energy);
    }

    protected void addStoredEnergy(float newEnergy) {
        if (Float.isNaN(newEnergy)) {
            return;
        }
        this.energyStored += newEnergy;
        if (this.energyStored > 1000000.0f) {
            this.energyStored = 1000000.0f;
        }
        if (-1.0E-5f < this.energyStored && this.energyStored < 1.0E-5f) {
            this.energyStored = 0.0f;
        }
    }

    public void setStoredEnergy(float oldEnergy) {
        this.energyStored = oldEnergy;
        if ((double)this.energyStored < 0.0 || Float.isNaN(this.energyStored)) {
            this.energyStored = 0.0f;
        } else if (this.energyStored > 1000000.0f) {
            this.energyStored = 1000000.0f;
        }
    }

    protected void generateEnergy(float newEnergy) {
        newEnergy = newEnergy * BigReactors.CONFIG.powerProductionMultiplier * BigReactors.CONFIG.turbinePowerProductionMultiplier;
        this.energyGeneratedLastTick += newEnergy;
        this.addStoredEnergy(newEnergy);
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean newValue) {
        if (newValue == this.active) {
            return;
        }
        this.active = newValue;
        for (IMultiblockPart iMultiblockPart : this.connectedParts) {
            if (this.active) {
                iMultiblockPart.onMachineActivated();
                continue;
            }
            iMultiblockPart.onMachineDeactivated();
        }
        WorldHelper.notifyBlockUpdate((World)this.WORLD, (BlockPos)this.getReferenceCoord(), null, null);
        this.markReferenceCoordDirty();
        if (WorldHelper.calledByLogicalClient((World)this.WORLD)) {
            for (IMultiblockPart iMultiblockPart : this.attachedControllers) {
                WorldHelper.notifyBlockUpdate((World)this.WORLD, (BlockPos)iMultiblockPart.getWorldPosition(), null, null);
            }
            for (TileEntityTurbineRotorBlade tileEntityTurbineRotorBlade : this.attachedRotorBlades) {
                WorldHelper.notifyBlockUpdate((World)this.WORLD, (BlockPos)tileEntityTurbineRotorBlade.getWorldPosition(), null, null);
            }
            for (TileEntityTurbineRotorShaft tileEntityTurbineRotorShaft : this.attachedRotorShafts) {
                WorldHelper.notifyBlockUpdate((World)this.WORLD, (BlockPos)tileEntityTurbineRotorShaft.getWorldPosition(), null, null);
            }
            for (TileEntityTurbineRotorBearing tileEntityTurbineRotorBearing : this.attachedRotorBearings) {
                tileEntityTurbineRotorBearing.resetRotorInfo();
            }
        }
    }

    public int getMaxIntakeRate() {
        return this.maxIntakeRate;
    }

    public void setMaxIntakeRate(int newRate) {
        this.maxIntakeRate = Math.min(2000, Math.max(0, newRate));
        this.markReferenceCoordDirty();
    }

    public int getMaxIntakeRateMax() {
        return 2000;
    }

    @Override
    public void beginUpdatingPlayer(EntityPlayer playerToUpdate) {
        this.updatePlayers.add(playerToUpdate);
        this.sendIndividualUpdate(playerToUpdate);
    }

    @Override
    public void stopUpdatingPlayer(EntityPlayer playerToRemove) {
        this.updatePlayers.remove(playerToRemove);
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        return true;
    }

    private CoilPartData getCoilPartData(IBlockState coilState) {
        Block block = coilState.func_177230_c();
        String oreName = Blocks.field_150339_S == block ? "blockIron" : (Blocks.field_150340_R == block ? "blockGold" : (BlockBRMetal.isMetal(coilState, MetalType.Ludicrite) ? "blockLudicrite" : OreDictionaryHelper.getFirstOreName((IBlockState)coilState)));
        return TurbineCoil.getBlockData(oreName);
    }

    private void recalculateDerivedStatistics() {
        BlockPos minInterior = this.getMinimumCoord().func_177982_a(1, 1, 1);
        BlockPos maxInterior = this.getMaximumCoord().func_177982_a(-1, -1, -1);
        this.rotorMass = 0;
        this.bladeSurfaceArea = 0;
        this.coilSize = 0;
        float coilEfficiency = 0.0f;
        float coilBonus = 0.0f;
        float coilDragCoefficient = 0.0f;
        int maxX = maxInterior.func_177958_n();
        int maxY = maxInterior.func_177956_o();
        int maxZ = maxInterior.func_177952_p();
        for (int x = minInterior.func_177958_n(); x <= maxX; ++x) {
            for (int y = minInterior.func_177956_o(); y <= maxY; ++y) {
                for (int z = minInterior.func_177952_p(); z <= maxZ; ++z) {
                    CoilPartData coilData;
                    IBlockState state = this.WORLD.func_180495_p(new BlockPos(x, y, z));
                    Block block = state.func_177230_c();
                    if (block instanceof ITurbineRotorPart) {
                        ITurbineRotorPart rotorPart = (ITurbineRotorPart)block;
                        this.rotorMass += rotorPart.getMass(state);
                        if (rotorPart.isBlade()) {
                            ++this.bladeSurfaceArea;
                        }
                    }
                    if ((coilData = this.getCoilPartData(state)) == null) continue;
                    coilEfficiency += coilData.efficiency;
                    coilBonus += coilData.bonus;
                    coilDragCoefficient += coilData.energyExtractionRate;
                    ++this.coilSize;
                }
            }
        }
        this.frictionalDrag = (float)this.rotorMass * this.rotorDragCoefficient * BigReactors.CONFIG.turbineMassDragMultiplier;
        this.bladeDrag = 2.5E-4f * (float)this.bladeSurfaceArea * BigReactors.CONFIG.turbineAeroDragMultiplier;
        if (this.coilSize <= 0) {
            this.inductionEfficiency = 0.0f;
            this.inductionEnergyExponentBonus = 1.0f;
            this.inductorDragCoefficient = 0.0f;
        } else {
            this.inductionEfficiency = coilEfficiency * 0.33f / (float)this.coilSize;
            this.inductionEnergyExponentBonus = Math.max(1.0f, coilBonus / (float)this.coilSize);
            this.inductorDragCoefficient = coilDragCoefficient / (float)this.coilSize * inductorBaseDragCoefficient;
        }
    }

    public float getRotorSpeed() {
        if (this.attachedRotorBlades.size() <= 0 || this.rotorMass <= 0) {
            return 0.0f;
        }
        return this.rotorEnergy / (float)(this.attachedRotorBlades.size() * this.rotorMass);
    }

    public float getEnergyGeneratedLastTick() {
        return this.energyGeneratedLastTick;
    }

    public int getFluidConsumedLastTick() {
        return this.fluidConsumedLastTick;
    }

    public int getNumRotorBlades() {
        return this.attachedRotorBlades.size();
    }

    public float getRotorEfficiencyLastTick() {
        return this.rotorEfficiencyLastTick;
    }

    public float getMaxRotorSpeed() {
        return 2000.0f;
    }

    public int getRotorMass() {
        return this.rotorMass;
    }

    public VentStatus getVentSetting() {
        return this.ventStatus;
    }

    public void setVentStatus(VentStatus newStatus, boolean markReferenceCoordDirty) {
        this.ventStatus = newStatus;
        if (markReferenceCoordDirty) {
            this.markReferenceCoordDirty();
        }
    }

    public boolean getInductorEngaged() {
        return this.inductorEngaged;
    }

    public void setInductorEngaged(boolean engaged, boolean markReferenceCoordDirty) {
        this.inductorEngaged = engaged;
        if (markReferenceCoordDirty) {
            this.markReferenceCoordDirty();
        }
    }

    private void setRotorEnergy(float newEnergy) {
        if (Float.isNaN(newEnergy) || Float.isInfinite(newEnergy)) {
            return;
        }
        this.rotorEnergy = Math.max(0.0f, newEnergy);
    }

    protected void markReferenceCoordDirty() {
        if (this.WORLD == null || this.WORLD.field_72995_K) {
            return;
        }
        BlockPos referenceCoord = this.getReferenceCoord();
        if (referenceCoord == null) {
            return;
        }
        this.rpmUpdateTracker.onExternalUpdate();
        TileEntity saveTe = this.WORLD.func_175625_s(referenceCoord);
        this.WORLD.func_175646_b(referenceCoord, saveTe);
        WorldHelper.notifyBlockUpdate((World)this.WORLD, (BlockPos)referenceCoord, null, null);
    }

    public boolean isInteriorInvisible() {
        return this._interiorInvisible;
    }

    public boolean isAssembledAndActive() {
        return this.assemblyState == MultiblockControllerBase.AssemblyState.Assembled && this.active;
    }

    @SideOnly(value=Side.CLIENT)
    public void resetCachedRotors() {
        for (TileEntityTurbineRotorBearing bearing : this.attachedRotorBearings) {
            bearing.clearDisplayList();
        }
    }

    @Override
    public long getEnergyCapacity() {
        return Math.min(1000000L, this._powerSystem.maxCapacity);
    }

    @Override
    public long getEnergyStored() {
        return (long)this.energyStored;
    }

    @Override
    public long extractEnergy(long maxEnergy, boolean simulate) {
        long removed = (long)Math.min((float)maxEnergy, this.energyStored);
        if (!simulate) {
            this.reduceStoredEnergy(removed);
        }
        return removed;
    }

    @Override
    public PowerSystem getPowerSystem() {
        return this._powerSystem;
    }

    public PartTier getMachineTier() {
        return this._partsTier;
    }

    protected void switchPowerSystem(PowerSystem newPowerSystem) {
        this._powerSystem = newPowerSystem;
        if (this.energyStored > (float)this._powerSystem.maxCapacity) {
            this.energyStored = this._powerSystem.maxCapacity;
        }
    }

    public IFluidHandler getFluidHandler(IInputOutputPort.Direction direction) {
        return IInputOutputPort.Direction.Input == direction ? this._inputTank : this._outputTank;
    }

    public void getDebugMessages(IDebugMessages messages) {
        boolean assembled = this.isAssembled();
        messages.add("debug.bigreactors.assembled", new Object[]{CodeHelper.i18nValue((boolean)assembled)});
        messages.add("debug.bigreactors.attached", new Object[]{Integer.toString(this.connectedParts.size())});
        ValidationError lastError = this.getLastError();
        if (null != lastError) {
            messages.add("debug.bigreactors.lastvalidationerror", new Object[]{lastError.getChatMessage()});
        }
        if (assembled) {
            messages.add("debug.bigreactors.active", new Object[]{CodeHelper.i18nValue((boolean)this.getActive())});
            messages.add("debug.bigreactors.storedenergy", new Object[]{this.getEnergyStored(), this.getPowerSystem().unitOfMeasure});
            messages.add("debug.bigreactors.turbine.rotorenergy", new Object[]{Float.valueOf(this.rotorEnergy)});
            messages.add("debug.bigreactors.turbine.rotorspeed", new Object[]{Float.valueOf(this.getRotorSpeed())});
            messages.add("debug.bigreactors.turbine.inductorengaged", new Object[]{CodeHelper.i18nValue((boolean)this.inductorEngaged)});
            messages.add("debug.bigreactors.turbine.ventstatus", new Object[]{this.ventStatus.toString()});
            messages.add("debug.bigreactors.turbine.maxintakerate", new Object[]{this.maxIntakeRate});
            messages.add("debug.bigreactors.turbine.coilsize", new Object[]{this.coilSize});
            messages.add("debug.bigreactors.turbine.rotormass", new Object[]{this.rotorMass});
            messages.add("debug.bigreactors.turbine.bladearea", new Object[]{this.bladeSurfaceArea});
            messages.add("debug.bigreactors.turbine.rotorblades", new Object[]{this.attachedRotorBlades.size()});
            messages.add("debug.bigreactors.turbine.rotorshafts", new Object[]{this.attachedRotorShafts.size()});
            messages.add("debug.bigreactors.turbine.rotordragcoeff", new Object[]{Float.valueOf(this.rotorDragCoefficient)});
            messages.add("debug.bigreactors.turbine.bladedrag", new Object[]{Float.valueOf(this.bladeDrag)});
            messages.add("debug.bigreactors.turbine.frictdrag", new Object[]{Float.valueOf(this.frictionalDrag)});
            messages.add("debug.bigreactors.turbine.fluidtanksInfo", new Object[0]);
            this.getTankDebugMessages(true, this._inputTank, messages);
            this.getTankDebugMessages(false, this._outputTank, messages);
        }
    }

    private void getTankDebugMessages(boolean isInput, FluidTank tank, IDebugMessages messages) {
        FluidStack stack;
        if (null == tank || null == (stack = tank.getFluid())) {
            messages.add(isInput ? "debug.bigreactors.turbine.inputempty" : "debug.bigreactors.turbine.outputempty", new Object[0]);
        } else {
            messages.add(isInput ? "debug.bigreactors.turbine.input" : "debug.bigreactors.turbine.output", new Object[]{stack.getFluid().getName(), stack.amount});
        }
    }

    public static enum VentStatus {
        VentOverflow,
        VentAll,
        DoNotVent;

    }
}

