/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.elements.forestry;

import io.github.drmanganese.topaddons.addons.AddonForestry;
import io.github.drmanganese.topaddons.elements.ElementRenderHelper;
import io.netty.buffer.ByteBuf;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.network.NetworkTools;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ElementForestryFarm
implements IElement {
    private final ItemStack[] farmIcons;
    private String oneDirection;
    private ItemStack[] inventoryStacks;

    public ElementForestryFarm(ItemStack[] farmIcons, String oneDirection, boolean renderInventory, ItemStack[] inventoryStacks) {
        this.farmIcons = farmIcons;
        this.oneDirection = oneDirection;
        this.inventoryStacks = inventoryStacks;
    }

    public ElementForestryFarm(ByteBuf buf) {
        int i;
        this.farmIcons = new ItemStack[5];
        for (i = 0; i < 5; ++i) {
            this.farmIcons[i] = NetworkTools.readItemStack((ByteBuf)buf);
        }
        this.oneDirection = NetworkTools.readString((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.inventoryStacks = new ItemStack[20];
            for (i = 0; i < 20; ++i) {
                this.inventoryStacks[i] = NetworkTools.readItemStack((ByteBuf)buf);
            }
        } else {
            this.inventoryStacks = new ItemStack[0];
        }
    }

    public void render(int x, int y) {
        Minecraft minecraft = Minecraft.func_71410_x();
        int centerX = x + 31;
        int centerY = y + 18;
        ElementForestryFarm.drawPlus(centerX - 22, centerY - 22, centerX + 38, centerY + 38);
        RenderHelper.renderItemStack((Minecraft)minecraft, (RenderItem)minecraft.func_175599_af(), (ItemStack)this.farmIcons[4], (int)centerX, (int)(centerY + 2), (String)"");
        RenderHelper.renderItemStack((Minecraft)minecraft, (RenderItem)minecraft.func_175599_af(), (ItemStack)this.farmIcons[0], (int)centerX, (int)(centerY - 17), (String)this.oneDirection);
        RenderHelper.renderItemStack((Minecraft)minecraft, (RenderItem)minecraft.func_175599_af(), (ItemStack)this.farmIcons[1], (int)(centerX + 19), (int)(centerY + 2), (String)this.nextDirection());
        RenderHelper.renderItemStack((Minecraft)minecraft, (RenderItem)minecraft.func_175599_af(), (ItemStack)this.farmIcons[2], (int)centerX, (int)(centerY + 21), (String)this.nextDirection());
        RenderHelper.renderItemStack((Minecraft)minecraft, (RenderItem)minecraft.func_175599_af(), (ItemStack)this.farmIcons[3], (int)(centerX - 19), (int)(centerY + 2), (String)this.nextDirection());
        this.nextDirection();
        if (this.inventoryStacks.length > 0) {
            int slot;
            int yOffset;
            int xOffset;
            int k;
            int j;
            int i;
            ElementRenderHelper.drawGreyBox(x, y + 60, x + 38, y + 116);
            ElementRenderHelper.drawGreyBox(x + 40, y + 60, x + 78, y + 116);
            ElementRenderHelper.drawGreyBox(x, y + 120, x + 38, y + 158);
            ElementRenderHelper.drawGreyBox(x + 40, y + 120, x + 78, y + 158);
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < 2; ++k) {
                        xOffset = x + 2 + 4 * i + (2 * i + k % 2) * 18;
                        yOffset = y + 62 + j * 18;
                        slot = i * 6 + j * 2 + k;
                        if (this.inventoryStacks[slot].func_77973_b() == Item.func_150898_a((Block)Blocks.field_180401_cv)) continue;
                        RenderHelper.renderItemStack((Minecraft)minecraft, (RenderItem)minecraft.func_175599_af(), (ItemStack)this.inventoryStacks[slot], (int)xOffset, (int)yOffset, (String)(this.inventoryStacks[slot].field_77994_a + ""));
                    }
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 2; ++j) {
                    for (k = 0; k < 2; ++k) {
                        xOffset = x + 2 + 4 * i + (2 * i + k % 2) * 18;
                        yOffset = y + 122 + j * 18;
                        slot = i * 4 + j * 2 + k + 12;
                        if (this.inventoryStacks[slot].func_77973_b() == Item.func_150898_a((Block)Blocks.field_180401_cv)) continue;
                        RenderHelper.renderItemStack((Minecraft)minecraft, (RenderItem)minecraft.func_175599_af(), (ItemStack)this.inventoryStacks[slot], (int)xOffset, (int)yOffset, (String)(this.inventoryStacks[slot].field_77994_a + ""));
                    }
                }
            }
        }
    }

    public int getWidth() {
        return 60;
    }

    public int getHeight() {
        return this.inventoryStacks.length > 0 ? 160 : 60;
    }

    public void toBytes(ByteBuf buf) {
        for (ItemStack farmIcon : this.farmIcons) {
            NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)farmIcon);
        }
        NetworkTools.writeString((ByteBuf)buf, (String)this.oneDirection);
        if (this.inventoryStacks.length > 0) {
            buf.writeBoolean(true);
            for (ItemStack inventoryStack : this.inventoryStacks) {
                if (inventoryStack != null) {
                    NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)inventoryStack);
                    continue;
                }
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)new ItemStack(Blocks.field_180401_cv, 0));
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    public int getID() {
        return AddonForestry.ELEMENT_FARM;
    }

    private String nextDirection() {
        switch (this.oneDirection) {
            case "N": {
                this.oneDirection = "E";
                return "E";
            }
            case "E": {
                this.oneDirection = "S";
                return "S";
            }
            case "S": {
                this.oneDirection = "W";
                return "W";
            }
            case "W": {
                this.oneDirection = "N";
                return "N";
            }
        }
        return this.oneDirection;
    }

    private static void drawPlus(int x1, int y1, int x2, int y2) {
        Gui.func_73734_a((int)(x1 + 21), (int)(y1 + 4), (int)(x2 - 21), (int)(y2 - 37), (int)0x44969696);
        Gui.func_73734_a((int)(x1 + 21), (int)(y1 + 41), (int)(x2 - 21), (int)y2, (int)0x44969696);
        Gui.func_73734_a((int)(x1 + 2), (int)(y1 + 23), (int)(x2 - 2), (int)(y2 - 19), (int)0x44969696);
        RenderHelper.drawHorizontalLine((int)(x1 + 21), (int)(y1 + 3), (int)(x2 - 21), (int)-6908266);
        RenderHelper.drawVerticalLine((int)(x1 + 20), (int)(y1 + 3), (int)(y1 + 23), (int)-6908266);
        RenderHelper.drawVerticalLine((int)(x2 - 21), (int)(y1 + 3), (int)(y1 + 23), (int)-6908266);
        RenderHelper.drawHorizontalLine((int)(x1 + 40), (int)(y1 + 22), (int)(x2 - 2), (int)-6908266);
        RenderHelper.drawVerticalLine((int)(x2 - 2), (int)(y1 + 22), (int)(y1 + 42), (int)-6908266);
        RenderHelper.drawHorizontalLine((int)(x1 + 40), (int)(y1 + 41), (int)(x2 - 2), (int)-6908266);
        RenderHelper.drawVerticalLine((int)(x1 + 20), (int)(y1 + 41), (int)(y1 + 61), (int)-6908266);
        RenderHelper.drawVerticalLine((int)(x2 - 21), (int)(y1 + 41), (int)(y1 + 61), (int)-6908266);
        RenderHelper.drawHorizontalLine((int)(x1 + 21), (int)(y1 + 60), (int)(x2 - 21), (int)-6908266);
        RenderHelper.drawHorizontalLine((int)(x1 + 2), (int)(y1 + 22), (int)(x2 - 40), (int)-6908266);
        RenderHelper.drawVerticalLine((int)(x1 + 1), (int)(y1 + 22), (int)(y1 + 42), (int)-6908266);
        RenderHelper.drawHorizontalLine((int)(x1 + 2), (int)(y1 + 41), (int)(x2 - 40), (int)-6908266);
    }
}

