/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.config;

import io.github.drmanganese.topaddons.TOPAddons;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Config {
    public static void init(Configuration config) {
        config.load();
        BloodMagic.requireSigil = config.getBoolean("requireSigil", "Blood Magic", true, "Is holding a divination sigil required to see certain information.");
        Forge.showTankGauge = config.getBoolean("showTankGauge", "Forge", true, "Show tank gauge for internal tanks on most Tile Entities.");
        Vanilla.noteBlock = config.getBoolean("noteBlockPitch", "Vanilla", true, "Show note block pitch and instrument.");
        Helmets.allHelmetsProbable = config.getBoolean("allHelmetsProbable", "Helmets", true, "All non-blacklisted helmets can be combined with a probe.\n!!! When this is false you can't uncraft previously probified helmets !!!");
        Helmets.access$002(config.getStringList("helmetBlacklist", "Helmets", Helmets.helmetBlacklist, "Put registry names of helmets that shouldn't be combinable with a probe"));
        if (config.hasChanged()) {
            config.save();
        }
        if (Helmets.allHelmetsProbable) {
            Config.updateHelmetBlacklist();
            TOPAddons.LOGGER.info("Config: allHelmetProbable is enabled, edit blacklist to restrict.");
        } else {
            TOPAddons.LOGGER.info("Config: allHelmetProbable is disabled, only supported helmets will be \"probable\".");
        }
    }

    public static void updateHelmetBlacklistConfig() {
        String[] helmetBlacklist = new String[Helmets.helmetBlacklistSet.size()];
        Iterator<ResourceLocation> itr = Helmets.helmetBlacklistSet.iterator();
        int i = 0;
        while (itr.hasNext()) {
            helmetBlacklist[i] = itr.next().toString();
            ++i;
        }
        Helmets.access$002(helmetBlacklist);
        TOPAddons.config.get("Helmets", "helmetBlacklist", helmetBlacklist).set(helmetBlacklist);
        TOPAddons.config.save();
    }

    public static void updateHelmetBlacklist() {
        for (String s : Helmets.helmetBlacklist) {
            ResourceLocation r = new ResourceLocation(s);
            if (ForgeRegistries.ITEMS.containsKey(r)) {
                if (ForgeRegistries.ITEMS.getValue(r) instanceof ItemArmor) {
                    Helmets.helmetBlacklistSet.add(r);
                    continue;
                }
                TOPAddons.LOGGER.info("Config: " + s + " is not a helmet.");
                continue;
            }
            TOPAddons.LOGGER.info("Config: " + s + " is not present in the registry.");
        }
        TOPAddons.LOGGER.info("Config: Added " + Helmets.helmetBlacklistSet.size() + " helmets to blacklist.");
    }

    public static class Helmets {
        public static boolean allHelmetsProbable = true;
        private static String[] helmetBlacklist = new String[0];
        public static Set<ResourceLocation> helmetBlacklistSet = new LinkedHashSet<ResourceLocation>();
        static final String CATEGORY = "Helmets";

        static /* synthetic */ String[] access$002(String[] x0) {
            helmetBlacklist = x0;
            return x0;
        }
    }

    public static class Vanilla {
        public static boolean noteBlock = true;
        static final String CATEGORY = "Vanilla";
    }

    public static class Forge {
        public static boolean showTankGauge = true;
        static final String CATEGORY = "Forge";
    }

    public static class BloodMagic {
        public static boolean requireSigil = true;
        static final String CATEGORY = "Blood Magic";
    }
}

