/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.common.utils;

import com.mrdimka.hammercore.HammerCore;
import com.mrdimka.hammercore.net.HCNetwork;
import com.mrdimka.hammercore.net.pkt.PacketNoSpamChat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;

public class ChatUtil {
    public static ITextComponent wrap(String s) {
        return new TextComponentString(s);
    }

    public static ITextComponent[] wrap(String ... s) {
        ITextComponent[] ret = new ITextComponent[s.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ChatUtil.wrap(s[i]);
        }
        return ret;
    }

    public static ITextComponent wrapFormatted(String s, Object ... args) {
        return new TextComponentTranslation(s, args);
    }

    public static void sendChat(EntityPlayer player, String ... lines) {
        ChatUtil.sendChat(player, ChatUtil.wrap(lines));
    }

    public static void sendChatUnloc(EntityPlayer player, String ... unlocLines) {
        ChatUtil.sendChat(player, ChatUtil.localizeAll(unlocLines));
    }

    public static void sendChat(EntityPlayer player, ITextComponent ... lines) {
        for (ITextComponent c : lines) {
            player.func_146105_b(c);
        }
    }

    public static void sendNoSpamClientUnloc(String ... unlocLines) {
        ChatUtil.sendNoSpamClient(ChatUtil.localizeAll(unlocLines));
    }

    public static void sendNoSpamClient(String ... lines) {
        ChatUtil.sendNoSpamClient(ChatUtil.wrap(lines));
    }

    public static void sendNoSpamClient(ITextComponent ... lines) {
        HammerCore.renderProxy.sendNoSpamMessages(lines);
    }

    public static void sendNoSpamUnloc(EntityPlayer player, String ... unlocLines) {
        ChatUtil.sendNoSpam(player, ChatUtil.localizeAll(unlocLines));
    }

    public static void sendNoSpam(EntityPlayer player, String ... lines) {
        ChatUtil.sendNoSpam(player, ChatUtil.wrap(lines));
    }

    public static void sendNoSpam(EntityPlayer player, ITextComponent ... lines) {
        if (player instanceof EntityPlayerMP) {
            ChatUtil.sendNoSpam((EntityPlayerMP)player, lines);
        }
    }

    public static void sendNoSpamUnloc(EntityPlayerMP player, String ... unlocLines) {
        ChatUtil.sendNoSpam(player, ChatUtil.localizeAll(unlocLines));
    }

    public static void sendNoSpam(EntityPlayerMP player, String ... lines) {
        ChatUtil.sendNoSpam(player, ChatUtil.wrap(lines));
    }

    public static void sendNoSpam(EntityPlayerMP player, ITextComponent ... lines) {
        if (lines.length > 0) {
            HCNetwork.manager.sendTo(new PacketNoSpamChat(lines), player);
        }
    }

    public static String[] localizeAll(String ... strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = I18n.func_74838_a((String)strings[i]);
        }
        return strings;
    }
}

