/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershot;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershotFlare;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershotHoming;
import blusunrize.immersiveengineering.common.entities.EntityWolfpackShot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemLingeringPotion;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBullet
extends ItemIEBase
implements IEItemInterfaces.ITextureOverride {
    public ItemBullet() {
        super("bullet", 64, "emptyCasing", "emptyShell", "bullet");
        BulletHandler.emptyCasing = new ItemStack((Item)this, 1, 0);
        BulletHandler.emptyShell = new ItemStack((Item)this, 1, 1);
        BulletHandler.basicCartridge = new ItemStack((Item)this, 1, 2);
        BulletHandler.registerBullet("casull", new BulletHandler.DamagingBullet(entities -> IEDamageSources.causeCasullDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_Casull, BulletHandler.emptyCasing, new ResourceLocation("immersiveengineering:items/bullet_casull")));
        BulletHandler.registerBullet("armorPiercing", new BulletHandler.DamagingBullet(entities -> IEDamageSources.causePiercingDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_AP, BulletHandler.emptyCasing, new ResourceLocation("immersiveengineering:items/bullet_armorPiercing")));
        BulletHandler.registerBullet("buckshot", new BulletHandler.DamagingBullet(entities -> IEDamageSources.causeBuckshotDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_Buck, true, false, BulletHandler.emptyShell, new ResourceLocation[]{new ResourceLocation("immersiveengineering:items/bullet_buckshot")}){

            @Override
            public int getProjectileCount(EntityPlayer shooter, ItemStack cartridge) {
                return 10;
            }
        });
        BulletHandler.registerBullet("HE", new BulletHandler.DamagingBullet(null, 0.0f, BulletHandler.emptyCasing, new ResourceLocation[]{new ResourceLocation("immersiveengineering:items/bullet_HE")}){

            @Override
            public void onHitTarget(World world, RayTraceResult target, EntityLivingBase shooter, Entity projectile, boolean headshot) {
                world.func_72876_a((Entity)shooter, projectile.field_70165_t, projectile.field_70163_u, projectile.field_70161_v, 2.0f, false);
            }
        });
        BulletHandler.registerBullet("silver", new BulletHandler.DamagingBullet(entities -> IEDamageSources.causeSilverDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_Silver, BulletHandler.emptyCasing, new ResourceLocation("immersiveengineering:items/bullet_silver")));
        BulletHandler.registerBullet("dragonsbreath", new BulletHandler.DamagingBullet(entities -> IEDamageSources.causeDragonsbreathDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_Dragon, true, true, BulletHandler.emptyShell, new ResourceLocation[]{new ResourceLocation("immersiveengineering:items/bullet_dragonsbreath")}){

            @Override
            public int getProjectileCount(EntityPlayer shooter, ItemStack cartridge) {
                return 30;
            }

            @Override
            public Entity getProjectile(EntityPlayer shooter, ItemStack cartridge, Entity projectile, boolean electro) {
                ((EntityRevolvershot)projectile).setTickLimit(10);
                projectile.func_70015_d(3);
                return projectile;
            }
        });
        BulletHandler.registerBullet("potion", new PotionBullet());
        BulletHandler.registerBullet("flare", new FlareBullet());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack((Item)this, 1, 0));
        list.add(new ItemStack((Item)this, 1, 1));
        for (Map.Entry<String, BulletHandler.IBullet> entry : BulletHandler.registry.entrySet()) {
            if (!entry.getValue().isProperCartridge()) continue;
            ItemStack s = new ItemStack((Item)this, 1, 2);
            ItemNBTHelper.setString(s, "bullet", entry.getKey());
            list.add(s);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.itemFont;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        String key;
        BulletHandler.IBullet bullet;
        if (stack.func_77952_i() == 2 && (bullet = BulletHandler.getBullet(key = ItemNBTHelper.getString(stack, "bullet"))) != null) {
            bullet.addTooltip(stack, player, list, advanced);
        }
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77952_i() == 2) {
            String s = "item.immersiveengineering.bullet.";
            String key = ItemNBTHelper.getString(stack, "bullet");
            s = s + key;
            BulletHandler.IBullet bullet = BulletHandler.getBullet(key);
            if (bullet != null) {
                s = bullet.getUnlocalizedName(stack, s);
            }
            return I18n.func_74838_a((String)(s + ".name")).trim();
        }
        return super.func_77653_i(stack);
    }

    @Override
    public boolean hasCustomItemColours() {
        return true;
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        BulletHandler.IBullet bullet;
        if (stack.func_77960_j() == 2 && ItemNBTHelper.hasKey(stack, "bullet") && (bullet = BulletHandler.getBullet(ItemNBTHelper.getString(stack, "bullet"))) != null) {
            return bullet.getColour(stack, pass);
        }
        return super.getColourForIEItem(stack, pass);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getModelCacheKey(ItemStack stack) {
        if (stack.func_77960_j() == 2 && ItemNBTHelper.hasKey(stack, "bullet")) {
            return ItemNBTHelper.getString(stack, "bullet");
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        BulletHandler.IBullet bullet = BulletHandler.getBullet(key);
        if (bullet != null) {
            return Arrays.asList(bullet.getTextures());
        }
        return Arrays.asList(new ResourceLocation("immersiveengieering:items/bullet_casull"));
    }

    public static class WolfpackPartBullet
    extends BulletHandler.DamagingBullet {
        public WolfpackPartBullet() {
            super((Entity[] entities) -> IEDamageSources.causeWolfpackDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_WolfpackPart, BulletHandler.emptyCasing, new ResourceLocation("immersiveengineering:items/bullet_wolfpack"));
        }

        @Override
        public boolean isProperCartridge() {
            return false;
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }
    }

    public static class WolfpackBullet
    extends BulletHandler.DamagingBullet {
        public WolfpackBullet() {
            super((Entity[] entities) -> IEDamageSources.causeWolfpackDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_Wolfpack, BulletHandler.emptyShell, new ResourceLocation("immersiveengineering:items/bullet_wolfpack"));
        }

        @Override
        public void onHitTarget(World world, RayTraceResult target, EntityLivingBase shooter, Entity projectile, boolean headshot) {
            super.onHitTarget(world, target, shooter, projectile, headshot);
            Vec3d v = new Vec3d(-projectile.field_70159_w, -projectile.field_70181_x, -projectile.field_70179_y);
            int split = 6;
            for (int i = 0; i < split; ++i) {
                EntityWolfpackShot bullet;
                float angle = (float)i * (360.0f / (float)split);
                Matrix4 matrix = new Matrix4();
                matrix.rotate(angle, v.field_72450_a, v.field_72448_b, v.field_72449_c);
                Vec3d vecDir = new Vec3d(0.0, 1.0, 0.0);
                vecDir = matrix.apply(vecDir);
                EntityWolfpackShot entityWolfpackShot = bullet = shooter != null ? new EntityWolfpackShot(world, shooter, vecDir.field_72450_a * 1.5, vecDir.field_72448_b * 1.5, vecDir.field_72449_c * 1.5, this, null) : new EntityWolfpackShot(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this);
                if (target.field_72308_g instanceof EntityLivingBase) {
                    bullet.targetOverride = (EntityLivingBase)target.field_72308_g;
                }
                bullet.func_70107_b(target.field_72307_f.field_72450_a + vecDir.field_72450_a, target.field_72307_f.field_72448_b + vecDir.field_72448_b, target.field_72307_f.field_72449_c + vecDir.field_72449_c);
                bullet.field_70159_w = vecDir.field_72450_a * 0.375;
                bullet.field_70181_x = vecDir.field_72448_b * 0.375;
                bullet.field_70179_y = vecDir.field_72449_c * 0.375;
                world.func_72838_d((Entity)bullet);
            }
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }
    }

    public static class HomingBullet
    extends BulletHandler.DamagingBullet {
        public HomingBullet(float damage, ResourceLocation ... textures) {
            super(new Function<Entity[], DamageSource>(){

                @Override
                public DamageSource apply(Entity[] entities) {
                    return IEDamageSources.causeHomingDamage((EntityRevolvershot)entities[0], entities[1]);
                }
            }, damage, BulletHandler.emptyCasing, textures);
        }

        @Override
        public Entity getProjectile(EntityPlayer shooter, ItemStack cartridge, Entity projectile, boolean electro) {
            EntityRevolvershotHoming shot = shooter != null ? new EntityRevolvershotHoming(projectile.field_70170_p, (EntityLivingBase)shooter, projectile.field_70159_w * 1.5, projectile.field_70181_x * 1.5, projectile.field_70179_y * 1.5, this, cartridge) : new EntityRevolvershotHoming(projectile.field_70170_p, projectile.field_70165_t, projectile.field_70163_u, projectile.field_70161_v, 0.0, 0.0, 0.0, this);
            shot.field_70159_w = projectile.field_70159_w;
            shot.field_70181_x = projectile.field_70181_x;
            shot.field_70179_y = projectile.field_70179_y;
            shot.bulletElectro = electro;
            return shot;
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }
    }

    public static class FlareBullet
    implements BulletHandler.IBullet {
        static ResourceLocation[] textures = new ResourceLocation[]{new ResourceLocation("immersiveengineering:items/bullet_flare"), new ResourceLocation("immersiveengineering:items/bullet_flare_layer")};

        @Override
        public Entity getProjectile(EntityPlayer shooter, ItemStack cartridge, Entity projectile, boolean electro) {
            EntityRevolvershotFlare flare = shooter != null ? new EntityRevolvershotFlare(projectile.field_70170_p, (EntityLivingBase)shooter, projectile.field_70159_w * 1.5, projectile.field_70181_x * 1.5, projectile.field_70179_y * 1.5, this, cartridge) : new EntityRevolvershotFlare(projectile.field_70170_p, projectile.field_70165_t, projectile.field_70163_u, projectile.field_70161_v, 0.0, 0.0, 0.0, this);
            flare.field_70159_w = projectile.field_70159_w;
            flare.field_70181_x = projectile.field_70181_x;
            flare.field_70179_y = projectile.field_70179_y;
            flare.bulletElectro = electro;
            flare.colour = this.getColour(cartridge, 1);
            flare.setColourSynced();
            return flare;
        }

        @Override
        public void onHitTarget(World world, RayTraceResult target, EntityLivingBase shooter, Entity projectile, boolean headshot) {
        }

        @Override
        public ItemStack getCasing(ItemStack stack) {
            return BulletHandler.emptyShell;
        }

        @Override
        public ResourceLocation[] getTextures() {
            return textures;
        }

        @Override
        public void addTooltip(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
            if (stack.func_77973_b() instanceof IEItemInterfaces.IColouredItem) {
                String hexCol = Integer.toHexString(((IEItemInterfaces.IColouredItem)stack.func_77973_b()).getColourForIEItem(stack, 1));
                list.add(I18n.func_74837_a((String)"desc.immersiveengineering.info.bullet.flareColour", (Object[])new Object[]{"<hexcol=" + hexCol + ":#" + hexCol + ">"}));
            }
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            if (layer != 1) {
                return -1;
            }
            return ItemNBTHelper.hasKey(stack, "flareColour") ? ItemNBTHelper.getInt(stack, "flareColour") : 13381126;
        }
    }

    public static class PotionBullet
    extends BulletHandler.DamagingBullet {
        public PotionBullet() {
            super((Entity[] entities) -> IEDamageSources.causePotionDamage((EntityRevolvershot)entities[0], entities[1]), Config.IEConfig.Tools.bulletDamage_Potion, BulletHandler.emptyCasing, new ResourceLocation("immersiveengineering:items/bullet_potion"), new ResourceLocation("immersiveengineering:items/bullet_potion_layer"));
        }

        @Override
        public String getUnlocalizedName(ItemStack cartridge, String baseName) {
            ItemStack pot = ItemNBTHelper.getItemStack(cartridge, "potion");
            if (pot != null) {
                if (pot.func_77973_b() instanceof ItemLingeringPotion) {
                    baseName = baseName + ".linger";
                } else if (pot.func_77973_b() instanceof ItemSplashPotion) {
                    baseName = baseName + ".splash";
                }
            }
            return baseName;
        }

        @Override
        public Entity getProjectile(EntityPlayer shooter, ItemStack cartridge, Entity projectile, boolean electro) {
            ((EntityRevolvershot)projectile).bulletPotion = ItemNBTHelper.getItemStack(cartridge, "potion");
            return projectile;
        }

        @Override
        public void onHitTarget(World world, RayTraceResult target, EntityLivingBase shooter, Entity projectile, boolean headshot) {
            super.onHitTarget(world, target, shooter, projectile, headshot);
            EntityRevolvershot bullet = (EntityRevolvershot)projectile;
            if (bullet.bulletPotion != null && bullet.bulletPotion.func_77942_o()) {
                PotionType potionType = PotionUtils.func_185191_c((ItemStack)bullet.bulletPotion);
                List effects = PotionUtils.func_185189_a((ItemStack)bullet.bulletPotion);
                if (effects != null) {
                    if (bullet.bulletPotion.func_77973_b() instanceof ItemLingeringPotion) {
                        EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(bullet.field_70170_p, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v);
                        entityareaeffectcloud.func_184481_a(shooter);
                        entityareaeffectcloud.func_184483_a(3.0f);
                        entityareaeffectcloud.func_184495_b(-0.5f);
                        entityareaeffectcloud.func_184485_d(10);
                        entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
                        entityareaeffectcloud.func_184484_a(potionType);
                        for (PotionEffect potioneffect : effects) {
                            entityareaeffectcloud.func_184496_a(new PotionEffect(potioneffect.func_188419_a(), potioneffect.func_76459_b(), potioneffect.func_76458_c()));
                        }
                        bullet.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
                    } else if (bullet.bulletPotion.func_77973_b() instanceof ItemSplashPotion) {
                        List livingEntities = bullet.field_70170_p.func_72872_a(EntityLivingBase.class, bullet.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0));
                        if (livingEntities != null && !livingEntities.isEmpty()) {
                            for (EntityLivingBase living : livingEntities) {
                                double dist;
                                if (!living.func_184603_cC() || !((dist = bullet.func_70068_e((Entity)living)) < 16.0)) continue;
                                double dist2 = 1.0 - Math.sqrt(dist) / 4.0;
                                if (living == target.field_72308_g) {
                                    dist2 = 1.0;
                                }
                                for (PotionEffect p : effects) {
                                    if (p.func_188419_a().func_76403_b()) {
                                        p.func_188419_a().func_180793_a((Entity)bullet, (Entity)shooter, living, p.func_76458_c(), dist2);
                                        continue;
                                    }
                                    int j = (int)(dist2 * (double)p.func_76459_b() + 0.5);
                                    if (j <= 20) continue;
                                    living.func_70690_d(new PotionEffect(p.func_188419_a(), j, p.func_76458_c()));
                                }
                            }
                        }
                    } else if (target.field_72308_g instanceof EntityLivingBase) {
                        for (PotionEffect p : effects) {
                            if (p.func_76459_b() < 1) {
                                p = new PotionEffect(p.func_188419_a(), 1);
                            }
                            ((EntityLivingBase)target.field_72308_g).func_70690_d(p);
                        }
                    }
                }
                world.func_175718_b(2002, new BlockPos((Entity)bullet), PotionType.func_185171_a((PotionType)potionType));
            }
        }

        @Override
        public void addTooltip(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
            ItemStack pot = ItemNBTHelper.getItemStack(stack, "potion");
            if (pot != null && pot.func_77973_b() instanceof ItemPotion) {
                PotionUtils.func_185182_a((ItemStack)pot, list, (float)1.0f);
            }
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            if (layer == 1) {
                ItemStack pot = ItemNBTHelper.getItemStack(stack, "potion");
                return pot == null ? -13083194 : PotionUtils.func_185181_a((Collection)PotionUtils.func_185189_a((ItemStack)pot));
            }
            return -1;
        }
    }
}

