/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.blocks.BlockIETileProvider;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_Conveyor;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorVertical;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockConveyor
extends BlockIETileProvider<BlockTypes_Conveyor> {
    public static final IUnlistedProperty<ConveyorHandler.IConveyorBelt> ICONEYOR_PASSTHROUGH = new IUnlistedProperty<ConveyorHandler.IConveyorBelt>(){

        public String getName() {
            return "iconveyor_passthrough";
        }

        public boolean isValid(ConveyorHandler.IConveyorBelt value) {
            return true;
        }

        public Class<ConveyorHandler.IConveyorBelt> getType() {
            return ConveyorHandler.IConveyorBelt.class;
        }

        public String valueToString(ConveyorHandler.IConveyorBelt value) {
            return ConveyorHandler.classRegistry.get(value.getClass()).toString();
        }
    };

    public BlockConveyor() {
        super("conveyor", Material.field_151573_f, PropertyEnum.func_177709_a((String)"type", BlockTypes_Conveyor.class), ItemBlockIEBase.class, IEProperties.FACING_ALL, IEProperties.TILEENTITY_PASSTHROUGH, ICONEYOR_PASSTHROUGH);
        this.func_149711_c(3.0f);
        this.func_149752_b(15.0f);
        this.setBlockLayer(BlockRenderLayer.CUTOUT);
        this.setAllNotNormalBlock();
        this.field_149786_r = 0;
        ConveyorHandler.conveyorBlock = this;
    }

    @Override
    public boolean useCustomStateMapper() {
        return true;
    }

    @Override
    public boolean appendPropertiesToState() {
        return false;
    }

    @Override
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (ResourceLocation key : ConveyorHandler.classRegistry.keySet()) {
            ItemStack stack = new ItemStack((Block)this);
            ItemNBTHelper.setString(stack, "conveyorType", key.toString());
            list.add(stack);
        }
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        String subName = ItemNBTHelper.getString(stack, "conveyorType");
        return super.func_149739_a() + "." + subName;
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if ((state = super.getExtendedState(state, world, pos)) instanceof IExtendedBlockState) {
            IExtendedBlockState ext = (IExtendedBlockState)state;
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TileEntityConveyorBelt)) {
                return state;
            }
            state = ext.withProperty(ICONEYOR_PASSTHROUGH, (Object)((TileEntityConveyorBelt)te).getConveyorSubtype());
        }
        return state;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = super.func_176221_a(state, world, pos);
        TileEntity tile = world.func_175625_s(pos);
        return state;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    @Override
    public void onIEBlockPlacedBy(World world, BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer, ItemStack stack) {
        super.onIEBlockPlacedBy(world, pos, state, side, hitX, hitY, hitZ, placer, stack);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityConveyorBelt && !(tile instanceof TileEntityConveyorVertical)) {
            TileEntityConveyorBelt conveyor = (TileEntityConveyorBelt)tile;
            EnumFacing f = conveyor.facing;
            ResourceLocation rl = new ResourceLocation(ItemNBTHelper.getString(stack, "conveyorType"));
            ConveyorHandler.IConveyorBelt subType = ConveyorHandler.getConveyor(rl, conveyor);
            conveyor.setConveyorSubtype(subType);
            tile = world.func_175625_s(pos.func_177972_a(f));
            TileEntity tileUp = world.func_175625_s(pos.func_177972_a(f).func_177982_a(0, 1, 0));
            if (subType != null && (!(tile instanceof ConveyorHandler.IConveyorTile) || ((ConveyorHandler.IConveyorTile)tile).getFacing() == f.func_176734_d()) && tileUp instanceof ConveyorHandler.IConveyorTile && ((ConveyorHandler.IConveyorTile)tileUp).getFacing() != f.func_176734_d() && world.func_175623_d(pos.func_177982_a(0, 1, 0))) {
                subType.setConveyorDirection(ConveyorHandler.ConveyorDirection.UP);
            }
            tile = world.func_175625_s(pos.func_177972_a(f.func_176734_d()).func_177982_a(0, 1, 0));
        }
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityConveyorVertical) {
            return side == ((TileEntityConveyorVertical)te).facing;
        }
        if (te instanceof TileEntityConveyorBelt) {
            return side == EnumFacing.DOWN && (((TileEntityConveyorBelt)te).getConveyorSubtype() == null || ((TileEntityConveyorBelt)te).getConveyorSubtype().getConveyorDirection() == ConveyorHandler.ConveyorDirection.HORIZONTAL);
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityConveyorBelt();
    }

    @Override
    public boolean allowHammerHarvest(IBlockState blockState) {
        return true;
    }

    @Override
    public boolean isToolEffective(String type, IBlockState state) {
        return type.equals("IE_HAMMER") || super.isToolEffective(type, state);
    }
}

