/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.jei;

import java.util.LinkedList;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mods.jei.JEIAddonPlugin;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.jei.JEI")
public class JEI {
    private static LinkedList<JEIHideItemAction> apply = new LinkedList();

    @ZenMethod
    public static void hide(@NotNull IItemStack item) {
        MineTweakerAPI.apply(new JEIHideItemAction(item));
    }

    public static void onJEIStarted() {
        apply.forEach(JEIHideItemAction::doApply);
        apply.clear();
    }

    private static class JEIHideItemAction
    implements IUndoableAction {
        private final IItemStack stack;

        public JEIHideItemAction(IItemStack stack) {
            this.stack = stack;
        }

        @Override
        public void apply() {
            apply.add(this);
        }

        void doApply() {
            if (JEIAddonPlugin.jeiHelpers != null) {
                JEIAddonPlugin.jeiHelpers.getItemBlacklist().addItemToBlacklist(MineTweakerMC.getItemStack(this.stack));
            } else {
                MineTweakerImplementationAPI.logger.logError("JEI not initialized yet!");
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
        }

        @Override
        public String describe() {
            return "Hiding " + this.stack + " in JEI";
        }

        @Override
        public String describeUndo() {
            return "Displaying " + this.stack + " in JEI";
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

