/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.operator.number;

import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceOperator;

public class PieceOperatorPower
extends PieceOperator {
    SpellParam num;
    SpellParam power;

    public PieceOperatorPower(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.num = new ParamNumber("psi.spellparam.base", 4117034, false, false);
        this.addParam(this.num);
        this.power = new ParamNumber("psi.spellparam.power", 0xD22A2A, false, false);
        this.addParam(this.power);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Double d = (Double)this.getParamValue(context, this.num);
        Double p = (Double)this.getParamValue(context, this.power);
        int steps = p.intValue();
        if (steps < 0) {
            throw new SpellRuntimeException("psi.spellerror.negativenumber");
        }
        double dv = 1.0;
        for (int i = 0; i < steps; ++i) {
            dv *= d.doubleValue();
        }
        return dv;
    }

    @Override
    public Class<?> getEvaluationType() {
        return Double.class;
    }
}

